/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImportKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtPrimitiveType;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.config.EMFType;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.config.QvtConfigurationProperty;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ConversionUtils;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.osgi.util.NLS;

public abstract class QvtModule {
    private QvtCompilerOptions myQvtCompilerOptions;

    protected QvtModule() {
    }

    public abstract CompiledUnit getUnit() throws MdaException;

    public abstract Module getModule() throws MdaException;

    public abstract ResourceSet getResourceSet();

    public abstract void cleanup();

    public List<QvtTransformation.TransformationParameter> getParameters() throws MdaException {
        Module module = this.getModule();
        if (!(module instanceof OperationalTransformation)) {
            return Collections.emptyList();
        }
        OperationalTransformation transfModule = (OperationalTransformation)module;
        ImperativeOperation mainMethod = QvtOperationalParserUtil.getMainOperation((Module)module);
        if (!transfModule.isIsBlackbox() && mainMethod == null) {
            return Collections.emptyList();
        }
        ArrayList<QvtTransformation.TransformationParameter> transfParams = new ArrayList<QvtTransformation.TransformationParameter>(transfModule.getModelParameter().size());
        for (ModelParameter modelParam : transfModule.getModelParameter()) {
            MappingParameter refinedParam = this.findMainParameter(mainMethod, modelParam);
            transfParams.add(this.createTransfParam(modelParam, refinedParam));
        }
        if (transfParams.isEmpty() && mainMethod != null) {
            for (EParameter mainParam : mainMethod.getEParameters()) {
                transfParams.add(this.createTransfParam((MappingParameter)mainParam));
            }
            for (EParameter mainParam : mainMethod.getResult()) {
                if (mainParam.getEType() instanceof VoidType) continue;
                transfParams.add(this.createTransfParam((MappingParameter)mainParam));
            }
        }
        return transfParams;
    }

    public QvtCompilerOptions getQvtCompilerOptions() {
        return this.myQvtCompilerOptions;
    }

    public void setQvtCompilerOptions(QvtCompilerOptions options) {
        this.myQvtCompilerOptions = options;
    }

    private QvtTransformation.TransformationParameter createTransfParam(final MappingParameter mainParam) {
        return new QvtTransformation.TransformationParameter(){

            @Override
            public QvtTransformation.TransformationParameter.DirectionKind getDirectionKind() {
                if (mainParam.getKind() == DirectionKind.IN) {
                    return QvtTransformation.TransformationParameter.DirectionKind.IN;
                }
                if (mainParam.getKind() == DirectionKind.OUT) {
                    return QvtTransformation.TransformationParameter.DirectionKind.OUT;
                }
                return QvtTransformation.TransformationParameter.DirectionKind.INOUT;
            }

            @Override
            public String getEntryName() {
                return mainParam.getName() != null ? mainParam.getName() : "";
            }

            @Override
            public EClassifier getEntryType() {
                return mainParam.getEType();
            }

            @Override
            public List<EPackage> getMetamodels() {
                EObject rootContainer = EcoreUtil.getRootContainer((EObject)mainParam.getEType());
                if (rootContainer instanceof EPackage) {
                    return Collections.singletonList((EPackage)rootContainer);
                }
                return Collections.emptyList();
            }

            @Override
            public String getModelTypeName() {
                if (this.getMetamodels().isEmpty()) {
                    return "";
                }
                return this.getMetamodels().get(0).getName();
            }

            @Override
            public String getName() {
                return this.getEntryName();
            }
        };
    }

    private QvtTransformation.TransformationParameter createTransfParam(final ModelParameter modelParam, final MappingParameter refinedParam) {
        return new QvtTransformation.TransformationParameter(){

            @Override
            public QvtTransformation.TransformationParameter.DirectionKind getDirectionKind() {
                if (modelParam.getKind() == DirectionKind.IN) {
                    return QvtTransformation.TransformationParameter.DirectionKind.IN;
                }
                if (modelParam.getKind() == DirectionKind.OUT) {
                    return QvtTransformation.TransformationParameter.DirectionKind.OUT;
                }
                return QvtTransformation.TransformationParameter.DirectionKind.INOUT;
            }

            @Override
            public String getEntryName() {
                return refinedParam != null ? refinedParam.getName() : "";
            }

            @Override
            public EClassifier getEntryType() {
                return refinedParam != null ? refinedParam.getEType() : null;
            }

            @Override
            public List<EPackage> getMetamodels() {
                return ((ModelType)modelParam.getType()).getMetamodel();
            }

            @Override
            public String getModelTypeName() {
                if (modelParam.getEType() instanceof ModelType) {
                    return ((ModelType)modelParam.getEType()).getName();
                }
                return "";
            }

            @Override
            public String getName() {
                return modelParam.getName();
            }
        };
    }

    private MappingParameter findMainParameter(ImperativeOperation mainMethod, ModelParameter modelParam) {
        if (mainMethod != null) {
            for (EParameter mainParam : mainMethod.getEParameters()) {
                if (((MappingParameter)mainParam).getExtent() != modelParam) continue;
                return (MappingParameter)mainParam;
            }
            for (EParameter mainParam : mainMethod.getResult()) {
                if (((MappingParameter)mainParam).getExtent() != modelParam) continue;
                return (MappingParameter)mainParam;
            }
        }
        return null;
    }

    public Set<QvtConfigurationProperty> getConfigurationProperties() throws MdaException {
        CompiledUnit unit = this.getUnit();
        if (unit == null) {
            return Collections.emptySet();
        }
        HashSet<Module> moduleSet = new HashSet<Module>();
        for (Module nextModule : unit.getModules()) {
            this.collectImports(nextModule, ImportKind.EXTENSION, moduleSet);
        }
        LinkedHashSet<QvtConfigurationProperty> propSet = new LinkedHashSet<QvtConfigurationProperty>();
        for (Module m : moduleSet) {
            this.collectProperties(m, propSet);
        }
        return propSet;
    }

    public abstract String toString();

    protected void checkModuleErrors(CompiledUnit unit) throws MdaException {
        List errors = unit.getErrors();
        if (errors.isEmpty()) {
            return;
        }
        MultiStatus multistatus = new MultiStatus("org.eclipse.m2m.qvt.oml.runtime", 1, NLS.bind((String)Messages.TransformationUtil_ParseTransformationError, (Object)this.toString(), (Object)errors.size()), null);
        for (QvtMessage msg : errors) {
            Status status = new Status(msg.getSeverity() == 4 ? 4 : 2, "org.eclipse.m2m.qvt.oml.runtime", 1, msg.toString(), null);
            multistatus.merge((IStatus)status);
        }
        throw new MdaException((IStatus)multistatus);
    }

    private void collectImports(Module module, ImportKind kind, Set<Module> moduleSet) {
        assert (module != null);
        LinkedList<Module> queue = new LinkedList<Module>();
        queue.offer(module);
        while (!queue.isEmpty()) {
            Module m = (Module)queue.poll();
            moduleSet.add(m);
            for (ModuleImport imp : m.getModuleImport()) {
                Module element;
                if (kind != null && kind != imp.getKind() || moduleSet.contains(element = imp.getImportedModule())) continue;
                moduleSet.add(element);
                queue.offer(element);
            }
        }
    }

    private void collectProperties(Module module, Set<QvtConfigurationProperty> propSet) {
        for (EStructuralFeature property : module.getConfigProperty()) {
            EClassifier type = property.getEType();
            if (type instanceof EDataType) {
                ConversionUtils.setupConversionDelegate((EClassifier)type);
                propSet.add(new QvtConfigurationProperty(property.getName(), new EMFType((EDataType)type)));
                continue;
            }
            if (!QvtOperationalUtil.isPrimitiveType((Object)type)) continue;
            propSet.add(new QvtConfigurationProperty(property.getName(), new QvtPrimitiveType(type)));
        }
    }
}

