/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalValidationVisitor;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.ConstructorBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.EntryOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.ObjectExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.util.QVTOperationalVisitor;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AltExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssertExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BlockExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BreakExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.CatchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ComputeExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ContinueExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ForExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeIterateExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.InstantiationExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.LogExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.RaiseExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ReturnExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.SwitchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.TryExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnlinkExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnpackExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.VariableInitExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.WhileExp;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.FeatureCallExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.IteratorExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.parser.ValidationVisitor;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.ocl.utilities.Visitor;

final class CustomOclValidationVisitor
extends ValidationVisitor<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>
implements QVTOperationalVisitor<Boolean> {
    private QvtOperationalValidationVisitor myDelegateVisitor = null;
    private QvtOperationalEnv myEnv;
    private UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> myUml;

    protected CustomOclValidationVisitor(QvtOperationalEnv environment) {
        super((Environment)environment);
        this.myEnv = environment;
        this.myUml = environment.getUMLReflection();
    }

    void setVisitor(QvtOperationalValidationVisitor visitor) {
        this.myDelegateVisitor = visitor;
    }

    public Boolean visitIfExp(IfExp<EClassifier> i) {
        if (this.myDelegateVisitor != null) {
            this.myDelegateVisitor.visitIfExp(i);
            return Boolean.TRUE;
        }
        return super.visitIfExp(i);
    }

    @Override
    public Boolean visitConstructor(Constructor constructor) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitConstructorBody(ConstructorBody constructorBody) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitContextualProperty(ContextualProperty contextualProperty) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitEntryOperation(EntryOperation entryOperation) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitHelper(Helper helper) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitImperativeOperation(ImperativeOperation imperativeOperation) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitLibrary(Library library) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitMappingBody(MappingBody mappingBody) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitMappingCallExp(MappingCallExp mappingCallExp) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitMappingOperation(MappingOperation mappingOperation) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitModelType(ModelType modelType) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitModule(Module module) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitModuleImport(ModuleImport moduleImport) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitObjectExp(ObjectExp objectExp) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitOperationBody(OperationBody operationBody) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitResolveExp(ResolveExp resolveExp) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitResolveInExp(ResolveInExp resolveInExp) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitVarParameter(VarParameter varParameter) {
        return Boolean.TRUE;
    }

    public Boolean visitAltExp(AltExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitAssertExp(AssertExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitAssignExp(AssignExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitBlockExp(BlockExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitBreakExp(BreakExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitCatchtExp(CatchExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitComputeExp(ComputeExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitContinueExp(ContinueExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitDictLiteralExp(DictLiteralExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitDictLiteralPart(DictLiteralPart astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitForExp(ForExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitImperativeIterateExp(ImperativeIterateExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitInstantiationExp(InstantiationExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitLogExp(LogExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitOrderedTupleLiteralExp(OrderedTupleLiteralExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitOrderedTupleLiteralPart(OrderedTupleLiteralPart astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitRaiseExp(RaiseExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitReturnExp(ReturnExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitSwitchExp(SwitchExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitTryExp(TryExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitUnlinkExp(UnlinkExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitUnpackExp(UnpackExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitVariableInitExp(VariableInitExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitWhileExp(WhileExp astNode) {
        return Boolean.TRUE;
    }

    public Boolean visitCollectionLiteralExp(CollectionLiteralExp<EClassifier> cl) {
        if (cl.getType() instanceof ListType) {
            return Boolean.TRUE;
        }
        return super.visitCollectionLiteralExp(cl);
    }

    private String getElementName(Object element) {
        return element == null ? null : this.myUml.getName(element);
    }

    private boolean isStatic(Object feature) {
        return this.myUml != null && this.myUml.isStatic(feature);
    }

    public Boolean visitFeatureCallExp(FeatureCallExp<EClassifier> exp) {
        OCLExpression source;
        if (exp.isMarkedPre() && !this.myEnv.isInPostcondition((OCLExpression)exp)) {
            String message = ValidationMessages.AtPreInPostcondition_ERROR_;
            return this.validatorError(exp, message, "visitFeatureCallExp");
        }
        if (exp.getSource() != null && (source = exp.getSource()).getType() instanceof TypeType) {
            TypeType typeType = (TypeType)source.getType();
            Object feature = null;
            if (exp instanceof OperationCallExp) {
                feature = ((OperationCallExp)exp).getReferredOperation();
                if (!typeType.oclOperations().contains(feature) && !this.isStatic(feature)) {
                    String message = ValidationMessages.bind(ValidationMessages.NonStaticOperation_ERROR_, this.getElementName(feature));
                    return this.validatorError(exp, message, "visitFeatureCallExp");
                }
            } else if (exp instanceof PropertyCallExp && !this.isStatic(feature = ((PropertyCallExp)exp).getReferredProperty())) {
                String message = ValidationMessages.bind(ValidationMessages.NonStaticAttribute_ERROR_, this.getElementName(feature));
                return this.validatorError(exp, message, "visitFeatureCallExp");
            }
        }
        return Boolean.FALSE;
    }

    public Boolean visitOperationCallExp(OperationCallExp<EClassifier, EOperation> oc) {
        EClassifier resultType;
        String message;
        OCLExpression source = oc.getSource();
        EOperation oper = (EOperation)oc.getReferredOperation();
        int opcode = oc.getOperationCode();
        EList args = oc.getArgument();
        if (oper == null) {
            String message2 = ValidationMessages.bind(ValidationMessages.NullOperation_ERROR_, oc.toString());
            return this.validatorError(oc, message2, "visitOperationCallExp");
        }
        if (source == null) {
            String message3 = ValidationMessages.bind(ValidationMessages.NullSourceOperation_ERROR_, oc.toString());
            return this.validatorError(oc, message3, "visitOperationCallExp");
        }
        EClassifier sourceType = (EClassifier)source.getType();
        String operName = this.getElementName(oper);
        for (OCLExpression expr : args) {
            expr.accept((Visitor)this);
        }
        if (this.visitFeatureCallExp((FeatureCallExp<EClassifier>)oc).booleanValue()) {
            return Boolean.TRUE;
        }
        if (opcode == 71 && !this.myEnv.isInPostcondition((OCLExpression)oc)) {
            return this.validatorError(oc, ValidationMessages.OCLIsNewInPostcondition_ERROR_, "visitOperationCallExp");
        }
        source.accept((Visitor)this);
        if (!this.myUml.isQuery((Object)oper)) {
            String message4 = ValidationMessages.bind(ValidationMessages.NonQueryOperation_ERROR_, this.getElementName(oper));
            return this.validatorError(oc, message4, "visitOperationCallExp");
        }
        if (TypeUtil.isStandardLibraryFeature((Environment)this.myEnv, (Object)sourceType, (Object)oper)) {
            if (opcode != OCLStandardLibraryUtil.getOperationCode((String)operName)) {
                message = ValidationMessages.bind(ValidationMessages.IllegalOpcode_ERROR_, operName);
                return this.validatorError(oc, message, "visitOperationCallExp");
            }
            resultType = (EClassifier)TypeUtil.getResultType(oc, (Environment)this.myEnv, (Object)sourceType, (Object)oper, (List)args);
            if (resultType == null) {
                resultType = (EClassifier)this.getOCLType(oper);
            }
        } else if (TypeUtil.isOclAnyOperation((Environment)this.myEnv, (Object)oper)) {
            if (opcode != OCLStandardLibraryUtil.getOclAnyOperationCode((String)operName)) {
                message = ValidationMessages.bind(ValidationMessages.IllegalOpcode_ERROR_, operName);
                return this.validatorError(oc, message, "visitOperationCallExp");
            }
            resultType = (EClassifier)TypeUtil.getResultType(oc, (Environment)this.myEnv, (Object)sourceType, (Object)oper, (List)args);
            if (resultType == null) {
                resultType = (EClassifier)this.getOCLType(oper);
            }
        } else {
            resultType = (EClassifier)TypeUtil.getResultType(oc, (Environment)this.myEnv, (Object)sourceType, (Object)oper, (List)args);
        }
        if (!TypeUtil.exactTypeMatch((Environment)this.myEnv, (Object)resultType, (Object)((EClassifier)oc.getType()))) {
            message = ValidationMessages.bind(ValidationMessages.TypeConformanceOperation_ERROR_, ((EClassifier)oc.getType()).toString());
            return this.validatorError(oc, message, "visitOperationCallExp");
        }
        if (opcode == 28 || opcode == 29) {
            ProblemHandler.Severity sev = ProblemHandler.Severity.OK;
            BasicEnvironment benv = (BasicEnvironment)OCLUtil.getAdapter((Environment)this.myEnv, BasicEnvironment.class);
            if (benv != null) {
                sev = (ProblemHandler.Severity)benv.getValue((Option)ProblemOption.STRING_CASE_CONVERSION);
            }
            if (sev != null && sev != ProblemHandler.Severity.OK) {
                benv.problem(sev, ProblemHandler.Phase.VALIDATOR, ValidationMessages.bind(ValidationMessages.NonStd_Operation_, opcode == 28 ? "String::toLower()" : "String::toUpper()"), "operationCallExp", oc);
            }
        }
        return Boolean.TRUE;
    }

    String getUMLName(Object element) {
        return element == null ? null : this.uml.getName(element);
    }

    public Boolean visitIteratorExp(IteratorExp<EClassifier, EParameter> ie) {
        String message;
        EClassifier type = (EClassifier)ie.getType();
        OCLExpression body = ie.getBody();
        OCLExpression source = ie.getSource();
        EList iterators = ie.getIterator();
        String name = ie.getName();
        if (type == null || name == null || source == null || body == null || iterators.isEmpty()) {
            QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_iterateExpIncomplete, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
            return Boolean.TRUE;
        }
        int opcode = 0;
        if (source.getType() instanceof PredefinedType) {
            opcode = OCLStandardLibraryUtil.getOperationCode((String)name);
        }
        source.accept((Visitor)this);
        body.accept((Visitor)this);
        switch (opcode) {
            case 201: 
            case 202: 
            case 203: {
                if (type == this.env.getOCLStandardLibrary().getBoolean()) break;
                QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_TypeConformanceIteratorResult_ERROR_, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
                return Boolean.TRUE;
            }
        }
        if (opcode == 206) {
            if (source.getType() instanceof SequenceType || source.getType() instanceof OrderedSetType || source.getType() instanceof ListType) {
                if (!(type instanceof SequenceType)) {
                    QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_TypeConformanceCollectSequence_ERROR_, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
                    return Boolean.TRUE;
                }
            } else if (!(type instanceof BagType)) {
                QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_TypeConformanceCollectBag_ERROR_, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
                return Boolean.TRUE;
            }
        }
        switch (opcode) {
            case 209: 
            case 210: {
                if (source.getType() instanceof ListType && type instanceof SequenceType || TypeUtil.exactTypeMatch((Environment)this.env, (Object)type, (Object)((EClassifier)source.getType()))) break;
                QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_TypeConformanceSelectReject_ERROR_, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
                return Boolean.TRUE;
            }
        }
        switch (opcode) {
            case 201: 
            case 202: 
            case 204: 
            case 205: 
            case 209: 
            case 210: {
                if (body.getType() == this.env.getOCLStandardLibrary().getBoolean()) break;
                QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_TypeConformanceIteratorBodyBoolean_ERROR_, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
                return Boolean.TRUE;
            }
        }
        EClassifier sourceType = (EClassifier)source.getType();
        if (!(sourceType instanceof CollectionType)) {
            QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_IteratorSource_ERROR_, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
            return Boolean.TRUE;
        }
        if (opcode == 208) {
            ProblemHandler.Severity sev = ProblemHandler.Severity.OK;
            BasicEnvironment benv = (BasicEnvironment)OCLUtil.getAdapter((Environment)this.env, BasicEnvironment.class);
            if (benv != null && (sev = (ProblemHandler.Severity)benv.getValue((Option)ProblemOption.CLOSURE_ITERATOR)) != null && sev != ProblemHandler.Severity.OK) {
                String message2 = OCLMessages.bind((String)OCLMessages.NonStd_Iterator_, (Object)"closure");
                benv.problem(sev, ProblemHandler.Phase.VALIDATOR, message2, "iteratorExp", ie);
            }
            if (!(type instanceof SetType) && !(type instanceof OrderedSetType)) {
                QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_TypeConformanceClosure_ERROR_, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
                return Boolean.TRUE;
            }
            CollectionType sourceCT = (CollectionType)source.getType();
            CollectionType bodyCT = (CollectionType)type;
            EClassifier sourceElementType = (EClassifier)sourceCT.getElementType();
            EClassifier bodyType = (EClassifier)bodyCT.getElementType();
            if (!TypeUtil.compatibleTypeMatch((Environment)this.env, (Object)bodyType, (Object)sourceElementType)) {
                String message3 = OCLMessages.bind((String)OCLMessages.ElementTypeConformanceClosure_ERROR_, (Object)this.getUMLName(bodyType), (Object)this.getUMLName(sourceElementType));
                return this.validatorError(ie, message3, "visitIteratorExp");
            }
        }
        if (opcode == 211 && !this.uml.isComparable((Object)((EClassifier)body.getType()))) {
            message = OCLMessages.bind((String)OCLMessages.OperationNotFound_ERROR_, (Object)"<", (Object)this.getUMLName(body.getType()));
            return this.validatorError(ie, message, "visitIteratorExp");
        }
        switch (opcode) {
            case 201: 
            case 202: {
                if (iterators.size() <= 2) break;
                message = OCLMessages.bind((String)OCLMessages.TooManyIteratorVariables_ERROR_, (Object)ie.getName());
                return this.validatorError(ie, message, "visitIteratorExp");
            }
            default: {
                if (iterators.size() <= 1) break;
                message = OCLMessages.bind((String)OCLMessages.TooManyIteratorVariables_ERROR_, (Object)ie.getName());
                return this.validatorError(ie, message, "visitIteratorExp");
            }
        }
        for (Variable loopiter : iterators) {
            loopiter.accept((Visitor)this);
            if (loopiter.getInitExpression() != null) {
                QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_IterateExpLoopVarInit_ERROR_, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
                return Boolean.TRUE;
            }
            CollectionType ct = (CollectionType)sourceType;
            if (TypeUtil.exactTypeMatch((Environment)this.env, (Object)((EClassifier)loopiter.getType()), (Object)((EClassifier)ct.getElementType()))) continue;
            QvtOperationalUtil.reportError(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_TypeConformanceIteratorExpLoopVar_ERROR_, new Object[0]), ie.getStartPosition(), ie.getEndPosition());
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public Boolean visitVariableExp(VariableExp<EClassifier, EParameter> variableExp) {
        EParameter param;
        if (variableExp.getType() instanceof TupleType && variableExp.getReferredVariable().getName().equals("result") && (param = (EParameter)variableExp.getReferredVariable().getRepresentedParameter()) == null) {
            QvtOperationalUtil.reportWarning(this.myEnv, NLS.bind(ValidationMessages.QvtOperationalVisitorCS_deprecatedResultTupleAccess, new Object[0]), variableExp.getStartPosition(), variableExp.getEndPosition());
        }
        return super.visitVariableExp(variableExp);
    }
}

