/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.modisco.infra.common.core.internal.resource.IMoDiscoResourceListener;
import org.eclipse.modisco.infra.common.core.internal.resource.MoDiscoResourceSet;

public class MoDiscoResourceListenerGroup {
    private final Map<IMoDiscoResourceListener, HashSet<URI>> listeners = new HashMap<IMoDiscoResourceListener, HashSet<URI>>();
    private final URI watchedResourceUri;

    public MoDiscoResourceListenerGroup(URI watchedResourceUri) {
        this.watchedResourceUri = watchedResourceUri;
        if (MoDiscoResourceSet.DEBUG) {
            String message = String.valueOf(this.getClass().getSimpleName()) + "." + this.getClass().getSimpleName() + "(): " + this.watchedResourceUri;
            System.out.println(message);
        }
    }

    public void notifyChange() {
        if (MoDiscoResourceSet.DEBUG) {
            String message = String.valueOf(this.getClass().getSimpleName()) + ".notifyChange(): " + this.watchedResourceUri + " nbListeners=" + this.listeners.size();
            System.out.println(message);
        }
        ArrayList<1> toDoList = new ArrayList<1>();
        Iterator<IMoDiscoResourceListener> iterator = this.listeners.keySet().iterator();
        while (iterator.hasNext()) {
            IMoDiscoResourceListener iMoDiscoResourceListener;
            final IMoDiscoResourceListener fListener = iMoDiscoResourceListener = iterator.next();
            Iterator<URI> iterator2 = this.listeners.get(iMoDiscoResourceListener).iterator();
            while (iterator2.hasNext()) {
                URI clientUri;
                final URI fClientURI = clientUri = iterator2.next();
                Runnable toDo = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (MoDiscoResourceSet.DEBUG) {
                                System.out.println(String.valueOf(MoDiscoResourceListenerGroup.this.getClass().getSimpleName()) + ".notifyChange(): aListenedResourceHasChanged(changed=" + MoDiscoResourceListenerGroup.this.watchedResourceUri + ", depending=" + fClientURI + ")");
                            }
                            fListener.aListenedResourceHasChanged(MoDiscoResourceListenerGroup.this.watchedResourceUri, fClientURI);
                        }
                        catch (Exception e) {
                            Logger.logError((Throwable)e, (String)("An exception happened while notifying change of: " + MoDiscoResourceListenerGroup.this.watchedResourceUri + " to: " + fListener), (Plugin)CommonModiscoActivator.getDefault());
                        }
                    }
                };
                toDoList.add(toDo);
            }
        }
        for (Runnable runnable : toDoList) {
            runnable.run();
        }
    }

    public void addListener(IMoDiscoResourceListener listener, URI resourceUri) {
        HashSet<Object> list = this.listeners.get(listener);
        if (list == null) {
            list = new HashSet();
            this.listeners.put(listener, list);
        }
        list.add(resourceUri);
    }

    public void remove(IMoDiscoResourceListener listener, URI dependingResource) {
        HashSet<URI> uriSet = this.listeners.get(listener);
        if (uriSet != null) {
            uriSet.remove(dependingResource);
        }
    }
}

