/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.core.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.discovery.catalog.DirectionKind;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.infra.discovery.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.core.internal.catalog.DiscovererRegistry;

public final class DiscoveryManager
implements IDiscoveryManager {
    @Override
    public IDiscoverer<?> createDiscovererImpl(String id) {
        DiscovererDescription discovererDescription = this.getDiscovererDescription(id);
        if (discovererDescription != null) {
            return this.createDiscovererImpl(discovererDescription);
        }
        return null;
    }

    @Override
    public IDiscoverer<?> createDiscovererImpl(DiscovererDescription description) {
        return DiscovererRegistry.INSTANCE.createDiscoverer(description);
    }

    @Override
    public Collection<DiscovererDescription> getApplicableDiscoverers(Object source) {
        HashSet<DiscovererDescription> result = new HashSet<DiscovererDescription>();
        for (DiscovererDescription aDiscoveryHandler : this.getDiscoverers()) {
            if (!this.isApplicable(aDiscoveryHandler, source)) continue;
            result.add(aDiscoveryHandler);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public boolean isApplicable(DiscovererDescription discovererDefinition, Object source) {
        Class discovererSourceType = discovererDefinition.getSourceType();
        IDiscoverer<?> cachedDiscoverer = DiscovererRegistry.INSTANCE.getCachedDiscoverer(discovererDefinition);
        return discovererSourceType != null && discovererSourceType.isInstance(source) && cachedDiscoverer.isApplicableTo(source);
    }

    @Override
    public Collection<DiscovererDescription> getDiscoverers() {
        return DiscovererRegistry.INSTANCE.getDiscovererDescriptions();
    }

    public static DiscovererDescription getDiscovererDescription(Class<?> discovererClass) {
        Collection<DiscovererDescription> discovererDescriptions = DiscovererRegistry.INSTANCE.getDiscovererDescriptions();
        for (DiscovererDescription discovererDescription : discovererDescriptions) {
            if (!discovererClass.equals(discovererDescription.getImplementationType())) continue;
            return discovererDescription;
        }
        return null;
    }

    @Override
    public DiscovererDescription getDiscovererDescription(String id) {
        for (DiscovererDescription discovererDescription : this.getDiscoverers()) {
            if (id == null || !id.equals(discovererDescription.getId())) continue;
            return discovererDescription;
        }
        return null;
    }

    @Override
    public DiscovererDescription getDiscovererDescription(IDiscoverer<?> discoverer) {
        for (DiscovererDescription discovererDescription : this.getDiscoverers()) {
            if (!discovererDescription.getImplementationType().equals(discoverer.getClass())) continue;
            return discovererDescription;
        }
        return null;
    }

    protected static void computeSourceType(DiscovererDescription discovererDescription) {
        Class<?> sourceType = null;
        try {
            Method[] methodArray = discovererDescription.getImplementationType().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method aMethod = methodArray[n2];
                if (aMethod.getName().equals("isApplicableTo") && aMethod.getParameterTypes().length == 1) {
                    Class<?> parameterClass = aMethod.getParameterTypes()[0];
                    if (sourceType == null || parameterClass != Object.class) {
                        sourceType = parameterClass;
                    }
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
        }
        discovererDescription.setSourceType(sourceType);
    }

    @Override
    public boolean canRetrieveValue(DiscovererParameter parameter) {
        boolean result = parameter.getField() != null && Modifier.isPublic((int)parameter.getField().getModifiers());
        result = result || parameter.getGetter() != null && Modifier.isPublic((int)parameter.getGetter().getModifiers());
        return result;
    }

    @Override
    public Object getValue(DiscovererParameter parameter, IDiscoverer<?> discoverer) throws DiscoveryException {
        Object parameterValue;
        block6: {
            parameterValue = null;
            try {
                if (parameter.getField() != null && Modifier.isPublic((int)parameter.getField().getModifiers())) {
                    parameterValue = parameter.getField().get(discoverer);
                    break block6;
                }
                if (parameter.getGetter() != null && Modifier.isPublic((int)parameter.getGetter().getModifiers())) {
                    parameterValue = parameter.getGetter().invoke(discoverer, new Object[0]);
                    break block6;
                }
                throw new DiscoveryException(discoverer.getClass() + " discoverer does not implement public read access to the parameter " + parameter.getId());
            }
            catch (IllegalArgumentException e) {
                throw new DiscoveryException("Illegal parameter value for " + parameter.getId(), e);
            }
            catch (IllegalAccessException e) {
                throw new DiscoveryException("Illegal parameter value for " + parameter.getId(), e);
            }
            catch (InvocationTargetException e) {
                throw new DiscoveryException("Illegal parameter value for " + parameter.getId(), e);
            }
        }
        return parameterValue;
    }

    @Override
    public void setValue(DiscovererParameter parameter, IDiscoverer<?> discoverer, Object parameterValue) throws DiscoveryException {
        block6: {
            try {
                if (parameter.getField() != null && Modifier.isPublic((int)parameter.getField().getModifiers())) {
                    parameter.getField().set(discoverer, parameterValue);
                    break block6;
                }
                if (parameter.getSetter() != null && Modifier.isPublic((int)parameter.getSetter().getModifiers())) {
                    parameter.getSetter().invoke(discoverer, parameterValue);
                    break block6;
                }
                throw new DiscoveryException(discoverer.getClass() + " discoverer does not implement public write access to the parameter " + parameter.getId());
            }
            catch (IllegalArgumentException e) {
                throw new DiscoveryException("Illegal parameter value for " + parameter.getId() + " : " + parameterValue, e);
            }
            catch (IllegalAccessException e) {
                throw new DiscoveryException("Illegal parameter value for " + parameter.getId() + " : " + parameterValue, e);
            }
            catch (InvocationTargetException e) {
                throw new DiscoveryException("Illegal parameter value for " + parameter.getId() + " : " + parameterValue, e);
            }
        }
    }

    @Override
    public void discoverElement(IDiscoverer<?> discoverer, Object source, Map<String, Object> parametersValues, IProgressMonitor monitor) throws DiscoveryException {
        DiscovererDescription discoDesc = this.getDiscovererDescription(discoverer);
        for (Map.Entry<String, Object> entry : parametersValues.entrySet()) {
            DiscovererParameter parameter = discoDesc.getParameterDefinition(entry.getKey());
            if (parameter == null) {
                throw new DiscoveryException("Illegal parameter name : " + entry.getKey() + " for discoverer : " + discoDesc.getId());
            }
            this.setValue(parameter, discoverer, entry.getValue());
        }
        Object progressMonitor = monitor != null ? monitor : new NullProgressMonitor();
        discoverer.discoverElement(source, (IProgressMonitor)progressMonitor);
        for (DiscovererParameter parameter : discoDesc.getParameterDefinitions()) {
            if (!parameter.getDirection().equals((Object)DirectionKind.OUT) && !parameter.getDirection().equals((Object)DirectionKind.INOUT)) continue;
            parametersValues.put(parameter.getId(), this.getValue(parameter, discoverer));
        }
    }

    @Override
    public boolean hasInitialValue(DiscovererParameter parameter, DiscovererDescription discoverer) {
        return parameter.getInitializer() != null && Modifier.isPublic((int)parameter.getInitializer().getModifiers());
    }

    @Override
    public Object getInitialValue(DiscovererParameter parameter, DiscovererDescription discoverer, Object source) throws DiscoveryException {
        Object parameterValue;
        block6: {
            parameterValue = null;
            try {
                if (parameter.getInitializer() != null) {
                    if (!Modifier.isPublic((int)parameter.getInitializer().getModifiers())) {
                        throw new DiscoveryException(discoverer.getClass() + " discoverer does not implement public read access to the parameter initializer " + parameter.getId());
                    }
                    IDiscoverer<?> cachedDiscoverer = DiscovererRegistry.INSTANCE.getCachedDiscoverer(discoverer);
                    parameterValue = parameter.getInitializer().invoke(cachedDiscoverer, source);
                    break block6;
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new DiscoveryException("Illegal parameter initializer for " + parameter.getId(), e);
            }
            catch (IllegalAccessException e) {
                throw new DiscoveryException("Illegal parameter initializer for " + parameter.getId(), e);
            }
            catch (InvocationTargetException e) {
                throw new DiscoveryException("Illegal parameter initializer for " + parameter.getId(), e);
            }
        }
        return parameterValue;
    }
}

