/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.common.core.files.ProjectUtils;
import org.eclipse.modisco.infra.common.core.internal.utils.PluginUtils;
import org.eclipse.modisco.infra.discovery.ui.Activator;
import org.eclipse.modisco.infra.discovery.ui.Messages;
import org.eclipse.modisco.infra.discovery.ui.internal.registry.DiscovererUIRegistry;
import org.eclipse.modisco.infra.discovery.ui.internal.wizards.NewDiscovererMainWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewDiscovererWizard
extends Wizard
implements INewWizard {
    private NewDiscovererMainWizardPage mainPage;
    private IStructuredSelection fSelection;

    public NewDiscovererWizard() {
        this.setWindowTitle(Messages.NewDiscovererWizard_newMoDiscoDiscoverer);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public void addPages() {
        super.addPages();
        if (this.mainPage == null) {
            this.mainPage = new NewDiscovererMainWizardPage();
            this.mainPage.init(this.fSelection);
        }
        this.addPage((IWizardPage)this.mainPage);
    }

    protected NewDiscovererMainWizardPage getMainPage() {
        return this.mainPage;
    }

    public boolean performFinish() {
        if (!this.mainPage.isPageComplete()) {
            return false;
        }
        try {
            this.getMainPage().preFinishPage();
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    NewDiscovererWizard.this.getMainPage().finishPage(monitor);
                }
            });
            IProject project = this.getMainPage().getJavaProject().getProject();
            ArrayList<String> requiredBundles = new ArrayList<String>();
            requiredBundles.add("org.eclipse.modisco.infra.discovery.core");
            requiredBundles.add("org.eclipse.emf.ecore");
            if (this.getMainPage().getInputType().startsWith("org.eclipse.core.resources.")) {
                requiredBundles.add("org.eclipse.core.resources");
            }
            if (this.mainPage.isRegisterPopupMenu()) {
                requiredBundles.add(DiscovererUIRegistry.getInstance().getExtensionPointNamespace());
            }
            PluginUtils.addRequiredBundles((IProject)project, requiredBundles);
            PluginUtils.registerInPluginXML((IProject)project, (String)"org.eclipse.modisco.infra.discovery.core.discoverer", (String)"discoverer", (String[])new String[]{"class", "id"}, (String[])new String[]{this.mainPage.getCreatedType().getFullyQualifiedName(), this.mainPage.getDiscovererName()});
            if (this.mainPage.isRegisterPopupMenu()) {
                PluginUtils.registerInPluginXML((IProject)project, (String)(DiscovererUIRegistry.getInstance().getExtensionPointNamespace() + "." + DiscovererUIRegistry.getInstance().getExtensionPointName()), (String)"discoverer", (String[])new String[]{"discovererID", "label"}, (String[])new String[]{this.mainPage.getDiscovererName(), this.mainPage.getDiscovererLabel()});
            }
            PluginUtils.makeSingleton((IProject)project);
            ProjectUtils.enableAPT((IProject)project);
            IResource resource = this.mainPage.getModifiedResource();
            if (resource != null) {
                BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                this.openResource((IFile)resource);
            }
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return true;
    }

    protected void openResource(final IFile resource) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return;
        }
        Display display = this.getShell().getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                }
                catch (PartInitException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
        });
    }
}

