/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal.io.java.binding;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.java.ASTNode;
import org.eclipse.modisco.java.AbstractMethodInvocation;
import org.eclipse.modisco.java.AnnotationMemberValuePair;
import org.eclipse.modisco.java.AnnotationTypeMemberDeclaration;
import org.eclipse.modisco.java.BreakStatement;
import org.eclipse.modisco.java.ClassFile;
import org.eclipse.modisco.java.Comment;
import org.eclipse.modisco.java.CompilationUnit;
import org.eclipse.modisco.java.ContinueStatement;
import org.eclipse.modisco.java.MethodInvocation;
import org.eclipse.modisco.java.MethodRef;
import org.eclipse.modisco.java.NamedElement;
import org.eclipse.modisco.java.SingleVariableAccess;
import org.eclipse.modisco.java.TypeAccess;
import org.eclipse.modisco.java.UnresolvedItem;
import org.eclipse.modisco.java.UnresolvedLabeledStatement;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.Binding;
import org.eclipse.modisco.java.emf.JavaFactory;
import org.eclipse.modisco.java.internal.util.JavaUtil;

public class PendingElement
implements ASTNode {
    private ASTNode clientNode;
    private String linkName;
    private Binding binding;
    private final JavaFactory factory;

    public PendingElement(JavaFactory factory) {
        this.factory = factory;
    }

    public ASTNode getClientNode() {
        return this.clientNode;
    }

    public void setClientNode(ASTNode clientNode) {
        this.clientNode = clientNode;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public void affectTarget(ASTNode target) {
        if (this.clientNode != null) {
            EStructuralFeature feature = this.clientNode.eClass().getEStructuralFeature(this.linkName);
            if (target instanceof AnnotationTypeMemberDeclaration && this.clientNode instanceof MethodInvocation) {
                this.affectTargetAnnotationTypeMember(target, feature);
            } else {
                this.affectTarget0(feature, target);
            }
        }
    }

    private void affectTargetAnnotationTypeMember(ASTNode target, EStructuralFeature feature) {
        if (target.getOriginalCompilationUnit() != null && target.getOriginalCompilationUnit().getPackage() != null && target.getOriginalCompilationUnit().getPackage().getModel() != null) {
            NamedElement method = this.affectUnresolvedTarget();
            target.getOriginalCompilationUnit().getPackage().getModel().getUnresolvedItems().add((Object)((UnresolvedItem)method));
            method.setName(JavaUtil.getQualifiedName((ASTNode)target));
            method.setProxy(true);
            this.affectTarget0(feature, (ASTNode)method);
        }
    }

    private void affectTarget0(EStructuralFeature feature, ASTNode target) {
        if (feature.isMany()) {
            EList lst = (EList)this.clientNode.eGet(feature);
            try {
                lst.add((Object)target);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        } else {
            try {
                this.clientNode.eSet(feature, (Object)target);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.modisco.java.discoverer", e.getMessage(), (Throwable)e);
                JavaActivator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public NamedElement affectUnresolvedTarget() {
        UnresolvedLabeledStatement target = null;
        if ((this.clientNode instanceof BreakStatement || this.clientNode instanceof ContinueStatement) && this.linkName.equals("label")) {
            target = this.factory.createUnresolvedLabeledStatement();
        } else if ((this.clientNode instanceof MethodRef || this.clientNode instanceof AbstractMethodInvocation) && this.linkName.equals("method")) {
            target = this.factory.createUnresolvedMethodDeclaration();
        } else if (this.clientNode instanceof TypeAccess && this.linkName.equals("type")) {
            target = this.factory.createUnresolvedTypeDeclaration();
        } else if (this.clientNode instanceof SingleVariableAccess && this.linkName.equals("variable")) {
            target = this.factory.createUnresolvedVariableDeclarationFragment();
        } else if (this.clientNode instanceof AnnotationMemberValuePair && this.linkName.equals("member")) {
            target = this.factory.createUnresolvedAnnotationTypeMemberDeclaration();
        }
        if (target == null) {
            target = this.factory.createUnresolvedItem();
        }
        return target;
    }

    public EList<Comment> getComments() {
        return null;
    }

    public CompilationUnit getOriginalCompilationUnit() {
        return null;
    }

    public void setOriginalCompilationUnit(CompilationUnit value) {
    }

    public TreeIterator<EObject> eAllContents() {
        return null;
    }

    public EClass eClass() {
        return null;
    }

    public EObject eContainer() {
        return null;
    }

    public EStructuralFeature eContainingFeature() {
        return null;
    }

    public EReference eContainmentFeature() {
        return null;
    }

    public EList<EObject> eContents() {
        return null;
    }

    public EList<EObject> eCrossReferences() {
        return null;
    }

    public Object eGet(EStructuralFeature feature) {
        return null;
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return null;
    }

    public boolean eIsProxy() {
        return false;
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return false;
    }

    public Resource eResource() {
        return null;
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
    }

    public void eUnset(EStructuralFeature feature) {
    }

    public EList<Adapter> eAdapters() {
        return null;
    }

    public boolean eDeliver() {
        return false;
    }

    public void eNotify(Notification notification) {
    }

    public void eSetDeliver(boolean deliver) {
    }

    public ClassFile getOriginalClassFile() {
        return null;
    }

    public void setOriginalClassFile(ClassFile value) {
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) {
        return null;
    }
}

