/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.workflow.core.internal.defaultengine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.workflow.core.WorkflowModel;
import org.eclipse.modisco.workflow.core.WorkflowModelListener;
import org.eclipse.modisco.workflow.core.internal.Activator;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowModelNotifierImpl;
import org.eclipse.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.modisco.workflow.modiscoworkflow.ModiscoworkflowFactory;
import org.eclipse.modisco.workflow.modiscoworkflow.impl.WorkflowImpl;

public class WorkflowModelImpl
extends WorkflowImpl
implements WorkflowModel {
    private final WorkflowModelNotifierImpl notifier = new WorkflowModelNotifierImpl();

    @Override
    public void addListener(WorkflowModelListener listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void removeListener(WorkflowModelListener listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public Element getElement(int elementIndex) {
        return (Element)this.getElements().get(elementIndex);
    }

    @Override
    public List<Element> getAllElements() {
        return this.getElements();
    }

    @Override
    public void addElement(Element element) {
        this.getElements().add((Object)element);
        this.notifier.elementAdded(element);
    }

    @Override
    public void setElement(int index, Element element) {
        this.getElements().set(index, (Object)element);
        this.notifier.elementInserted(index, element);
    }

    @Override
    public void moveElementUp(int elementIndex) {
        this.getElements().move(elementIndex - 1, elementIndex);
        this.notifier.elementInserted(elementIndex, this.getElement(elementIndex));
        this.notifier.elementInserted(elementIndex - 1, this.getElement(elementIndex - 1));
    }

    @Override
    public void moveElementDown(int elementIndex) {
        this.getElements().move(elementIndex + 1, elementIndex);
        this.notifier.elementInserted(elementIndex, this.getElement(elementIndex));
        this.notifier.elementInserted(elementIndex + 1, this.getElement(elementIndex + 1));
    }

    @Override
    public void removeElement(int elementIndex) {
        this.getElements().remove(elementIndex);
        this.notifier.elementRemoved(elementIndex);
    }

    @Override
    public void initialize(ILaunchConfiguration configuration) {
        try {
            this.setName(configuration.getName());
            this.getElements().clear();
            List strings = configuration.getAttribute("serializedWorkflow", new ArrayList());
            this.getElements().addAll(WorkflowModelImpl.stringListToElementList(strings));
            for (Element element : this.getElements()) {
                this.notifier.elementAdded(element);
            }
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private static final List<Element> stringListToElementList(List<String> stringList) {
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < stringList.size()) {
            Object element = null;
            element = stringList.get(i + 2).equals("org.eclipse.modisco.workflow.launchType") ? ModiscoworkflowFactory.eINSTANCE.createWorkflow() : ModiscoworkflowFactory.eINSTANCE.createWork();
            element.setName(stringList.get(i));
            element.setIndex(Integer.parseInt(stringList.get(i + 1)));
            element.setType(stringList.get(i + 2));
            elements.add((Element)element);
            i += 3;
        }
        return elements;
    }

    @Override
    public void save(ILaunchConfigurationWorkingCopy configuration) {
        this.setName(configuration.getName());
        ArrayList<String> listString = new ArrayList<String>();
        for (Element element : this.getElements()) {
            listString.add(element.getName());
            listString.add(Integer.toString(element.getIndex()));
            listString.add(element.getType());
        }
        configuration.setAttribute("serializedWorkflow", listString);
    }

    @Override
    public void moveResource(String path) {
    }

    @Override
    public void removeResource(String resourcePath) {
    }

    @Override
    public void exportWorkflow(URI outputUri) {
        Resource resource = null;
        ResourceSetImpl resSet = new ResourceSetImpl();
        resource = resSet.createResource(outputUri);
        resource.getContents().add((Object)this);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    @Override
    public void synchronize(List<Element> elementsToSynchronize) {
    }
}

