/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.workflow.core.internal.engine;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.workflow.core.WorkflowExecution;
import org.eclipse.modisco.workflow.core.internal.Activator;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowExecutionImpl;
import org.eclipse.modisco.workflow.core.internal.engine.EngineFactory;

public class EngineFactoryImpl
implements EngineFactory {
    private Map<String, WorkflowExecution> workflowEngines;

    @Override
    public WorkflowExecution getEngine(String engineId) {
        return new WorkflowExecutionImpl();
    }

    private final Map<String, WorkflowExecution> getWorkflowEngines() {
        if (this.workflowEngines == null) {
            this.workflowEngines = new HashMap<String, WorkflowExecution>();
            this.initializeWorkflowEngines();
        }
        return this.workflowEngines;
    }

    private void initializeWorkflowEngines() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.modisco.workflow.engine");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("workflowExecution")) {
                    try {
                        this.getWorkflowEngines().put(extension.getUniqueIdentifier(), (WorkflowExecution)element.createExecutableExtension("class"));
                    }
                    catch (Throwable e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }
}

