/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class EdgesZOrderMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("14.6.0.202109231100");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            boolean isModified = false;
            StringBuilder sb = new StringBuilder(Messages.EdgesZOrderMigrationParticipant_title);
            for (DView dView : dAnalysis.getOwnedViews()) {
                List loadedRepresentationsDescriptors = new DViewQuery(dView).getLoadedRepresentationsDescriptors();
                for (DRepresentationDescriptor descriptor : loadedRepresentationsDescriptors) {
                    DDiagram dDiagram;
                    DDiagramGraphicalQuery query;
                    Option<Diagram> gmfDiagram;
                    DRepresentation rep = descriptor.getRepresentation();
                    if (!(rep instanceof DDiagram) || !(gmfDiagram = (query = new DDiagramGraphicalQuery(dDiagram = (DDiagram)rep)).getAssociatedGMFDiagram()).some()) continue;
                    Collection<Edge> edgesFromSourceTargetOrder = this.getEdgesFromSourceAndTargetOrder((View)gmfDiagram.get());
                    if (!this.sortEdges((Diagram)gmfDiagram.get(), edgesFromSourceTargetOrder)) continue;
                    isModified = true;
                    sb.append(MessageFormat.format(Messages.EdgesZOrderMigrationParticipant_edgesOrderChanged, descriptor.getName()));
                }
            }
            if (isModified) {
                DiagramPlugin.getDefault().logInfo(sb.toString());
            }
        }
    }

    private boolean sortEdges(Diagram gmfDiagram, Collection<Edge> edgesFromSourceTargetOrder) {
        boolean orderHasChanged = false;
        int currentIndex = 0;
        for (Edge edge : edgesFromSourceTargetOrder) {
            List<Edge> edges;
            if (edge != (edges = this.getEdges(gmfDiagram)).get(currentIndex)) {
                gmfDiagram.removeEdge(edge);
                gmfDiagram.insertEdgeAt(edge, currentIndex);
                orderHasChanged = true;
            }
            ++currentIndex;
        }
        return orderHasChanged;
    }

    private Collection<Edge> getEdgesFromSourceAndTargetOrder(View view) {
        LinkedHashSet<Edge> result = new LinkedHashSet<Edge>();
        for (Object child : view.getChildren()) {
            if (!(child instanceof View)) continue;
            View childView = (View)child;
            result.addAll(this.getEdgesFromSourceAndTargetOrder(childView));
            result.addAll((Collection<Edge>)childView.getSourceEdges());
            result.addAll((Collection<Edge>)childView.getTargetEdges());
        }
        return result;
    }

    private List<Edge> getEdges(Diagram gmfDiagram) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)gmfDiagram.getEdges(), Edge.class));
    }

    protected String getMessageMigrationParticipantTitle() {
        return Messages.RepairGMFbendpointsMigrationParticipant_title;
    }
}

