/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.validation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.AbstractConstraintProvider;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.validation.DelegatingModelConstraint;
import org.eclipse.uml2.uml.validation.IEValidatorProvider;

public class DelegatingConstraintProvider
extends AbstractConstraintProvider {
    private static final String E_CATEGORY = "category";
    private static final String A_PATH = "path";
    private static final String E_EVALIDATOR_PROVIDER = "eValidatorProvider";
    private static final String A_CLASS = "class";

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        Set<Category> categories = this.getCategories(config);
        IEValidatorProvider validatorProvider = this.getEValidatorProvider(config);
        String[] stringArray = this.getNamespaceUris();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            EPackage epackage = EPackage.Registry.INSTANCE.getEPackage(next);
            if (epackage == null) {
                UMLPlugin.INSTANCE.log((Object)new Status(2, UMLPlugin.INSTANCE.getSymbolicName(), "No such EPackage available for model validation: " + next));
            } else {
                EValidator validator = validatorProvider.getEValidator(epackage);
                if (validator == null) {
                    UMLPlugin.INSTANCE.log((Object)new Status(2, UMLPlugin.INSTANCE.getSymbolicName(), "No generated validator available for package: " + next));
                } else {
                    EValidator.SubstitutionLabelProvider labelProvider = validatorProvider.getSubstitutionLabelProvider(epackage);
                    try {
                        Iterable<? extends IModelConstraint> constraints = this.createConstraints(config.getNamespaceIdentifier(), epackage, validator, labelProvider);
                        if (!categories.isEmpty()) {
                            Category[] cats = categories.toArray(new Category[categories.size()]);
                            for (IModelConstraint iModelConstraint : constraints) {
                                IConstraintDescriptor desc = iModelConstraint.getDescriptor();
                                int i = 0;
                                while (i < cats.length) {
                                    desc.addCategory(cats[i]);
                                    ++i;
                                }
                            }
                        }
                    }
                    catch (ConstraintExistsException e) {
                        throw new CoreException((IStatus)new Status(4, UMLPlugin.INSTANCE.getSymbolicName(), "Failed to register model validation constraints.", (Throwable)e));
                    }
                }
            }
            ++n2;
        }
    }

    private Set<Category> getCategories(IConfigurationElement config) {
        HashSet<Category> result = new HashSet<Category>();
        IConfigurationElement[] iConfigurationElementArray = config.getChildren(E_CATEGORY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement next = iConfigurationElementArray[n2];
            String path = next.getAttribute(A_PATH);
            if (!UML2Util.isEmpty((String)path)) {
                result.add(CategoryManager.getInstance().getCategory(path));
            }
            ++n2;
        }
        return result;
    }

    private IEValidatorProvider getEValidatorProvider(IConfigurationElement config) {
        IEValidatorProvider result = null;
        IConfigurationElement[] vpConfig = config.getChildren(E_EVALIDATOR_PROVIDER);
        if (vpConfig.length > 0) {
            try {
                Object ext = vpConfig[0].createExecutableExtension(A_CLASS);
                if (ext instanceof IEValidatorProvider) {
                    result = (IEValidatorProvider)ext;
                }
            }
            catch (CoreException e) {
                UMLPlugin.INSTANCE.log((Object)e.getStatus());
            }
        }
        if (result == null) {
            result = new IEValidatorProvider.Default();
        }
        return result;
    }

    private Iterable<? extends IModelConstraint> createConstraints(String namespace, EPackage epackage, EValidator validator, EValidator.SubstitutionLabelProvider labelProvider) throws ConstraintExistsException {
        ArrayList<DelegatingModelConstraint> result = new ArrayList<DelegatingModelConstraint>();
        Matcher m = Pattern.compile("validate\\w+_validate(\\w+)").matcher("");
        HashMap eclasses = new HashMap();
        Method[] methodArray = validator.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method next = methodArray[n2];
            if (Modifier.isPublic(next.getModifiers())) {
                EClass eclass;
                Class<?>[] signature = next.getParameterTypes();
                m.reset(next.getName());
                if (m.matches() && DelegatingConstraintProvider.isConstraintMethod(next.getReturnType(), signature) && (eclass = DelegatingConstraintProvider.getEClass(eclasses, epackage, signature[0])) != null) {
                    result.add(new DelegatingModelConstraint(namespace, validator, labelProvider, eclass, next));
                }
            }
            ++n2;
        }
        this.getConstraints().addAll(result);
        this.registerConstraints(result);
        return result;
    }

    private static boolean isConstraintMethod(Class<?> returnType, Class<?>[] parameterTypes) {
        boolean result = false;
        if (returnType == Boolean.TYPE && parameterTypes.length == 3) {
            result = EObject.class.isAssignableFrom(parameterTypes[0]) && parameterTypes[1] == DiagnosticChain.class && parameterTypes[2] == Map.class;
        }
        return result;
    }

    private static EClass getEClass(Map<Class<?>, EClass> cache, EPackage epackage, Class<?> interfaceType) {
        EClass result = cache.get(interfaceType);
        if (result == null) {
            for (EClassifier next : epackage.getEClassifiers()) {
                if (next.getInstanceClass() != interfaceType || !(next instanceof EClass)) continue;
                result = (EClass)next;
                cache.put(interfaceType, result);
                break;
            }
        }
        return result;
    }
}

