/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.JsEvaluateContextBase;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessageFactory;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.EvaluateMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsValueBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsVariableBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueMirror;
import org.json.simple.JSONValue;

public abstract class JsEvaluateContextImpl
extends JsEvaluateContextBase {
    public RelayOk evaluateAsyncImpl(String expression, Map<String, ? extends JsValue> additionalContext, final JsEvaluateContext.EvaluateCallback callback, SyncCallback syncCallback) throws InternalContext.ContextDismissedCheckedException {
        List<Map.Entry<String, EvaluateMessage.Value>> internalAdditionalContext = JsEvaluateContextImpl.convertAdditionalContextList(additionalContext, this.getInternalContext());
        CallbackInternal callbackInternal = callback == null ? null : new CallbackInternal(){

            @Override
            public void success(final JsValueBase value) {
                JsEvaluateContext.ResultOrException result = new JsEvaluateContext.ResultOrException(){

                    @Override
                    public JsValue getResult() {
                        return value;
                    }

                    @Override
                    public JsValue getException() {
                        return null;
                    }

                    @Override
                    public <R> R accept(JsEvaluateContext.ResultOrException.Visitor<R> visitor) {
                        return visitor.visitResult(value);
                    }
                };
                callback.success(result);
            }

            @Override
            public void exception(final JsValueBase exception) {
                JsEvaluateContext.ResultOrException result = new JsEvaluateContext.ResultOrException(){

                    @Override
                    public JsValue getResult() {
                        return null;
                    }

                    @Override
                    public JsValue getException() {
                        return exception;
                    }

                    @Override
                    public <R> R accept(JsEvaluateContext.ResultOrException.Visitor<R> visitor) {
                        return visitor.visitException(exception);
                    }
                };
                callback.success(result);
            }

            @Override
            public void failure(Exception cause) {
                callback.failure(cause);
            }
        };
        return this.evaluateAsyncInternal(expression, internalAdditionalContext, callbackInternal, syncCallback);
    }

    public RelayOk evaluateAsyncInternal(String expression, List<Map.Entry<String, EvaluateMessage.Value>> internalAdditionalContext, final CallbackInternal callback, SyncCallback syncCallback) throws InternalContext.ContextDismissedCheckedException {
        Integer frameIdentifier = this.getFrameIdentifier();
        Boolean isGlobal = frameIdentifier == null ? Boolean.TRUE : null;
        DebuggerMessage message = DebuggerMessageFactory.evaluate(expression, frameIdentifier, isGlobal, Boolean.TRUE, internalAdditionalContext);
        V8CommandCallbackBase commandCallback = callback == null ? null : new V8CommandCallbackBase(){

            @Override
            public void success(SuccessCommandResponse successResponse) {
                ValueHandle body;
                try {
                    body = successResponse.body().asEvaluateBody();
                }
                catch (JsonProtocolParseException e) {
                    throw new RuntimeException(e);
                }
                InternalContext internalContext = JsEvaluateContextImpl.this.getInternalContext();
                ValueMirror mirror = internalContext.getValueLoader().addDataToMap(body);
                JsValueBase value = JsVariableBase.createValue(internalContext.getValueLoader(), mirror);
                callback.success(value);
            }

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                JsValueBase pseudoException = JsEvaluateContextImpl.this.getValueFactory().createString(message);
                callback.exception(pseudoException);
            }
        };
        return this.getInternalContext().sendV8CommandAsync(message, true, (V8CommandProcessor.V8HandlerCallback)commandCallback, syncCallback);
    }

    @Override
    public RelayOk evaluateAsync(String expression, Map<String, ? extends JsValue> additionalContext, JsEvaluateContext.EvaluateCallback callback, SyncCallback syncCallback) {
        try {
            return this.evaluateAsyncImpl(expression, additionalContext, callback, syncCallback);
        }
        catch (InternalContext.ContextDismissedCheckedException e) {
            return this.maybeRethrowContextException(e, syncCallback);
        }
    }

    @Override
    public PrimitiveValueFactoryImpl getValueFactory() {
        return PrimitiveValueFactoryImpl.INSTANCE;
    }

    private RelayOk maybeRethrowContextException(InternalContext.ContextDismissedCheckedException ex, SyncCallback syncCallback) {
        return this.getInternalContext().getDebugSession().maybeRethrowContextException(ex, syncCallback);
    }

    private static List<Map.Entry<String, EvaluateMessage.Value>> convertAdditionalContextList(Map<String, ? extends JsValue> source, InternalContext internalContext) {
        if (source == null) {
            return null;
        }
        ArrayList<Map.Entry<String, EvaluateMessage.Value>> dataList = new ArrayList<Map.Entry<String, EvaluateMessage.Value>>(source.size());
        for (final Map.Entry<String, ? extends JsValue> en : source.entrySet()) {
            JsValueBase jsValueBase = JsValueBase.cast(en.getValue());
            final EvaluateMessage.Value value = jsValueBase.getJsonParam(internalContext);
            Map.Entry<String, EvaluateMessage.Value> convertedEntry = new Map.Entry<String, EvaluateMessage.Value>(){

                @Override
                public String getKey() {
                    return (String)en.getKey();
                }

                @Override
                public EvaluateMessage.Value getValue() {
                    return value;
                }

                @Override
                public EvaluateMessage.Value setValue(EvaluateMessage.Value value2) {
                    throw new UnsupportedOperationException();
                }
            };
            dataList.add(convertedEntry);
        }
        return dataList;
    }

    protected abstract Integer getFrameIdentifier();

    protected abstract InternalContext getInternalContext();

    public static interface CallbackInternal {
        public void success(JsValueBase var1);

        public void exception(JsValueBase var1);

        public void failure(Exception var1);
    }

    public static class PrimitiveValueFactoryImpl
    implements JsEvaluateContext.PrimitiveValueFactory {
        private static final PrimitiveValueFactoryImpl INSTANCE = new PrimitiveValueFactoryImpl();

        @Override
        public JsValue getUndefined() {
            return new JsValueBase.Impl(JsValue.Type.TYPE_UNDEFINED, null);
        }

        @Override
        public JsValue getNull() {
            return new JsValueBase.Impl(JsValue.Type.TYPE_NULL, null);
        }

        @Override
        public JsValueBase createString(String value) {
            return new JsValueBase.Impl(JsValue.Type.TYPE_STRING, value);
        }

        @Override
        public JsValue createNumber(double value) {
            return new JsValueBase.Impl(JsValue.Type.TYPE_NUMBER, JSONValue.toJSONString((Object)value));
        }

        @Override
        public JsValue createNumber(long value) {
            return new JsValueBase.Impl(JsValue.Type.TYPE_NUMBER, JSONValue.toJSONString((Object)value));
        }

        @Override
        public JsValue createNumber(String stringRepresentation) {
            return new JsValueBase.Impl(JsValue.Type.TYPE_NUMBER, stringRepresentation);
        }

        @Override
        public JsValue createBoolean(boolean value) {
            return new JsValueBase.Impl(JsValue.Type.TYPE_BOOLEAN, JSONValue.toJSONString((Object)value));
        }
    }
}

