/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EmptyTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeUniverseSet;

public class TypeSetEnvironment {
    private final TypeEnvironment fTypeEnvironment;
    private final TypeUniverseSet fUniverse;
    private final EmptyTypeSet fEmptyTypeSet;
    private final Map fSubtypesOfSingletons = new LinkedHashMap();
    private final Map fSubTypesSets = new LinkedHashMap();
    private final Map fSuperTypesOfSingletons = new LinkedHashMap();
    private final Map fSuperTypesSets = new LinkedHashMap();
    private int fgCommonExprHits = 0;
    private int fgCommonExprMisses = 0;

    public TypeSetEnvironment(TypeEnvironment typeEnvironment) {
        this.fTypeEnvironment = typeEnvironment;
        this.fUniverse = new TypeUniverseSet(this);
        this.fEmptyTypeSet = new EmptyTypeSet(this);
    }

    public TType getJavaLangObject() {
        return this.fTypeEnvironment.getJavaLangObject();
    }

    public TypeUniverseSet getUniverseTypeSet() {
        return this.fUniverse;
    }

    public EmptyTypeSet getEmptyTypeSet() {
        return this.fEmptyTypeSet;
    }

    public SubTypesOfSingleton createSubTypesOfSingleton(TType superType) {
        if (superType.isJavaLangObject()) {
            return this.getUniverseTypeSet();
        }
        if (this.fSubtypesOfSingletons.containsKey(superType)) {
            ++this.fgCommonExprHits;
            return (SubTypesOfSingleton)this.fSubtypesOfSingletons.get(superType);
        }
        SubTypesOfSingleton s = new SubTypesOfSingleton(superType, this);
        ++this.fgCommonExprMisses;
        this.fSubtypesOfSingletons.put(superType, s);
        return s;
    }

    public SubTypesSet createSubTypesSet(TypeSet superTypes) {
        if (this.fSubTypesSets.containsKey(superTypes)) {
            ++this.fgCommonExprHits;
            return (SubTypesSet)this.fSubTypesSets.get(superTypes);
        }
        SubTypesSet s = new SubTypesSet(superTypes);
        ++this.fgCommonExprMisses;
        this.fSubTypesSets.put(superTypes, s);
        return s;
    }

    public SuperTypesOfSingleton createSuperTypesOfSingleton(TType subType) {
        if (this.fSuperTypesOfSingletons.containsKey(subType)) {
            ++this.fgCommonExprHits;
            return (SuperTypesOfSingleton)this.fSuperTypesOfSingletons.get(subType);
        }
        SuperTypesOfSingleton s = new SuperTypesOfSingleton(subType, this);
        ++this.fgCommonExprMisses;
        this.fSuperTypesOfSingletons.put(subType, s);
        return s;
    }

    public SuperTypesSet createSuperTypesSet(TType subType) {
        if (this.fSuperTypesSets.containsKey(subType)) {
            ++this.fgCommonExprHits;
            return (SuperTypesSet)this.fSuperTypesSets.get(subType);
        }
        SuperTypesSet s = new SuperTypesSet(subType, this);
        ++this.fgCommonExprMisses;
        this.fSuperTypesSets.put(subType, s);
        return s;
    }

    public SuperTypesSet createSuperTypesSet(TypeSet subTypes) {
        if (this.fSuperTypesSets.containsKey(subTypes)) {
            return (SuperTypesSet)this.fSuperTypesSets.get(subTypes);
        }
        SuperTypesSet s = new SuperTypesSet(subTypes, this);
        this.fSuperTypesSets.put(subTypes, s);
        return s;
    }

    public void dumpStats() {
        System.out.println("Common expression hits:   " + this.fgCommonExprHits);
        System.out.println("Common expression misses: " + this.fgCommonExprMisses);
    }
}

