/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.gestures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;

public class RotateGestureListener
implements GestureListener {
    Graph graph;
    double rotate;
    List<? extends GraphNode> nodes;
    List<Point> originalLocations;
    double xCenter;
    double yCenter;

    private void storePosition() {
        this.originalLocations = new ArrayList<Point>();
        Transform t = new Transform();
        t.setTranslation(-this.xCenter, -this.yCenter);
        for (GraphNode graphNode : this.nodes) {
            this.originalLocations.add(t.getTransformed(graphNode.getLocation()));
        }
    }

    private void updatePositions(double rotation) {
        Transform t = new Transform();
        t.setRotation(rotation);
        t.setTranslation(this.xCenter, this.yCenter);
        int i = 0;
        while (i < this.nodes.size()) {
            GraphNode node = this.nodes.get(i);
            Point p = this.originalLocations.get(i);
            Point rot = t.getTransformed(p);
            node.setLocation(rot.preciseX(), rot.preciseY());
            ++i;
        }
    }

    public void gesture(GestureEvent e) {
        if (!(e.widget instanceof Graph)) {
            return;
        }
        switch (e.detail) {
            case 2: {
                this.graph = (Graph)e.widget;
                this.rotate = 0.0;
                List<? extends GraphItem> selection = this.graph.getSelection();
                this.nodes = selection.isEmpty() ? this.graph.getNodes() : RotateGestureListener.tryGetNodes(selection);
                this.xCenter = 0.0;
                this.yCenter = 0.0;
                for (GraphNode graphNode : this.nodes) {
                    Point location = graphNode.getLocation();
                    this.xCenter += location.preciseX();
                    this.yCenter += location.preciseY();
                }
                this.xCenter /= (double)this.nodes.size();
                this.yCenter /= (double)this.nodes.size();
                this.storePosition();
                break;
            }
            case 8: {
                this.updatePositions(e.rotation / 2.0 / Math.PI);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<GraphNode> tryGetNodes(List<? extends GraphItem> selection) {
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        for (GraphItem graphItem : selection) {
            void node;
            if (!(graphItem instanceof GraphNode)) {
                return Collections.emptyList();
            }
            GraphNode graphNode = (GraphNode)graphItem;
            nodes.add((GraphNode)node);
        }
        return nodes;
    }
}

