/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.actions;

import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationFactory;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationPackage;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfigurations;
import org.eclipse.rmf.reqif10.pror.configuration.ProrToolExtension;
import org.eclipse.rmf.reqif10.pror.configuration.provider.ProrPresentationConfigurationsItemProvider;
import org.eclipse.rmf.reqif10.pror.edit.presentation.service.PresentationInterface;
import org.eclipse.rmf.reqif10.pror.editor.IReqifEditor;
import org.eclipse.rmf.reqif10.pror.editor.actions.SubtreeDialog;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationServiceManager;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class PresentationConfigurationActionDelegate
implements IEditorActionDelegate {
    private IReqifEditor editor;

    public void setActiveEditor(IAction action, IEditorPart editor) {
        this.editor = editor instanceof IReqifEditor ? (IReqifEditor)editor : null;
    }

    public void run(IAction action) {
        if (this.editor == null) {
            return;
        }
        EditingDomain ed = this.editor.getEditingDomain();
        ProrToolExtension toolExtension = ConfigurationUtil.createProrToolExtension((ReqIF)this.editor.getReqif(), (EditingDomain)ed);
        if (toolExtension.getPresentationConfigurations() == null) {
            ProrPresentationConfigurations configs = ConfigurationFactory.eINSTANCE.createProrPresentationConfigurations();
            ((ProrPresentationConfigurationsItemProvider)ProrUtil.getItemProvider((AdapterFactory)this.editor.getAdapterFactory(), (Object)configs)).setEditingDomain(ed);
            ed.getCommandStack().execute(SetCommand.create((EditingDomain)ed, (Object)toolExtension, (Object)ConfigurationPackage.Literals.PROR_TOOL_EXTENSION__PRESENTATION_CONFIGURATIONS, (Object)configs));
        }
        SubtreeDialog dialog = new SubtreeDialog(this.editor, (EObject)this.getProrPresentationConfigurations(), "Presentation Configuration", "org.eclipse.rmf.reqif10.pror.editor.presentationConfiguration");
        dialog.setActions(this.buildAddPresentationActions(), true);
        dialog.open();
    }

    private IAction[] buildAddPresentationActions() {
        Set<Class<? extends ProrPresentationConfiguration>> configs = PresentationServiceManager.getPresentationInterfaceMap().keySet();
        IAction[] actions = new IAction[configs.size()];
        int i = 0;
        for (final Class<? extends ProrPresentationConfiguration> config : configs) {
            actions[i++] = new Action(ProrUtil.substractPrefixPostfix(config, (String)"", (String)"ConfigurationImpl")){

                public void run() {
                    PresentationInterface service = PresentationServiceManager.getPresentationInterfaceMap().get(config);
                    ProrPresentationConfiguration config2 = service.getConfigurationInstance();
                    Command command = AddCommand.create((EditingDomain)PresentationConfigurationActionDelegate.this.editor.getEditingDomain(), (Object)PresentationConfigurationActionDelegate.this.getProrPresentationConfigurations(), (Object)ConfigurationPackage.Literals.PROR_PRESENTATION_CONFIGURATIONS__PRESENTATION_CONFIGURATIONS, (Object)config2);
                    PresentationConfigurationActionDelegate.this.editor.getEditingDomain().getCommandStack().execute(command);
                }
            };
        }
        return actions;
    }

    private ProrPresentationConfigurations getProrPresentationConfigurations() {
        ProrToolExtension ext = ConfigurationUtil.createProrToolExtension((ReqIF)this.editor.getReqif(), (EditingDomain)this.editor.getEditingDomain());
        if (ext.getPresentationConfigurations() == null) {
            Command cmd = SetCommand.create((EditingDomain)this.editor.getEditingDomain(), (Object)ext, (Object)ConfigurationPackage.Literals.PROR_TOOL_EXTENSION__PRESENTATION_CONFIGURATIONS, (Object)ConfigurationFactory.eINSTANCE.createProrPresentationConfigurations());
            this.editor.getEditingDomain().getCommandStack().execute(cmd);
        }
        return ext.getPresentationConfigurations();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

