/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.search.filter.IFilter;
import org.eclipse.rmf.reqif10.search.ui.UsageSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class FilterSearchQuery
implements ISearchQuery {
    private IFilter filter;
    private ReqIF reqif;
    private UsageSearchResult usageSearchResult;

    public FilterSearchQuery(ReqIF reqif, IFilter filter) {
        this.filter = filter;
        this.reqif = reqif;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.doRun(monitor);
        monitor.done();
        return Status.OK_STATUS;
    }

    public ISearchResult getSearchResult() {
        return this.usageSearchResult;
    }

    public String getLabel() {
        return this.filter != null ? this.filter.toString() : "ReqIF Search...";
    }

    public boolean canRunInBackground() {
        return true;
    }

    public boolean canRerun() {
        return true;
    }

    private void doRun(IProgressMonitor monitor) {
        monitor.beginTask("Searching...", -1);
        this.usageSearchResult = new UsageSearchResult(this);
        Map<Resource, Collection<EObject>> result = this.find(monitor);
        this.usageSearchResult.getSearchEntries().clear();
        this.usageSearchResult.getSearchEntries().putAll(result);
        monitor.done();
    }

    private Map<Resource, Collection<EObject>> find(IProgressMonitor monitor) {
        HashMap<Resource, Collection<EObject>> result = new HashMap<Resource, Collection<EObject>>();
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)this.reqif, (boolean)true);
        while (iterator.hasNext()) {
            EObject obj = (EObject)iterator.next();
            SpecElementWithAttributes specElement = null;
            if (obj instanceof SpecElementWithAttributes) {
                specElement = (SpecElementWithAttributes)obj;
            } else if (obj instanceof SpecHierarchy) {
                specElement = ((SpecHierarchy)obj).getObject();
            }
            if (specElement == null || !this.filter.match(specElement)) continue;
            HashSet<EObject> collection = (HashSet<EObject>)result.get(this.reqif.eResource());
            if (collection == null) {
                collection = new HashSet<EObject>();
                result.put(this.reqif.eResource(), collection);
            }
            collection.add(obj);
        }
        return result;
    }
}

