/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.search.filter.AbstractAttributeFilter;
import org.eclipse.rmf.reqif10.search.filter.AbstractTextFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;

public class StringFilter
extends AbstractTextFilter {
    public static final ImmutableSet<IFilter.Operator> SUPPORTED_OPERATORS = Sets.immutableEnumSet((Enum)IFilter.Operator.EQUALS, (Enum[])new IFilter.Operator[]{IFilter.Operator.NOT_EQUALS, IFilter.Operator.CONTAINS, IFilter.Operator.NOT_CONTAINS, IFilter.Operator.REGEXP, IFilter.Operator.IS_SET, IFilter.Operator.IS_NOT_SET});

    public StringFilter(IFilter.Operator operator, String value, AttributeDefinitionString attributeDefinition, boolean caseSensitive) {
        super(operator, value, null, (AttributeDefinition)attributeDefinition, caseSensitive);
    }

    public StringFilter(IFilter.Operator operator, String value, AbstractTextFilter.InternalAttribute internalFeature, boolean caseSensitive) {
        super(operator, value, internalFeature, null, caseSensitive);
    }

    @Override
    protected String getInternalAttributeValue(SpecElementWithAttributes element) {
        switch (this.internalAttribute) {
            case IDENTIFIER: {
                return element.isSetIdentifier() ? element.getIdentifier() : null;
            }
            case DESC: {
                return element.isSetDesc() ? element.getDesc() : null;
            }
            case LONG_NAME: {
                return element.isSetLongName() ? element.getLongName() : null;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getAttributeValue(SpecElementWithAttributes element) {
        AttributeValueString attributeValue = (AttributeValueString)ReqIF10Util.getAttributeValue((SpecElementWithAttributes)element, (AttributeDefinition)this.attributeDefinition);
        if (attributeValue == null) {
            return null;
        }
        return attributeValue.getTheValue();
    }

    @Override
    public ImmutableSet<IFilter.Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }

    @Override
    protected String getDefaultValue(SpecElementWithAttributes element) {
        if (!AbstractAttributeFilter.isSetAttribute(element, this.attributeDefinition)) {
            return null;
        }
        if (this.attributeDefinition instanceof AttributeDefinitionString) {
            AttributeDefinitionString ad = (AttributeDefinitionString)this.attributeDefinition;
            return ad.isSetDefaultValue() ? ad.getDefaultValue().getTheValue() : null;
        }
        throw new IllegalStateException("Expected an AttributeDefinitionString as attribute but found " + this.attributeDefinition.getClass());
    }
}

