/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1250;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1250.TC1250ExternalFilesBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1250.testdata.TC1250Testdata;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TC1250ExternalFilesTest
extends AbstractTestCase {
    static final String TEST_CASE_ID = "TC1250";
    static final String REFERENCE_DATA_FILENAME1 = TC1250ExternalFilesTest.getWorkingFileName(TC1250ExternalFilesTest.getReferenceDataFileName("TC1250", false));
    static final String REFERENCE_DATA_ARCHIVE_FILENAME = TC1250ExternalFilesTest.getWorkingFileName(TC1250ExternalFilesTest.getReferenceDataFileName("TC1250", true));
    static ReqIF originalReqIF = null;
    static List<ReqIF> originalReqIFs = null;

    @BeforeClass
    public static void setupOnce() throws Exception {
        AbstractTestCase.setupOnce();
        TC1250ExternalFilesBuilder modelBuilder = new TC1250ExternalFilesBuilder();
        originalReqIF = modelBuilder.getReqIF();
        originalReqIFs = new ArrayList<ReqIF>();
        originalReqIFs.add(originalReqIF);
        String[] fileNames = new String[]{"excel.png", "excel.xls", "excel.xlsx", "word.png", "word.doc", "word.docx", "powerpoint.png", "powerpoint.ppt", "powerpoint.pptx", "rmf-logo-300.png"};
        TC1250ExternalFilesTest.saveReqIFsToZip(originalReqIFs, REFERENCE_DATA_ARCHIVE_FILENAME, (ResourceSetImpl)TC1250ExternalFilesTest.getXMLPersistenceMappingResourceSet());
        TC1250ExternalFilesTest.saveFilesToZip(REFERENCE_DATA_ARCHIVE_FILENAME, originalReqIF, fileNames);
    }

    @Test
    public void testTrue() {
        Assert.assertTrue((boolean)true);
    }

    private static void saveFilesToZip(String zipFileName, ReqIF reqif, String[] fileNames) throws IOException {
        int lastSlashIndex;
        int lastDotIndex = zipFileName.lastIndexOf(".");
        String entryName = zipFileName;
        if (lastDotIndex > 0) {
            entryName = zipFileName.substring(0, lastDotIndex);
        }
        if ((lastSlashIndex = entryName.lastIndexOf("/")) > 0) {
            entryName = entryName.substring(lastSlashIndex + 1);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(zipFileName);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        Resource resource = reqif.eResource();
        ZipEntry zipEntry = new ZipEntry("TC1250.reqif");
        zipOutputStream.putNextEntry(zipEntry);
        resource.save((OutputStream)zipOutputStream, null);
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            int b;
            String fileName = stringArray[n2];
            InputStream is = TC1250Testdata.getInputStream(fileName);
            zipEntry = new ZipEntry("files/" + fileName);
            zipOutputStream.putNextEntry(zipEntry);
            while ((b = is.read()) >= 0) {
                zipOutputStream.write(b);
            }
            ++n2;
        }
        zipOutputStream.close();
    }
}

