/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.monitor;

import java.util.HashMap;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.rmf.tests.serialization.model.nodes.NodesPackage;
import org.eclipse.rmf.tests.serialization.util.LoadSaveUtil;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingResourceFactoryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProgressMonitorTests {
    static final String INPUT_PATH = "org.eclipse.rmf.tests.serialization.progressmonitor/";
    int beginTaskCount = 0;
    int worked = 0;
    int doneCount = 0;
    int myTotalWork;

    @Before
    public void setUp() throws Exception {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/serialization/model/nodes.ecore", (Object)NodesPackage.eINSTANCE);
    }

    @Test
    public void testProgressMonitor() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.progressmonitor/progressmonitor.xml";
        try {
            this.beginTaskCount = 0;
            this.doneCount = 0;
            this.worked = 0;
            NullProgressMonitor monitor = new NullProgressMonitor(){

                public void beginTask(String name, int totalWork) {
                    super.beginTask(name, totalWork);
                    ++ProgressMonitorTests.this.beginTaskCount;
                    ProgressMonitorTests.this.myTotalWork = totalWork;
                }

                public void worked(int work) {
                    super.worked(work);
                    ProgressMonitorTests.this.worked += work;
                }

                public void done() {
                    super.done();
                    ++ProgressMonitorTests.this.doneCount;
                }
            };
            HashMap<String, 1> options = new HashMap<String, 1>();
            options.put("progress monitor", monitor);
            LoadSaveUtil.loadResource("resources/input/" + inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), options);
            Assert.assertSame((Object)1, (Object)this.beginTaskCount);
            Assert.assertSame((Object)4, (Object)this.myTotalWork);
            Assert.assertSame((Object)0, (Object)this.worked);
            Assert.assertSame((Object)1, (Object)this.doneCount);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }
}

