/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JoinGroupWizardPage
extends WizardPage {
    protected static final String CLASSNAME = JoinGroupWizardPage.class.getName();
    protected static final String USER_NAME_SYSTEM_PROPERTY = "user.name";
    protected static final String PAGE_DESCRIPTION = Messages.JoinGroupWizardPage_COMPLETE_ACCOUNT_INFO;
    protected static final String JOINGROUP_FIELDNAME = Messages.JoinGroupWizardPage_GROUPID;
    protected static final String NICKNAME_FIELDNAME = Messages.JoinGroupWizardPage_NICKNAME;
    protected static final String ECF_DEFAULT_URL = Messages.JoinGroupWizardPage_DEFAULT_SERVER;
    protected static final String ECF_TEMPLATE_URL = Messages.JoinGroupWizardPage_TEMPLATE;
    protected static final String PAGE_TITLE = Messages.JoinGroupWizardPage_CONNECT_GENERIC_TITLE;
    protected static final String DEFAULT_CLIENT = "ecf.generic.client";
    private static final String DIALOG_SETTINGS = CLASSNAME;
    private String connectID = null;
    protected String template_url = ECF_TEMPLATE_URL;
    protected String default_url = ECF_DEFAULT_URL;
    protected Text nicknameText;
    protected Text joinGroupText;
    private Text text;
    private ContainerTypeDescription desc;
    protected String urlPrefix = "";
    private final boolean autoLoginFlag = false;

    public JoinGroupWizardPage() {
        super("wizardPage");
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.setImageDescriptor(SharedImages.getImageDescriptor((String)"IMG_COLLABORATION_WIZARD"));
    }

    public JoinGroupWizardPage(String connectID) {
        super("wizardPage");
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.setImageDescriptor(SharedImages.getImageDescriptor((String)"IMG_COLLABORATION_WIZARD"));
        this.connectID = connectID;
    }

    public boolean getAutoLoginFlag() {
        return false;
    }

    protected void fillCombo() {
        this.desc = ContainerFactory.getDefault().getDescriptionByName(DEFAULT_CLIENT);
        if (this.desc != null) {
            String name = this.desc.getName();
            String description = this.desc.getDescription();
            this.text.setText(String.valueOf(description) + " - " + name);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Label label_4 = new Label(container, 0);
        label_4.setText(Messages.JoinGroupWizardPage_PROTOCOL);
        this.text = new Text(container, 2060);
        GridData data = new GridData(4, 1, true, false);
        this.text.setLayoutData((Object)data);
        Label groupIDLabel = new Label(container, 0);
        groupIDLabel.setText(JOINGROUP_FIELDNAME);
        this.joinGroupText = new Text(container, 2048);
        this.joinGroupText.setFocus();
        this.joinGroupText.setText(this.default_url);
        this.joinGroupText.setLayoutData((Object)data);
        Label exampleLabel = new Label(container, 0);
        exampleLabel.setText(this.template_url);
        exampleLabel.setLayoutData((Object)new GridData(0x1000008, 1, false, false, 2, 1));
        this.joinGroupText.setLayoutData((Object)data);
        this.joinGroupText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JoinGroupWizardPage.this.joinGroupText.selectAll();
            }
        });
        Label nicknameLabel = new Label(container, 0);
        nicknameLabel.setLayoutData((Object)new GridData());
        nicknameLabel.setText(NICKNAME_FIELDNAME);
        this.nicknameText = new Text(container, 2048);
        this.nicknameText.setLayoutData((Object)data);
        this.nicknameText.setText(System.getProperty(USER_NAME_SYSTEM_PROPERTY));
        this.nicknameText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JoinGroupWizardPage.this.nicknameText.selectAll();
            }
        });
        this.nicknameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JoinGroupWizardPage.this.validateNicknameText();
            }
        });
        this.fillCombo();
        this.restoreDialogSettings();
        if (this.connectID != null) {
            this.joinGroupText.setText(this.connectID);
        }
        Dialog.applyDialogFont((Control)parent);
    }

    private void validateNicknameText() {
        String nickname = this.nicknameText.getText();
        if ("".equals(nickname)) {
            this.setErrorMessage(Messages.JoinGroupWizardPage_NICKNAME_CANNOT_BE_EMPTY);
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private void restoreDialogSettings() {
        IDialogSettings pageSettings;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (pageSettings = dialogSettings.getSection(DIALOG_SETTINGS)) != null) {
            String strVal = pageSettings.get("url");
            if (strVal != null) {
                this.joinGroupText.setText(strVal);
            }
            if ((strVal = pageSettings.get("nickname")) != null) {
                this.nicknameText.setText(strVal);
            }
        }
    }

    public void saveDialogSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            IDialogSettings pageSettings = dialogSettings.getSection(DIALOG_SETTINGS);
            if (pageSettings == null) {
                pageSettings = dialogSettings.addNewSection(DIALOG_SETTINGS);
            }
            pageSettings.put("url", this.joinGroupText.getText());
            pageSettings.put("nickname", this.nicknameText.getText());
            pageSettings.put("provider", this.text.getText());
        }
    }

    public String getJoinGroupText() {
        String textValue = this.joinGroupText.getText().trim();
        if (!this.urlPrefix.equals("") && !textValue.startsWith(this.urlPrefix)) {
            textValue = String.valueOf(this.urlPrefix) + textValue;
        }
        return textValue;
    }

    public String getNicknameText() {
        if (this.nicknameText == null) {
            return null;
        }
        return this.nicknameText.getText().trim();
    }

    public String getContainerType() {
        return this.desc == null ? null : this.desc.getName();
    }
}

