/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.ui.menu.AbstractRosterMenuHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ecf.core.RemoteShare;
import org.eclipse.team.internal.ecf.core.TeamSynchronization;
import org.eclipse.team.internal.ecf.ui.Messages;
import org.eclipse.team.internal.ecf.ui.subscriber.RemoteSubscriberParticipant;
import org.eclipse.team.internal.ecf.ui.wizards.RemotePeerSynchronizeWizard;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;

class SynchronizeWithHandler
extends AbstractRosterMenuHandler {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    SynchronizeWithHandler(IRosterEntry entry) {
        super(entry);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IRosterEntry selectedEntry = this.getRosterEntry();
        IRoster roster = selectedEntry.getRoster();
        final IUser remoteUser = roster.getUser();
        final ID localId = remoteUser.getID();
        final ID remoteId = selectedEntry.getUser().getID();
        IPresenceContainerAdapter iPresenceContainerAdapter = roster.getPresenceContainerAdapter();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContainer container = (IContainer)iPresenceContainerAdapter.getAdapter((Class)clazz);
        final IResource[] resources = this.getResources(event);
        final RemoteShare share = TeamSynchronization.getShare((ID)container.getID());
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        final IWorkbenchPartSite site = part == null ? null : part.getSite();
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        final boolean[] response = new boolean[]{true};
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block7: {
                    if (resources.length == 1) {
                        monitor.beginTask(NLS.bind((String)Messages.SynchronizeWithHandler_SynchronizeResourceTaskName, (Object)resources[0].getName()), -1);
                    } else {
                        monitor.beginTask(Messages.SynchronizeWithHandler_SynchronizeResourcesTaskName, -1);
                    }
                    try {
                        if (share.sendShareRequest(localId, remoteId, resources, monitor)) {
                            SynchronizeWithHandler.this.scheduleRefreshJob(share, localId, remoteId, resources, remoteUser, site);
                        } else {
                            response[0] = false;
                        }
                    }
                    catch (ECFException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        if (monitor.isCanceled()) break block7;
                        throw e;
                    }
                }
            }
        };
        try {
            dialog.run(true, true, runnable);
            if (!response[0]) {
                MessageDialog.openInformation((Shell)shell, null, (String)Messages.SynchronizeWithHandler_SynchronizeRequestDenial);
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ECFException) {
                MessageDialog.openError((Shell)shell, null, (String)Messages.SynchronizeWithHandler_SynchronizeRequestError);
            }
            TeamSynchronization.log((String)"Failed to contact remote peer", (Throwable)cause);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            MessageDialog.openError((Shell)shell, null, (String)Messages.SynchronizeWithHandler_SynchronizeRequestInterrupted);
            TeamSynchronization.log((String)"Synchronization request operation was interrupted", (Throwable)e);
        }
        return null;
    }

    void scheduleRefreshJob(RemoteShare share, ID localId, ID remoteId, IResource[] resources, IUser remoteUser, IWorkbenchPartSite site) {
        RemoteSubscriberParticipant participant = RemotePeerSynchronizeWizard.getSubscriberParticipant(share, localId, remoteId);
        participant.setResources(resources);
        TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        if (resources.length == 1) {
            participant.refresh(resources, NLS.bind((String)Messages.SynchronizeWithHandler_RemoteSynchronizationTaskName, (Object)remoteUser.getNickname()), NLS.bind((String)Messages.SynchronizeWithHandler_RemoteSynchronizationResourceDescription, (Object)resources[0].getName(), (Object)remoteUser.getNickname()), (IWorkbenchSite)site);
        } else {
            participant.refresh(resources, NLS.bind((String)Messages.SynchronizeWithHandler_RemoteSynchronizationTaskName, (Object)remoteUser.getNickname()), NLS.bind((String)Messages.SynchronizeWithHandler_RemoteSynchronizationResourcesDescription, (Object)remoteUser.getNickname()), (IWorkbenchSite)site);
        }
    }

    public IResource[] getResources(ExecutionEvent event) throws ExecutionException {
        IResource[] iResourceArray;
        IFile file;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ArrayList workspaceSelection = new ArrayList(((IStructuredSelection)selection).toList());
            int i = 0;
            while (i < workspaceSelection.size()) {
                IAdaptable iAdaptable = (IAdaptable)workspaceSelection.get(i);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IResource resourceOne = (IResource)iAdaptable.getAdapter((Class)clazz);
                IPath pathOne = resourceOne.getFullPath();
                int j = i + 1;
                while (j < workspaceSelection.size()) {
                    IResource resourceTwo;
                    IPath pathTwo;
                    IAdaptable iAdaptable2 = (IAdaptable)workspaceSelection.get(j);
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (pathOne.isPrefixOf(pathTwo = (resourceTwo = (IResource)iAdaptable2.getAdapter((Class)clazz2)).getFullPath())) {
                        workspaceSelection.remove(j);
                        --i;
                        break;
                    }
                    if (pathTwo.isPrefixOf(pathOne)) {
                        workspaceSelection.remove(i);
                        --i;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            IResource[] resources = new IResource[workspaceSelection.size()];
            int i2 = 0;
            while (i2 < resources.length) {
                IAdaptable iAdaptable = (IAdaptable)workspaceSelection.get(i2);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resources[i2] = (IResource)iAdaptable.getAdapter((Class)clazz);
                ++i2;
            }
            return resources;
        }
        IEditorPart editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        IEditorInput iEditorInput = editor.getEditorInput();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)iEditorInput.getAdapter((Class)clazz)) == null) {
            iResourceArray = new IResource[]{};
        } else {
            IResource[] iResourceArray2 = new IResource[1];
            iResourceArray = iResourceArray2;
            iResourceArray2[0] = file;
        }
        return iResourceArray;
    }
}

