/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.sql.Array;
import java.sql.Date;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.StoredFunctionQueryHandler;
import org.eclipse.persistence.internal.xr.StoredProcedureQueryHandler;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.structures.ArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.mappings.structures.StructureMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleObjectType;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredFunctionCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.BaseDBWSBuilderHelper;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSBuilderHelper;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.oracle.ShadowDDLGenerator;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.ROWTYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum;
import org.eclipse.persistence.tools.oracleddl.metadata.TYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.BaseDatabaseTypeVisitor;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;
import org.eclipse.persistence.tools.oracleddl.parser.ParseException;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;

public class OracleHelper
extends BaseDBWSBuilderHelper
implements DBWSBuilderHelper {
    protected DatabaseTypeBuilder dtBuilder = new DatabaseTypeBuilder();
    public static final String NO_PKG_MSG = "No packages were found matching the following: ";

    public OracleHelper(DBWSBuilder dbwsBuilder) {
        super(dbwsBuilder);
    }

    @Override
    public boolean hasTables() {
        return this.dbTables.size() != 0;
    }

    @Override
    public void buildDbArtifacts() {
        super.buildDbArtifacts();
        HashSet<PLSQLPackageType> directPackages = new HashSet<PLSQLPackageType>();
        for (ProcedureType procedureType : this.dbStoredProcedures) {
            for (ArgumentType argumentType : procedureType.getArguments()) {
                org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType databaseType = argumentType.getEnclosedType();
                if (!databaseType.isPLSQLType()) continue;
                PLSQLType plsqlType = (PLSQLType)databaseType;
                directPackages.add(plsqlType.getParentType());
            }
        }
        final HashSet indirectPackages = new HashSet();
        BaseDatabaseTypeVisitor indirectVisitor = new BaseDatabaseTypeVisitor(){

            public void beginVisit(PLSQLPackageType databaseType) {
                indirectPackages.add(databaseType);
            }
        };
        for (PLSQLPackageType pckage : directPackages) {
            pckage.accept((DatabaseTypeVisitor)indirectVisitor);
        }
        HashSet<Object> packages = new HashSet<Object>();
        packages.addAll(directPackages);
        packages.addAll(indirectPackages);
        for (PLSQLPackageType pLSQLPackageType : packages) {
            ShadowDDLGenerator ddlGenerator = new ShadowDDLGenerator(pLSQLPackageType);
            this.dbwsBuilder.getTypeDDL().addAll(ddlGenerator.getAllCreateDDLs());
            this.dbwsBuilder.getTypeDropDDL().addAll(ddlGenerator.getAllDropDDLs());
        }
    }

    @Override
    public void buildProcedureOperation(ProcedureOperationModel procedureOperationModel) {
        for (ProcedureType storedProcedure : procedureOperationModel.getDbStoredProcedures()) {
            boolean hasComplexArgs = Util.hasComplexArgs(storedProcedure);
            QueryOperation qo = new QueryOperation();
            qo.setName(this.getNameForQueryOperation(procedureOperationModel, storedProcedure));
            String qualifiedProcName = this.getQualifiedProcedureName(procedureOperationModel, storedProcedure);
            this.dbwsBuilder.logMessage(Level.FINEST, "Building QueryOperation for " + qualifiedProcName);
            Object qh = null;
            List queries = this.dbwsBuilder.getOrProject().getQueries();
            if (queries.size() > 0) {
                for (DatabaseQuery q : queries) {
                    if (!q.getName().equals(qo.getName())) continue;
                    qh = new NamedQueryHandler();
                    ((NamedQueryHandler)qh).setName(qo.getName());
                }
            }
            if (qh == null) {
                qh = storedProcedure.isFunctionType() ? new StoredFunctionQueryHandler() : new StoredProcedureQueryHandler();
                ((StoredProcedureQueryHandler)qh).setName(qualifiedProcName);
            }
            qo.setQueryHandler(qh);
            String returnType = procedureOperationModel.getReturnType();
            boolean isCollection = procedureOperationModel.isCollection();
            boolean isSimpleXMLFormat = procedureOperationModel.isSimpleXMLFormat();
            Object result = null;
            int outArgCount = 0;
            for (ArgumentType argument : storedProcedure.getArguments()) {
                ArgumentTypeDirection argDirection = argument.getDirection();
                if (argDirection != ArgumentTypeDirection.OUT) continue;
                ++outArgCount;
            }
            if (outArgCount > 1 || outArgCount > 0 && storedProcedure.isFunctionType()) {
                isCollection = true;
                isSimpleXMLFormat = true;
                result = new CollectionResult();
                result.setType(Constants.ANY_QNAME);
            } else if (storedProcedure.isFunctionType()) {
                ArgumentType returnArg = ((FunctionType)storedProcedure).getReturnArgument();
                result = this.buildResultForStoredFunction(returnArg, returnType);
                if (returnArg.getEnclosedType().isPLSQLCursorType()) {
                    this.customizeSimpleXMLTagNames((PLSQLCursorType)returnArg.getEnclosedType(), procedureOperationModel);
                }
            } else if (hasComplexArgs) {
                if (Util.noOutArguments(storedProcedure)) {
                    result = new Result();
                    result.setType(new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd"));
                }
            } else if (returnType != null) {
                result = new Result();
                result.setType(Util.buildCustomQName(returnType, this.dbwsBuilder));
            } else if (isCollection) {
                result = new CollectionResult();
                if (isSimpleXMLFormat) {
                    result.setType(Util.SXF_QNAME_CURSOR);
                }
            } else {
                result = new Result();
                result.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
            }
            for (ArgumentType arg : storedProcedure.getArguments()) {
                String argName = arg.getArgumentName();
                if (argName == null) continue;
                QName xmlType = null;
                ProcedureOutputArgument pa = null;
                ProcedureArgument paShadow = null;
                Parameter parm = null;
                ArgumentTypeDirection direction = arg.getDirection();
                if (!hasComplexArgs) {
                    if (arg.getEnclosedType().isPLSQLCursorType()) {
                        PLSQLCursorType cursorType = (PLSQLCursorType)arg.getEnclosedType();
                        if (cursorType.isWeaklyTyped()) {
                            xmlType = Util.buildCustomQName("SYS_REFCURSOR", this.dbwsBuilder);
                        }
                    } else {
                        xmlType = Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(arg.getTypeName()));
                    }
                } else if (arg.getEnclosedType().isPLSQLType()) {
                    String packageName = ((PLSQLType)arg.getEnclosedType()).getParentType().getPackageName();
                    String typeString = packageName != null && packageName.length() > 0 ? packageName + "_" + arg.getTypeName() : arg.getTypeName();
                    typeString = typeString.contains("%") ? typeString.replace("%", "_") : typeString;
                    xmlType = Util.buildCustomQName(this.nct.generateSchemaAlias(typeString), this.dbwsBuilder);
                } else if (arg.getEnclosedType().isVArrayType() || arg.getEnclosedType().isObjectType() || arg.getEnclosedType().isObjectTableType()) {
                    xmlType = Util.buildCustomQName(this.nct.generateSchemaAlias(arg.getTypeName()), this.dbwsBuilder);
                } else {
                    switch (Util.getJDBCTypeFromTypeName(arg.getTypeName())) {
                        case 2002: 
                        case 2003: {
                            String typeString = this.nct.generateSchemaAlias(arg.getTypeName());
                            xmlType = Util.buildCustomQName(typeString, this.dbwsBuilder);
                            break;
                        }
                        default: {
                            xmlType = Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(arg.getTypeName()));
                        }
                    }
                }
                if (direction == null || direction == ArgumentTypeDirection.IN) {
                    parm = new Parameter();
                    parm.setName(argName);
                    parm.setType(xmlType);
                    parm.setOptional(arg.optional());
                    pa = new ProcedureArgument();
                    pa.setName(argName);
                    pa.setParameterName(argName);
                    if (qh instanceof StoredProcedureQueryHandler) {
                        ((StoredProcedureQueryHandler)qh).getInArguments().add(pa);
                    }
                } else {
                    boolean isCursor;
                    ProcedureOutputArgument pao = pa = new ProcedureOutputArgument();
                    pao.setName(argName);
                    pao.setParameterName(argName);
                    boolean bl = isCursor = arg.isPLSQLCursorType() || arg.getTypeName().contains("CURSOR");
                    if (arg.isPLSQLCursorType()) {
                        this.customizeSimpleXMLTagNames((PLSQLCursorType)arg.getEnclosedType(), procedureOperationModel);
                    }
                    if (isCursor && returnType == null) {
                        pao.setResultType(Util.SXF_QNAME_CURSOR);
                        if (result == null) {
                            result = new CollectionResult();
                            result.setType(Util.SXF_QNAME_CURSOR);
                        }
                    } else {
                        if (returnType != null && !isSimpleXMLFormat) {
                            xmlType = Util.qNameFromString("{" + this.dbwsBuilder.getTargetNamespace() + "}" + returnType, this.dbwsBuilder.getSchema());
                        }
                        if (isCursor) {
                            pao.setResultType(new QName("", "cursor of " + returnType));
                            CollectionResult newResult = new CollectionResult();
                            newResult.setType(result.getType());
                            result = newResult;
                        } else {
                            pao.setResultType(xmlType);
                        }
                        if (result == null) {
                            result = isCollection ? new CollectionResult() : new Result();
                            result.setType(xmlType);
                        }
                    }
                    if (direction == ArgumentTypeDirection.INOUT) {
                        parm = new Parameter();
                        parm.setName(argName);
                        parm.setType(xmlType);
                        result.setType(xmlType);
                        if (qh instanceof StoredProcedureQueryHandler) {
                            ((StoredProcedureQueryHandler)qh).getInOutArguments().add(pao);
                        }
                        paShadow = new ProcedureArgument();
                        paShadow.setName(argName);
                        paShadow.setParameterName(argName);
                    } else if (qh instanceof StoredProcedureQueryHandler) {
                        ((StoredProcedureQueryHandler)qh).getOutArguments().add(pao);
                    }
                }
                if (arg.getEnclosedType() == ScalarDatabaseTypeEnum.XMLTYPE_TYPE) {
                    pa.setJdbcType(org.eclipse.persistence.internal.xr.Util.getJDBCTypeForTypeName((String)"XMLTYPE"));
                }
                if (hasComplexArgs && arg.getEnclosedType().isPLSQLType()) {
                    pa.setComplexTypeName(storedProcedure.getCatalogName() + "_" + arg.getTypeName());
                    if (paShadow != null) {
                        paShadow.setComplexTypeName(pa.getComplexTypeName());
                    }
                }
                if (parm == null) continue;
                qo.getParameters().add(parm);
            }
            if (procedureOperationModel.getBinaryAttachment()) {
                Attachment attachment = new Attachment();
                attachment.setMimeType("application/octet-stream");
                result.setAttachment(attachment);
            }
            this.handleSimpleXMLFormat(isSimpleXMLFormat, (Result)result, procedureOperationModel);
            qo.setResult((Result)result);
            this.dbwsBuilder.getXrServiceModel().getOperations().put(qo.getName(), qo);
        }
        this.finishProcedureOperation();
    }

    protected Result buildResultForStoredFunction(ArgumentType returnArgument, String returnType) {
        CollectionResult result = null;
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType rargDataType = returnArgument.getEnclosedType();
        if (rargDataType.isPLSQLCursorType() || returnArgument.getTypeName().contains("CURSOR")) {
            result = new CollectionResult();
            result.setType(Util.SXF_QNAME_CURSOR);
        } else {
            result = new Result();
            int rargJdbcType = 1111;
            if (rargDataType.isComposite()) {
                if (rargDataType.isObjectType()) {
                    rargJdbcType = 2002;
                } else if (rargDataType.isVArrayType() || rargDataType.isObjectTableType()) {
                    rargJdbcType = 2003;
                }
            } else {
                rargJdbcType = Util.getJDBCTypeFromTypeName(returnArgument.getTypeName());
            }
            switch (rargJdbcType) {
                case 1111: {
                    String returnTypeName;
                    if (returnType != null && returnType.length() > 0) {
                        returnTypeName = returnType;
                    } else {
                        returnType = rargDataType.getTypeName();
                        String packageName = null;
                        if (rargDataType.isPLSQLType()) {
                            packageName = ((PLSQLType)rargDataType).getParentType().getPackageName();
                        }
                        returnTypeName = packageName != null && packageName.length() > 0 ? packageName + "_" + returnType : returnType;
                        returnTypeName = returnTypeName.contains("%") ? returnTypeName.replace("%", "_") : returnTypeName;
                        returnTypeName = this.nct.generateSchemaAlias(returnTypeName);
                    }
                    result.setType(Util.buildCustomQName(returnTypeName, this.dbwsBuilder));
                    break;
                }
                case 2002: 
                case 2003: {
                    if (returnType == null || returnType.length() == 0) {
                        returnType = rargDataType.getTypeName().toLowerCase().concat("Type");
                    }
                    result.setType(Util.buildCustomQName(returnType, this.dbwsBuilder));
                    break;
                }
                default: {
                    result.setType(Util.getXMLTypeFromJDBCType(rargJdbcType));
                }
            }
        }
        if (rargDataType == ScalarDatabaseTypeEnum.XMLTYPE_TYPE) {
            result.setJdbcType(org.eclipse.persistence.internal.xr.Util.getJDBCTypeForTypeName((String)"XMLTYPE"));
        }
        return result;
    }

    protected String getNameForQueryOperation(ProcedureOperationModel opModel, ProcedureType storedProcedure) {
        StringBuilder sb = new StringBuilder();
        String modelName = opModel.getName();
        if (modelName != null && modelName.length() > 0) {
            sb.append(modelName);
            if (opModel.getProcedurePattern().contains("%")) {
                sb.append("_");
                sb.append(storedProcedure.getProcedureName());
            }
            if (storedProcedure.getOverload() != 0) {
                sb.append("_");
                sb.append(storedProcedure.getOverload());
            }
        } else {
            if (storedProcedure.getOverload() > 0) {
                sb.append(storedProcedure.getOverload());
                sb.append("_");
            }
            if (storedProcedure.getCatalogName() != null && storedProcedure.getCatalogName().length() > 0) {
                sb.append(storedProcedure.getCatalogName());
                sb.append("_");
            }
            if (storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
                sb.append(storedProcedure.getSchema());
                sb.append("_");
            }
            sb.append(storedProcedure.getProcedureName());
        }
        return sb.toString();
    }

    protected String getQualifiedProcedureName(ProcedureOperationModel procedureOperationModel, ProcedureType storedProcedure) {
        StringBuilder sb = new StringBuilder();
        if (procedureOperationModel.getSchemaPattern() != null && procedureOperationModel.getSchemaPattern().length() > 0 && storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
            sb.append(storedProcedure.getSchema());
            sb.append('.');
        }
        if (storedProcedure.getCatalogName() != null && storedProcedure.getCatalogName().length() > 0) {
            sb.append(storedProcedure.getCatalogName());
            sb.append('.');
        }
        sb.append(storedProcedure.getProcedureName());
        return sb.toString();
    }

    @Override
    protected List<TableType> loadTables(List<String> catalogPatterns, List<String> schemaPatterns, List<String> tableNamePatterns) {
        try {
            return this.dtBuilder.buildTables(this.dbwsBuilder.getConnection(), schemaPatterns, tableNamePatterns);
        }
        catch (ParseException e) {
            this.dbwsBuilder.logMessage(Level.WARNING, e.getMessage());
            return null;
        }
    }

    private static String buildNamePatternsList(List<String> namePatterns) {
        int count = namePatterns.size();
        if (count > 0) {
            int lenhth = count - 1;
            Iterator<String> i = namePatterns.iterator();
            while (i.hasNext()) {
                lenhth += i.next().length();
            }
            StringBuilder out = new StringBuilder(lenhth);
            Iterator<String> i2 = namePatterns.iterator();
            while (i2.hasNext()) {
                out.append(i2.next());
                if (!i2.hasNext()) continue;
                out.append('|');
            }
            return out.toString();
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected List<ProcedureType> loadProcedures(List<String> catalogPatterns, List<String> schemaPatterns, List<String> procedureNamePatterns) {
        ArrayList<ProcedureType> allProcsAndFuncs = new ArrayList<ProcedureType>();
        ArrayList<void> topLevelSchemaPatterns = new ArrayList<void>();
        ArrayList<String> topLevelProcedureNamePatterns = new ArrayList<String>();
        HashMap<void, HashSet<Object>> packagePatterns = new HashMap<void, HashSet<Object>>();
        int len = catalogPatterns.size();
        for (int i = 0; i < len; ++i) {
            void var11_17;
            String catalogPattern = catalogPatterns.get(i);
            String string = schemaPatterns.get(i);
            if (string == null) {
                String string2 = this.dbwsBuilder.getUsername().toUpperCase();
            }
            if (catalogPattern == null || catalogPattern.length() == 0 || "TOPLEVEL".equals(catalogPattern)) {
                topLevelSchemaPatterns.add(var11_17);
                topLevelProcedureNamePatterns.add(procedureNamePatterns.get(i));
                continue;
            }
            HashSet<Object> packageNames = (HashSet<Object>)packagePatterns.get(var11_17);
            if (packageNames == null) {
                packageNames = new HashSet<Object>();
                packagePatterns.put(var11_17, packageNames);
            }
            packageNames.add(catalogPattern);
        }
        if (topLevelProcedureNamePatterns.size() > 0) {
            try {
                List topLevelProcedures = this.dtBuilder.buildProcedures(this.dbwsBuilder.getConnection(), topLevelSchemaPatterns, topLevelProcedureNamePatterns);
                if (topLevelProcedures != null && topLevelProcedures.size() > 0) {
                    allProcsAndFuncs.addAll(topLevelProcedures);
                }
            }
            catch (ParseException e) {
                this.dbwsBuilder.logMessage(Level.WARNING, e.getMessage());
            }
            try {
                List topLevelFunctions = this.dtBuilder.buildFunctions(this.dbwsBuilder.getConnection(), topLevelSchemaPatterns, topLevelProcedureNamePatterns);
                if (topLevelFunctions != null && topLevelFunctions.size() > 0) {
                    allProcsAndFuncs.addAll(topLevelFunctions);
                }
            }
            catch (ParseException e) {
                this.dbwsBuilder.logMessage(Level.WARNING, e.getMessage());
            }
        }
        if (packagePatterns.size() > 0) {
            try {
                ArrayList<String> schemaPats = new ArrayList<String>();
                ArrayList<String> packagePats = new ArrayList<String>();
                for (Map.Entry entry : packagePatterns.entrySet()) {
                    String schema = (String)entry.getKey();
                    for (String packageName : (Set)entry.getValue()) {
                        schemaPats.add(schema);
                        packagePats.add(packageName);
                    }
                }
                List packages = this.dtBuilder.buildPackages(this.dbwsBuilder.getConnection(), schemaPats, packagePats);
                if (packages == null || packages.isEmpty()) {
                    this.logPackageNotFoundWarnings(NO_PKG_MSG, schemaPats, packagePats);
                } else {
                    for (PLSQLPackageType pakage : packages) {
                        ShadowDDLGenerator ddlGenerator = new ShadowDDLGenerator(pakage);
                        this.dbwsBuilder.getTypeDDL().addAll(ddlGenerator.getAllCreateDDLs());
                        this.dbwsBuilder.getTypeDropDDL().addAll(ddlGenerator.getAllDropDDLs());
                        HashMap<String, ArrayList<ProcedureType>> overloadMap = new HashMap<String, ArrayList<ProcedureType>>();
                        List procedures = pakage.getProcedures();
                        for (ProcedureType procedure : procedures) {
                            String procedureName = procedure.getProcedureName();
                            ArrayList<ProcedureType> multipleProcedures = (ArrayList<ProcedureType>)overloadMap.get(procedureName);
                            if (multipleProcedures == null) {
                                multipleProcedures = new ArrayList<ProcedureType>();
                                overloadMap.put(procedureName, multipleProcedures);
                            }
                            multipleProcedures.add(procedure);
                        }
                        for (List procs : overloadMap.values()) {
                            if (procs.size() <= 1) continue;
                            int len2 = procs.size();
                            for (int i = 0; i < len2; ++i) {
                                ((ProcedureType)procs.get(i)).setOverload(i);
                            }
                        }
                        String tmp = OracleHelper.buildNamePatternsList(procedureNamePatterns);
                        for (ProcedureType procedure : procedures) {
                            if (!Util.sqlMatch(tmp, procedure.getProcedureName())) continue;
                            allProcsAndFuncs.add(procedure);
                        }
                    }
                }
            }
            catch (ParseException e) {
                this.dbwsBuilder.logMessage(Level.WARNING, e.getMessage());
            }
        }
        return allProcsAndFuncs.isEmpty() ? null : allProcsAndFuncs;
    }

    @Override
    public void addToOROXProjectsForComplexTypes(List<CompositeDatabaseType> types, Project orProject, Project oxProject) {
        for (org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType databaseType : types) {
            String alias;
            Object name;
            if (databaseType.isPLSQLType()) {
                Object targetTypeName;
                databaseType.setTypeName(databaseType.getTypeName().toUpperCase());
                String catalogPattern = ((PLSQLType)databaseType).getParentType().getPackageName();
                if (catalogPattern == null) {
                    name = databaseType.getTypeName();
                    targetTypeName = databaseType.getTypeName();
                } else {
                    name = catalogPattern + "." + databaseType.getTypeName();
                    targetTypeName = catalogPattern + "_" + databaseType.getTypeName();
                }
                alias = ((String)targetTypeName).toLowerCase();
                name = ((String)name).replace("%", "_");
                targetTypeName = ((String)targetTypeName).replace("%", "_");
                alias = alias.replace("%", "_");
                if (databaseType.isPLSQLRecordType()) {
                    this.addToOXProjectForPLSQLRecordArg(databaseType, oxProject, (String)name, alias, (String)targetTypeName, catalogPattern);
                    this.addToORProjectForPLSQLRecordArg(databaseType, orProject, (String)name, alias, (String)targetTypeName, catalogPattern);
                    continue;
                }
                this.addToOXProjectForPLSQLTableArg(databaseType, oxProject, (String)name, alias, (String)targetTypeName, catalogPattern);
                this.addToORProjectForPLSQLTableArg(databaseType, orProject, (String)name, alias, (String)targetTypeName, catalogPattern);
                continue;
            }
            name = Util.isTypeComplex(databaseType) ? Util.getGeneratedJavaClassName(databaseType.getTypeName(), this.dbwsBuilder.getProjectName()) : databaseType.getTypeName();
            alias = Util.getGeneratedAlias(databaseType.getTypeName());
            if (databaseType.isVArrayType()) {
                this.addToOXProjectForVArrayArg(databaseType, oxProject, (String)name, alias);
                this.addToORProjectForVArrayArg(databaseType, orProject, (String)name, alias);
                continue;
            }
            if (databaseType.isObjectType()) {
                this.addToOXProjectForObjectTypeArg(databaseType, oxProject, (String)name, alias);
                this.addToORProjectForObjectTypeArg(databaseType, orProject, (String)name, alias);
                continue;
            }
            if (!databaseType.isObjectTableType()) continue;
            this.addToOXProjectForObjectTableTypeArg(databaseType, oxProject, (String)name, alias);
            this.addToORProjectForObjectTableTypeArg(databaseType, orProject, (String)name, alias);
        }
    }

    protected void addToOXProjectForPLSQLRecordArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String recordName, String recordAlias, String targetTypeName, String catalogPattern) {
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(recordAlias);
        if (xdesc == null) {
            xdesc = this.buildAndAddNewXMLDescriptor(oxProject, recordAlias, recordName.toLowerCase(), this.nct.generateSchemaAlias(targetTypeName), Util.buildCustomQName(targetTypeName, this.dbwsBuilder).getNamespaceURI());
        }
        PLSQLRecordType plsqlRecType = (PLSQLRecordType)dbType;
        for (FieldType fType : plsqlRecType.getFields()) {
            String lFieldName;
            if (this.nct.styleForElement(fType.getFieldName()) == NamingConventionTransformer.ElementStyle.NONE || xdesc.getMappingForAttributeName(lFieldName = fType.getFieldName().toLowerCase()) != null) continue;
            if (fType.isComposite()) {
                TYPEType typeType;
                if (fType.getEnclosedType().isPLSQLRecordType()) {
                    this.buildAndAddXMLCompositeObjectMapping(xdesc, lFieldName, (catalogPattern + "." + fType.getEnclosedType()).toLowerCase());
                    continue;
                }
                if (fType.getEnclosedType().isPLSQLCollectionType()) {
                    PLSQLCollectionType tableType = (PLSQLCollectionType)fType.getEnclosedType();
                    if (tableType.getEnclosedType().isComposite()) {
                        this.buildAndAddXMLCompositeObjectMapping(xdesc, lFieldName, (catalogPattern + "." + tableType.getTypeName()).toLowerCase() + "_CollectionWrapper");
                        continue;
                    }
                    Class attributeElementClass = String.class;
                    XMLDescriptor refDesc = (XMLDescriptor)oxProject.getDescriptorForAlias((catalogPattern + "_" + tableType.getTypeName()).toLowerCase());
                    if (refDesc != null) {
                        attributeElementClass = ((XMLCompositeDirectCollectionMapping)refDesc.getMappingForAttributeName("items")).getAttributeElementClass();
                    }
                    this.buildAndAddXMLCompositeDirectCollectionMapping(xdesc, lFieldName, lFieldName + "/item/text()", attributeElementClass);
                    continue;
                }
                if (fType.getEnclosedType().isObjectType()) {
                    this.buildAndAddXMLCompositeObjectMapping(xdesc, lFieldName, Util.getGeneratedJavaClassName(fType.getEnclosedType().getTypeName(), this.dbwsBuilder.getProjectName()));
                    continue;
                }
                if (fType.getEnclosedType().isVArrayType()) {
                    if (((VArrayType)fType.getEnclosedType()).getEnclosedType().isComposite()) {
                        String nestedTypeAlias = ((VArrayType)fType.getEnclosedType()).getEnclosedType().getTypeName().toLowerCase();
                        String nestedTypeName = Util.getGeneratedJavaClassName(nestedTypeAlias, this.dbwsBuilder.getProjectName());
                        this.buildAndAddXMLCompositeCollectionMapping(xdesc, lFieldName, lFieldName + "/item", nestedTypeName);
                        continue;
                    }
                    this.buildAndAddXMLCompositeDirectCollectionMapping(xdesc, lFieldName, lFieldName + "/item/text()", Util.getAttributeClassForDatabaseType(fType.getEnclosedType()));
                    continue;
                }
                if (fType.getEnclosedType().isObjectTableType()) {
                    ObjectTableType nestedType = (ObjectTableType)fType.getEnclosedType();
                    if (nestedType.getEnclosedType().isComposite()) {
                        String nestedTypeAlias = nestedType.getEnclosedType().getTypeName().toLowerCase();
                        String nestedTypeName = Util.getGeneratedJavaClassName(nestedTypeAlias, this.dbwsBuilder.getProjectName());
                        this.buildAndAddXMLCompositeCollectionMapping(xdesc, lFieldName, lFieldName + "/item", nestedTypeName);
                        continue;
                    }
                    this.buildAndAddXMLCompositeDirectCollectionMapping(xdesc, lFieldName, lFieldName + "/text()", Util.getAttributeClassForDatabaseType((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)nestedType));
                    continue;
                }
                if (!fType.getEnclosedType().isTYPEType() || !(typeType = (TYPEType)fType.getEnclosedType()).getEnclosedType().isFieldType()) continue;
                this.addDirectMappingForFieldType(xdesc, lFieldName, (FieldType)typeType.getEnclosedType());
                continue;
            }
            this.addDirectMappingForFieldType(xdesc, lFieldName, fType);
        }
    }

    protected void addToORProjectForPLSQLRecordArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String recordName, String recordAlias, String targetTypeName, String catalogPattern) {
        ObjectRelationalDataTypeDescriptor ordtDesc = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(recordAlias);
        if (ordtDesc == null) {
            ordtDesc = this.buildAndAddNewObjectRelationalDataTypeDescriptor(orProject, recordAlias, recordName.toLowerCase());
        }
        PLSQLRecordType plsqlRecType = (PLSQLRecordType)dbType;
        for (FieldType fType : plsqlRecType.getFields()) {
            String fieldName = fType.getFieldName();
            String lFieldName = fieldName.toLowerCase();
            boolean found = false;
            Vector orderedFields = ordtDesc.getOrderedFields();
            for (Object o : orderedFields) {
                DatabaseField field;
                if (!(o instanceof DatabaseField) || !(field = (DatabaseField)o).getName().equalsIgnoreCase(fieldName)) continue;
                found = true;
                break;
            }
            if (!found) {
                ordtDesc.addFieldOrdering(fieldName);
            }
            if (ordtDesc.getMappingForAttributeName(lFieldName) != null) continue;
            if (fType.isComposite()) {
                TYPEType typeType;
                if (fType.getEnclosedType().isPLSQLRecordType()) {
                    this.buildAndAddStructureMapping(ordtDesc, lFieldName, fieldName, recordName.toLowerCase());
                    continue;
                }
                if (fType.getEnclosedType().isPLSQLCollectionType()) {
                    PLSQLCollectionType tableType = (PLSQLCollectionType)fType.getEnclosedType();
                    if (tableType.getEnclosedType().isComposite()) {
                        this.buildAndAddObjectArrayMapping(ordtDesc, lFieldName, fieldName, (catalogPattern + "." + tableType.getTypeName()).toLowerCase() + "_CollectionWrapper", this.getStructureNameForField(fType, catalogPattern));
                        continue;
                    }
                    this.buildAndAddArrayMapping(ordtDesc, lFieldName, fieldName, this.getStructureNameForField(fType, catalogPattern));
                    continue;
                }
                if (fType.getEnclosedType().isObjectType()) {
                    this.buildAndAddStructureMapping(ordtDesc, lFieldName, fieldName, Util.getGeneratedJavaClassName(fType.getEnclosedType().getTypeName(), this.dbwsBuilder.getProjectName()));
                    continue;
                }
                if (fType.getEnclosedType().isVArrayType()) {
                    if (((VArrayType)fType.getEnclosedType()).getEnclosedType().isComposite()) {
                        this.buildAndAddObjectArrayMapping(ordtDesc, lFieldName, fieldName, Util.getGeneratedJavaClassName(((VArrayType)fType.getEnclosedType()).getEnclosedType().getTypeName(), this.dbwsBuilder.getProjectName()), this.getStructureNameForField(fType, null));
                        continue;
                    }
                    this.buildAndAddArrayMapping(ordtDesc, lFieldName, fieldName, this.getStructureNameForField(fType, null));
                    continue;
                }
                if (fType.getEnclosedType().isObjectTableType()) {
                    ObjectTableType nestedType = (ObjectTableType)fType.getEnclosedType();
                    if (nestedType.getEnclosedType().isComposite()) {
                        ObjectType oType = (ObjectType)nestedType.getEnclosedType();
                        String oTypeAlias = oType.getTypeName().toLowerCase();
                        String oTypeName = Util.getGeneratedJavaClassName(oTypeAlias, this.dbwsBuilder.getProjectName());
                        this.buildAndAddObjectArrayMapping(ordtDesc, lFieldName, fieldName, oTypeName, oTypeAlias.toUpperCase());
                        continue;
                    }
                    this.buildAndAddArrayMapping(ordtDesc, lFieldName, fieldName, nestedType.getTypeName().toUpperCase());
                    continue;
                }
                if (!fType.getEnclosedType().isTYPEType() || !(typeType = (TYPEType)fType.getEnclosedType()).getEnclosedType().isFieldType()) continue;
                AbstractDirectMapping absDirectMapping = (AbstractDirectMapping)ordtDesc.addDirectMapping(lFieldName, fieldName);
                try {
                    absDirectMapping.setAttributeClassificationName(org.eclipse.persistence.internal.xr.Util.getClassFromJDBCType((String)fType.getTypeName(), (DatabasePlatform)this.dbwsBuilder.getDatabasePlatform()).getName());
                }
                catch (Exception exception) {}
                continue;
            }
            DirectToFieldMapping dfm = new DirectToFieldMapping();
            dfm.setFieldName(fieldName);
            dfm.setAttributeName(lFieldName);
            dfm.setAttributeClassification(Util.getAttributeClassForDatabaseType(fType.getEnclosedType()));
            ordtDesc.addMapping((DatabaseMapping)dfm);
        }
    }

    protected void addToOXProjectForPLSQLTableArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String tableName, String tableAlias, String targetTypeName, String catalogPattern) {
        boolean itemsMappingFound;
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(tableAlias);
        if (xdesc == null) {
            xdesc = this.buildAndAddNewXMLDescriptor(oxProject, tableAlias, tableName.toLowerCase() + "_CollectionWrapper", this.nct.generateSchemaAlias(targetTypeName), Util.buildCustomQName(targetTypeName, this.dbwsBuilder).getNamespaceURI());
        }
        boolean bl = itemsMappingFound = xdesc.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedType = ((PLSQLCollectionType)dbType).getEnclosedType();
            if (nestedType.isPLSQLRecordType()) {
                String referenceClassName = (catalogPattern + "." + ((PLSQLRecordType)nestedType).getTypeName()).toLowerCase();
                this.buildAndAddXMLCompositeCollectionMapping(xdesc, referenceClassName);
                if (oxProject.getDescriptorForAlias(referenceClassName) == null) {
                    String refTypeName = catalogPattern + "_" + ((PLSQLRecordType)nestedType).getTypeName();
                    this.addToOXProjectForPLSQLRecordArg(nestedType, oxProject, referenceClassName, refTypeName.toLowerCase(), refTypeName, catalogPattern);
                }
            } else if (nestedType.isObjectType()) {
                this.buildAndAddXMLCompositeCollectionMapping(xdesc, Util.getGeneratedJavaClassName(nestedType.getTypeName(), this.dbwsBuilder.getProjectName()));
            } else if (nestedType.isComposite()) {
                this.buildAndAddXMLCompositeCollectionMapping(xdesc, tableName.toLowerCase() + "_CollectionWrapper");
            } else {
                this.buildAndAddXMLCompositeDirectCollectionMapping(xdesc, "items", "item/text()", Util.getAttributeClassForDatabaseType(nestedType));
            }
        }
    }

    protected void addToORProjectForPLSQLTableArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String tableName, String tableAlias, String targetTypeName, String catalogPattern) {
        boolean itemsMappingFound;
        ObjectRelationalDataTypeDescriptor ordt = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(tableAlias);
        if (ordt == null) {
            ordt = this.buildAndAddNewObjectRelationalDataTypeDescriptor(orProject, tableAlias, tableName.toLowerCase() + "_CollectionWrapper");
        }
        boolean bl = itemsMappingFound = ordt.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedType = ((PLSQLCollectionType)dbType).getEnclosedType();
            if (nestedType.isPLSQLRecordType()) {
                String referenceClassName = (catalogPattern + "." + ((PLSQLRecordType)nestedType).getTypeName()).toLowerCase();
                this.buildAndAddObjectArrayMapping(ordt, "items", "ITEMS", referenceClassName, targetTypeName);
                if (orProject.getDescriptorForAlias(referenceClassName) == null) {
                    String refTypeName = catalogPattern + "_" + ((PLSQLRecordType)nestedType).getTypeName();
                    this.addToORProjectForPLSQLRecordArg(nestedType, orProject, referenceClassName, refTypeName.toLowerCase(), refTypeName, catalogPattern);
                }
            } else if (nestedType.isObjectType()) {
                this.buildAndAddObjectArrayMapping(ordt, "items", "ITEMS", Util.getGeneratedJavaClassName(nestedType.getTypeName(), this.dbwsBuilder.getProjectName()), targetTypeName);
            } else {
                this.buildAndAddArrayMapping(ordt, "items", "ITEMS", targetTypeName);
            }
        }
    }

    protected void addToOXProjectForVArrayArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String arrayName, String arrayAlias) {
        boolean itemsMappingFound;
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedDbType = ((VArrayType)dbType).getEnclosedType();
        String referenceTypeAlias = Util.getGeneratedAlias(nestedDbType.getTypeName());
        String referenceTypeName = Util.getGeneratedJavaClassName(referenceTypeAlias, this.dbwsBuilder.getProjectName());
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(arrayAlias);
        if (xdesc == null) {
            xdesc = this.buildAndAddNewXMLDescriptor(oxProject, arrayAlias, arrayName + "_CollectionWrapper", this.nct.generateSchemaAlias(arrayAlias), Util.buildCustomQName(arrayName, this.dbwsBuilder).getNamespaceURI());
            XMLDescriptor refXdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(referenceTypeAlias);
            if (refXdesc == null && nestedDbType.isObjectType()) {
                this.addToOXProjectForObjectTypeArg(nestedDbType, oxProject, referenceTypeName, referenceTypeAlias);
            }
        }
        boolean bl = itemsMappingFound = xdesc.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            if (nestedDbType.isComposite()) {
                this.buildAndAddXMLCompositeCollectionMapping(xdesc, referenceTypeName);
            } else {
                this.buildAndAddXMLCompositeDirectCollectionMapping(xdesc, "items", "item/text()", Util.getAttributeClassForDatabaseType(nestedDbType));
            }
        }
    }

    protected void addToORProjectForVArrayArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String arrayName, String arrayAlias) {
        boolean itemsMappingFound;
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedDbType = ((VArrayType)dbType).getEnclosedType();
        String referenceTypeAlias = Util.getGeneratedAlias(nestedDbType.getTypeName());
        String referenceTypeName = Util.getGeneratedJavaClassName(referenceTypeAlias, this.dbwsBuilder.getProjectName());
        ObjectRelationalDataTypeDescriptor ordt = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(arrayAlias);
        if (ordt == null) {
            ordt = this.buildAndAddNewObjectRelationalDataTypeDescriptor(orProject, arrayAlias, arrayName + "_CollectionWrapper");
            ClassDescriptor refdesc = orProject.getDescriptorForAlias(referenceTypeAlias);
            if (refdesc == null && nestedDbType.isObjectType()) {
                this.addToORProjectForObjectTypeArg(nestedDbType, orProject, referenceTypeName, referenceTypeAlias);
            }
        }
        boolean bl = itemsMappingFound = ordt.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            if (nestedDbType.isComposite()) {
                this.buildAndAddObjectArrayMapping(ordt, "items", "ITEMS", referenceTypeName, arrayName);
            } else {
                this.buildAndAddArrayMapping(ordt, "items", "ITEMS", arrayAlias.toUpperCase(), nestedDbType.getTypeName());
            }
        }
    }

    protected void addToOXProjectForObjectTypeArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String objectName, String objectAlias) {
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(objectAlias);
        if (xdesc == null) {
            xdesc = this.buildAndAddNewXMLDescriptor(oxProject, objectAlias, objectName, this.nct.generateSchemaAlias(dbType.getTypeName()), Util.buildCustomQName(objectName, this.dbwsBuilder).getNamespaceURI());
        }
        ObjectType oType = (ObjectType)dbType;
        for (FieldType field : oType.getFields()) {
            String lFieldName;
            if (this.nct.styleForElement(field.getFieldName()) == NamingConventionTransformer.ElementStyle.NONE || xdesc.getMappingForAttributeName(lFieldName = field.getFieldName().toLowerCase()) != null) continue;
            if (field.isComposite()) {
                ObjectTableType tableType;
                boolean buildDescriptor;
                String targetTypeName2 = field.getEnclosedType().getTypeName();
                String alias = Util.getGeneratedAlias(targetTypeName2);
                XMLDescriptor xdesc2 = (XMLDescriptor)oxProject.getDescriptorForAlias(alias);
                boolean bl = buildDescriptor = xdesc2 == null;
                if (buildDescriptor) {
                    xdesc2 = this.buildAndAddNewXMLDescriptor(oxProject, alias, this.nct.generateSchemaAlias(targetTypeName2), Util.buildCustomQName(targetTypeName2, this.dbwsBuilder).getNamespaceURI());
                }
                if (field.getEnclosedType().isObjectType()) {
                    if (buildDescriptor) {
                        xdesc2.setJavaClassName(Util.getGeneratedJavaClassName(alias, this.dbwsBuilder.getProjectName()));
                        this.addToOXProjectForObjectTypeArg(field.getEnclosedType(), oxProject, xdesc2.getJavaClassName(), alias);
                    }
                    this.buildAndAddXMLCompositeObjectMapping(xdesc, lFieldName, xdesc2.getJavaClassName());
                    continue;
                }
                if (field.getEnclosedType().isVArrayType()) {
                    if (buildDescriptor) {
                        xdesc2.setJavaClassName(Util.getGeneratedJavaClassName(alias, this.dbwsBuilder.getProjectName()));
                        this.addToOXProjectForVArrayArg(field.getEnclosedType(), oxProject, xdesc2.getJavaClassName(), alias);
                    }
                    this.buildAndAddXMLCompositeDirectCollectionMapping(xdesc, lFieldName, lFieldName + "/text()", Util.getAttributeClassForDatabaseType(field.getEnclosedType()));
                    continue;
                }
                if (!field.getEnclosedType().isObjectTableType()) continue;
                if (buildDescriptor) {
                    xdesc2.setJavaClassName(Util.getGeneratedJavaClassName(alias, this.dbwsBuilder.getProjectName()));
                    this.addToOXProjectForObjectTableTypeArg(field.getEnclosedType(), oxProject, targetTypeName2, alias);
                }
                if ((tableType = (ObjectTableType)field.getEnclosedType()).getEnclosedType().isComposite()) {
                    String nestedTypeAlias = Util.getGeneratedAlias(((ObjectTableType)field.getEnclosedType()).getEnclosedType().getTypeName());
                    String nestedTypeName = Util.getGeneratedJavaClassName(nestedTypeAlias, this.dbwsBuilder.getProjectName());
                    this.buildAndAddXMLCompositeCollectionMapping(xdesc, lFieldName, lFieldName + "/item", nestedTypeName);
                    continue;
                }
                this.buildAndAddXMLCompositeDirectCollectionMapping(xdesc, lFieldName, lFieldName + "/text()", Util.getAttributeClassForDatabaseType((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)tableType));
                continue;
            }
            this.addDirectMappingForFieldType(xdesc, lFieldName, field);
        }
    }

    protected void addToORProjectForObjectTypeArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String objectName, String objectAlias) {
        ObjectRelationalDataTypeDescriptor ordt = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(objectAlias);
        if (ordt == null) {
            ordt = this.buildAndAddNewObjectRelationalDataTypeDescriptor(orProject, objectAlias, objectName);
        }
        ObjectType oType = (ObjectType)dbType;
        for (FieldType fType : oType.getFields()) {
            String fieldName = fType.getFieldName();
            String lFieldName = fieldName.toLowerCase();
            boolean found = false;
            Vector orderedFields = ordt.getOrderedFields();
            for (Object o : orderedFields) {
                DatabaseField field;
                if (!(o instanceof DatabaseField) || !(field = (DatabaseField)o).getName().equalsIgnoreCase(fieldName)) continue;
                found = true;
                break;
            }
            if (!found) {
                ordt.addFieldOrdering(fieldName);
            }
            if (ordt.getMappingForAttributeName(lFieldName) != null) continue;
            if (fType.isComposite()) {
                boolean buildDescriptor;
                String targetTypeName2 = fType.getEnclosedType().getTypeName();
                String alias = Util.getGeneratedAlias(targetTypeName2);
                ObjectRelationalDataTypeDescriptor ordt2 = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(alias);
                boolean bl = buildDescriptor = ordt2 == null;
                if (buildDescriptor) {
                    ordt2 = this.buildAndAddNewObjectRelationalDataTypeDescriptor(orProject, alias);
                }
                if (fType.getEnclosedType().isObjectType()) {
                    if (buildDescriptor) {
                        ordt2.setJavaClassName(Util.getGeneratedJavaClassName(alias, this.dbwsBuilder.getProjectName()));
                        this.addToORProjectForObjectTypeArg(fType.getEnclosedType(), orProject, ordt2.getJavaClassName(), alias);
                    }
                    this.buildAndAddStructureMapping(ordt, lFieldName, fieldName, ordt2.getJavaClassName());
                    continue;
                }
                if (fType.getEnclosedType().isVArrayType()) {
                    if (buildDescriptor) {
                        ordt2.setJavaClassName(Util.getGeneratedJavaClassName(alias, this.dbwsBuilder.getProjectName()));
                        this.addToORProjectForVArrayArg(fType.getEnclosedType(), orProject, ordt2.getJavaClassName(), alias);
                    }
                    this.buildAndAddArrayMapping(ordt, lFieldName, fieldName, this.getStructureNameForField(fType, null));
                    continue;
                }
                if (!fType.getEnclosedType().isObjectTableType()) continue;
                if (buildDescriptor) {
                    ordt2.setJavaClassName(Util.getGeneratedJavaClassName(alias, this.dbwsBuilder.getProjectName()));
                    this.addToORProjectForObjectTableTypeArg(fType.getEnclosedType(), orProject, targetTypeName2, alias);
                }
                if (((ObjectTableType)fType.getEnclosedType()).getEnclosedType().isComposite()) {
                    ObjectType nestedType = (ObjectType)((ObjectTableType)fType.getEnclosedType()).getEnclosedType();
                    String nestedTypeAlias = Util.getGeneratedAlias(nestedType.getTypeName());
                    String nestedTypeName = Util.getGeneratedJavaClassName(nestedTypeAlias, this.dbwsBuilder.getProjectName());
                    this.buildAndAddObjectArrayMapping(ordt, lFieldName, fieldName, nestedTypeName, nestedTypeAlias.toUpperCase());
                    continue;
                }
                this.buildAndAddArrayMapping(ordt, lFieldName, fieldName, alias.toUpperCase());
                continue;
            }
            DirectToFieldMapping dfm = new DirectToFieldMapping();
            dfm.setFieldName(fieldName);
            dfm.setAttributeName(lFieldName);
            dfm.setAttributeClassification(Util.getAttributeClassForDatabaseType(fType.getEnclosedType()));
            ordt.addMapping((DatabaseMapping)dfm);
        }
    }

    protected void addToOXProjectForObjectTableTypeArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project oxProject, String objectTableName, String objectTableAlias) {
        boolean itemsMappingFound;
        XMLDescriptor xdesc = (XMLDescriptor)oxProject.getDescriptorForAlias(objectTableAlias);
        if (xdesc == null) {
            xdesc = this.buildAndAddNewXMLDescriptor(oxProject, objectTableAlias, objectTableName + "_CollectionWrapper", this.nct.generateSchemaAlias(dbType.getTypeName()), Util.buildCustomQName(objectTableName, this.dbwsBuilder).getNamespaceURI());
        }
        boolean bl = itemsMappingFound = xdesc.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nType = ((ObjectTableType)dbType).getEnclosedType();
            if (nType.isObjectType()) {
                ObjectType oType = (ObjectType)nType;
                String nestedTypeAlias = Util.getGeneratedAlias(oType.getTypeName());
                String nestedTypeName = Util.getGeneratedJavaClassName(nestedTypeAlias, this.dbwsBuilder.getProjectName());
                this.addToOXProjectForObjectTypeArg((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)oType, oxProject, nestedTypeName, nestedTypeAlias);
                this.buildAndAddXMLCompositeCollectionMapping(xdesc, nestedTypeName);
            } else {
                this.buildAndAddXMLCompositeDirectCollectionMapping(xdesc, "items", "item/text()", Util.getAttributeClassForDatabaseType(nType));
            }
        }
    }

    protected void addToORProjectForObjectTableTypeArg(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dbType, Project orProject, String objectTableName, String objectTableAlias) {
        boolean itemsMappingFound;
        ObjectRelationalDataTypeDescriptor ordt = (ObjectRelationalDataTypeDescriptor)orProject.getDescriptorForAlias(objectTableAlias);
        if (ordt == null) {
            ordt = this.buildAndAddNewObjectRelationalDataTypeDescriptor(orProject, objectTableAlias, objectTableName + "_CollectionWrapper");
        }
        boolean bl = itemsMappingFound = ordt.getMappingForAttributeName("items") != null;
        if (!itemsMappingFound) {
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedType = ((ObjectTableType)dbType).getEnclosedType();
            if (nestedType.isObjectType()) {
                ObjectType oType = (ObjectType)nestedType;
                String nestedTypeAlias = Util.getGeneratedAlias(oType.getTypeName());
                String nestedTypeName = Util.getGeneratedJavaClassName(nestedTypeAlias, this.dbwsBuilder.getProjectName());
                this.addToORProjectForObjectTypeArg((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)oType, orProject, nestedTypeName, nestedTypeAlias);
                this.buildAndAddObjectArrayMapping(ordt, "items", "ITEMS", nestedTypeName, nestedTypeAlias.toUpperCase());
            } else {
                this.buildAndAddArrayMapping(ordt, "items", "ITEMS", objectTableAlias.toUpperCase());
            }
        }
    }

    @Override
    protected void buildQueryForProcedureType(ProcedureType procType, Project orProject, Project oxProject, ProcedureOperationModel opModel, boolean hasPLSQLArgs) {
        PLSQLStoredProcedureCall call;
        ArgumentType returnArg = procType.isFunctionType() ? ((FunctionType)procType).getReturnArgument() : null;
        boolean hasCursor = Util.hasPLSQLCursorArg(this.getArgumentListForProcedureType(procType));
        boolean bl = hasPLSQLArgs = hasPLSQLArgs || hasCursor || opModel.isPLSQLProcedureOperation();
        if (hasPLSQLArgs) {
            if (procType.isFunctionType()) {
                DatabaseType dType = this.buildDatabaseTypeFromMetadataType((org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType)returnArg, procType.getCatalogName());
                if (hasCursor) {
                    call = new PLSQLStoredFunctionCall();
                    ((PLSQLStoredFunctionCall)call).getArguments().remove(0);
                    ((PLSQLStoredFunctionCall)call).useNamedCursorOutputAsResultSet("CURSOR", dType);
                } else {
                    Class wrapperClass = this.getWrapperClass(dType);
                    if (wrapperClass != null) {
                        ((ComplexDatabaseType)dType).setJavaType(wrapperClass);
                    }
                    call = new PLSQLStoredFunctionCall(dType);
                    if (returnArg.getEnclosedType().isPLSQLCollectionType() && !((PLSQLCollectionType)returnArg.getEnclosedType()).isIndexed()) {
                        PLSQLargument plsqlArg = (PLSQLargument)((PLSQLStoredFunctionCall)call).getArguments().get(0);
                        ((PLSQLCollection)plsqlArg.databaseType).setIsNestedTable(true);
                    }
                }
            } else {
                call = new PLSQLStoredProcedureCall();
            }
        } else if (procType.isFunctionType()) {
            String javaTypeName = returnArg.getTypeName();
            ClassDescriptor desc = oxProject.getDescriptorForAlias(Util.getGeneratedAlias(javaTypeName));
            if (desc != null) {
                javaTypeName = desc.getJavaClassName();
            }
            if (returnArg.isComposite()) {
                org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dataType = returnArg.getEnclosedType();
                call = dataType.isVArrayType() || dataType.isObjectTableType() ? new StoredFunctionCall(2003, returnArg.getTypeName(), javaTypeName, (DatabaseField)this.buildFieldForNestedType(dataType)) : new StoredFunctionCall(2002, returnArg.getTypeName(), javaTypeName);
            } else {
                call = new StoredFunctionCall();
                if (returnArg.getEnclosedType().isBlobType()) {
                    ((StoredFunctionCall)call).setResult(null, ClassConstants.BLOB);
                } else {
                    int resultType = Util.getJDBCTypeFromTypeName(javaTypeName);
                    if (resultType == 91 || resultType == 92 || resultType == 93) {
                        ((StoredFunctionCall)call).setResult(null, ClassConstants.TIMESTAMP);
                    } else if (returnArg.getEnclosedType() == ScalarDatabaseTypeEnum.XMLTYPE_TYPE) {
                        ((StoredFunctionCall)call).setResult(org.eclipse.persistence.internal.xr.Util.getJDBCTypeForTypeName((String)"XMLTYPE"), "XMLTYPE", ClassConstants.OBJECT);
                    } else if (resultType == 1111 || resultType == 2005) {
                        ((StoredFunctionCall)call).setResult(null, ClassConstants.OBJECT);
                    } else {
                        ((StoredFunctionCall)call).setResult(null, resultType);
                    }
                }
            }
        } else {
            call = new StoredProcedureCall();
        }
        String cat = procType.getCatalogName();
        String catalogPrefix = cat == null || cat.length() == 0 ? "" : cat + ".";
        call.setProcedureName(catalogPrefix + procType.getProcedureName());
        String returnType = opModel.getReturnType();
        boolean hasResponse = returnType != null;
        Object dq = null;
        dq = hasCursor || hasResponse && opModel.isCollection() ? new DataReadQuery() : new ValueReadQuery();
        dq.bindAllParameters();
        dq.setName(this.getNameForQueryOperation(opModel, procType));
        dq.setCall((Call)call);
        for (ArgumentType arg : procType.getArguments()) {
            Class wrapperClass;
            if (arg.optional()) {
                call.addOptionalArgument(arg.getArgumentName());
            }
            org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType argType = arg.getEnclosedType();
            ArgumentTypeDirection direction = arg.getDirection();
            DatabaseType databaseType = null;
            String javaTypeName = null;
            if (hasPLSQLArgs) {
                databaseType = this.buildDatabaseTypeFromMetadataType(argType, cat);
            } else {
                javaTypeName = argType.getTypeName();
                ClassDescriptor desc = oxProject.getDescriptorForAlias(Util.getGeneratedAlias(javaTypeName));
                if (desc != null) {
                    javaTypeName = desc.getJavaClassName();
                }
            }
            if (direction == ArgumentTypeDirection.IN) {
                if (hasPLSQLArgs) {
                    wrapperClass = this.getWrapperClass(databaseType);
                    if (wrapperClass != null) {
                        ((ComplexDatabaseType)databaseType).setJavaType(wrapperClass);
                    }
                    call.addNamedArgument(arg.getArgumentName(), databaseType);
                    if (argType.isPLSQLCollectionType() && !((PLSQLCollectionType)argType).isIndexed()) {
                        PLSQLargument plsqlArg = (PLSQLargument)call.getArguments().get(call.getArguments().size() - 1);
                        ((PLSQLCollection)plsqlArg.databaseType).setIsNestedTable(true);
                    }
                } else if (argType.isVArrayType()) {
                    dq.addArgument(arg.getArgumentName());
                    call.addNamedArgument(arg.getArgumentName(), arg.getArgumentName(), 2003, argType.getTypeName(), javaTypeName);
                } else if (argType.isObjectType()) {
                    dq.addArgument(arg.getArgumentName());
                    call.addNamedArgument(arg.getArgumentName(), arg.getArgumentName(), 2002, argType.getTypeName(), javaTypeName);
                } else if (argType.isObjectTableType()) {
                    dq.addArgument(arg.getArgumentName(), Array.class);
                    call.addNamedArgument(arg.getArgumentName(), arg.getArgumentName(), 2003, argType.getTypeName(), this.getWrapperClass(javaTypeName), (DatabaseField)this.buildFieldForNestedType(argType));
                } else {
                    dq.addArgument(arg.getArgumentName());
                    call.addNamedArgument(arg.getArgumentName(), arg.getArgumentName(), Util.getJDBCTypeFromTypeName(argType.getTypeName()));
                }
            } else if (direction == ArgumentTypeDirection.OUT) {
                if (hasPLSQLArgs) {
                    if (arg.isPLSQLCursorType()) {
                        call.useNamedCursorOutputAsResultSet(arg.getArgumentName(), databaseType);
                    } else {
                        wrapperClass = this.getWrapperClass(databaseType);
                        if (wrapperClass != null) {
                            ((ComplexDatabaseType)databaseType).setJavaType(wrapperClass);
                        }
                        call.addNamedOutputArgument(arg.getArgumentName(), databaseType);
                    }
                } else if (argType.isComposite()) {
                    wrapperClass = this.getWrapperClass(javaTypeName);
                    if (argType.isVArrayType() || argType.isObjectTableType()) {
                        call.addNamedOutputArgument(arg.getArgumentName(), arg.getArgumentName(), 2003, argType.getTypeName(), wrapperClass, (DatabaseField)this.buildFieldForNestedType(argType));
                    } else {
                        call.addNamedOutputArgument(arg.getArgumentName(), arg.getArgumentName(), 2002, argType.getTypeName(), wrapperClass);
                    }
                } else if (argType == ScalarDatabaseTypeEnum.XMLTYPE_TYPE) {
                    call.addNamedOutputArgument(arg.getArgumentName(), arg.getArgumentName(), org.eclipse.persistence.internal.xr.Util.getJDBCTypeForTypeName((String)"XMLTYPE"), "XMLTYPE");
                } else if (argType == ScalarDatabaseTypeEnum.SYS_REFCURSOR_TYPE) {
                    call.addNamedCursorOutputArgument(arg.getArgumentName());
                } else {
                    call.addNamedOutputArgument(arg.getArgumentName(), arg.getArgumentName(), Util.getJDBCTypeFromTypeName(argType.getTypeName()));
                }
            } else if (hasPLSQLArgs) {
                wrapperClass = this.getWrapperClass(databaseType);
                if (wrapperClass != null) {
                    ((ComplexDatabaseType)databaseType).setJavaType(wrapperClass);
                }
                call.addNamedInOutputArgument(arg.getArgumentName(), databaseType);
                if (argType.isPLSQLCollectionType() && !((PLSQLCollectionType)argType).isIndexed()) {
                    PLSQLargument plsqlArg = (PLSQLargument)call.getArguments().get(call.getArguments().size() - 1);
                    ((PLSQLCollection)plsqlArg.databaseType).setIsNestedTable(true);
                }
            } else {
                dq.addArgument(arg.getArgumentName());
                if (argType.isComposite()) {
                    wrapperClass = this.getWrapperClass(javaTypeName);
                    if (argType.isVArrayType() || argType.isObjectTableType()) {
                        call.addNamedInOutputArgument(arg.getArgumentName(), arg.getArgumentName(), arg.getArgumentName(), 2003, argType.getTypeName(), wrapperClass, (DatabaseField)this.buildFieldForNestedType(argType));
                    } else {
                        call.addNamedInOutputArgument(arg.getArgumentName(), arg.getArgumentName(), arg.getArgumentName(), 2002, argType.getTypeName());
                    }
                } else {
                    Class javaType = org.eclipse.persistence.internal.xr.Util.getClassFromJDBCType((String)argType.getTypeName(), (DatabasePlatform)this.dbwsBuilder.getDatabasePlatform());
                    if (Util.shouldSetJavaType(javaType.getName())) {
                        call.addNamedInOutputArgument(arg.getArgumentName(), arg.getArgumentName(), arg.getArgumentName(), Util.getJDBCTypeFromTypeName(argType.getTypeName()), argType.getTypeName(), javaType);
                    } else {
                        call.addNamedInOutputArgument(arg.getArgumentName());
                    }
                }
            }
            if (!hasPLSQLArgs || direction != ArgumentTypeDirection.IN && direction != ArgumentTypeDirection.INOUT) continue;
            XMLDescriptor xdesc = null;
            if (hasResponse) {
                int idx = returnType.indexOf(58);
                if (idx == -1) {
                    idx = returnType.indexOf("}");
                }
                if (idx > 0) {
                    String typ = returnType.substring(idx + 1);
                    for (XMLDescriptor xd : oxProject.getOrderedDescriptors()) {
                        String context;
                        if (xd.getSchemaReference() == null || !(context = xd.getSchemaReference().getSchemaContext()).substring(1).equals(typ)) continue;
                        xdesc = xd;
                        break;
                    }
                }
            }
            if (xdesc != null) {
                dq.addArgumentByTypeName(arg.getArgumentName(), xdesc.getJavaClassName());
                continue;
            }
            if (databaseType instanceof PLSQLCollection || databaseType instanceof VArrayType) {
                dq.addArgument(arg.getArgumentName(), Array.class);
                continue;
            }
            if (databaseType instanceof PLSQLrecord || databaseType instanceof OracleObjectType) {
                dq.addArgument(arg.getArgumentName(), Struct.class);
                continue;
            }
            dq.addArgument(arg.getArgumentName(), JDBCTypes.getClassForCode((int)databaseType.getConversionCode()));
        }
        orProject.getQueries().add(dq);
    }

    protected ObjectRelationalDatabaseField buildFieldForNestedType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType owningType) {
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType nestedType;
        ObjectRelationalDatabaseField nestedField = new ObjectRelationalDatabaseField("");
        if (owningType.isVArrayType()) {
            nestedType = ((VArrayType)owningType).getEnclosedType();
            if (nestedType.isComposite()) {
                nestedField.setSqlTypeName(nestedType.getTypeName());
                nestedField.setSqlType(2002);
            } else {
                nestedField.setSqlTypeName(Util.getJDBCTypeNameFromType(2003));
                nestedField.setSqlType(2003);
            }
        } else {
            nestedType = ((ObjectTableType)owningType).getEnclosedType();
            nestedField.setSqlTypeName(nestedType.getTypeName());
            nestedField.setSqlType(2002);
        }
        nestedField.setTypeName(Util.getGeneratedJavaClassName(nestedType.getTypeName().toLowerCase(), this.dbwsBuilder.getProjectName()));
        return nestedField;
    }

    protected void addDirectMappingForFieldType(XMLDescriptor xdesc, String attributeName, FieldType fType) {
        XMLDirectMapping fieldMapping = new XMLDirectMapping();
        fieldMapping.setAttributeName(attributeName);
        XMLField xField = this.nct.styleForElement(attributeName) == NamingConventionTransformer.ElementStyle.ATTRIBUTE ? new XMLField("@" + attributeName) : new XMLField(attributeName + "/text()");
        QName qnameFromDatabaseType = Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(fType.getTypeName()));
        xField.setSchemaType(qnameFromDatabaseType);
        if (qnameFromDatabaseType == Constants.DATE_QNAME) {
            fieldMapping.setAttributeClassification(Date.class);
            xField.addXMLConversion(Constants.DATE_QNAME, Date.class);
            xField.addJavaConversion(Date.class, Constants.DATE_QNAME);
            xdesc.getNamespaceResolver().put("xsd", "http://www.w3.org/2001/XMLSchema");
        } else {
            Class attributeClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(qnameFromDatabaseType);
            if (attributeClass == null) {
                attributeClass = CoreClassConstants.OBJECT;
            }
            fieldMapping.setAttributeClassification(attributeClass);
        }
        fieldMapping.setField((DatabaseField)xField);
        AbstractNullPolicy nullPolicy = fieldMapping.getNullPolicy();
        nullPolicy.setNullRepresentedByEmptyNode(false);
        nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        nullPolicy.setNullRepresentedByXsiNil(true);
        fieldMapping.setNullPolicy(nullPolicy);
        xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xdesc.addMapping((DatabaseMapping)fieldMapping);
    }

    protected void buildAndAddXMLCompositeObjectMapping(XMLDescriptor xdesc, String attributeName, String referenceClassName) {
        xdesc.addMapping((DatabaseMapping)this.buildXMLCompositeObjectMapping(attributeName, referenceClassName));
    }

    protected void buildAndAddXMLCompositeObjectMapping(XMLDescriptor xdesc, String attributeName, String xpath, String referenceClassName) {
        xdesc.addMapping((DatabaseMapping)this.buildXMLCompositeObjectMapping(attributeName, referenceClassName));
    }

    protected XMLCompositeObjectMapping buildXMLCompositeObjectMapping(String attributeName, String referenceClassName) {
        return this.buildXMLCompositeObjectMapping(attributeName, attributeName, referenceClassName);
    }

    protected XMLCompositeObjectMapping buildXMLCompositeObjectMapping(String attributeName, String xpath, String referenceClassName) {
        XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setXPath(xpath);
        XMLField xField = (XMLField)mapping.getField();
        xField.setRequired(true);
        mapping.setReferenceClassName(referenceClassName);
        return mapping;
    }

    protected void buildAndAddXMLCompositeCollectionMapping(XMLDescriptor xdesc, String attributeName, String xPath, String referenceClassName) {
        xdesc.addMapping((DatabaseMapping)this.buildXMLCompositeCollectionMapping(attributeName, xPath, referenceClassName));
    }

    protected void buildAndAddXMLCompositeCollectionMapping(XMLDescriptor xdesc, String referenceClassName) {
        xdesc.addMapping((DatabaseMapping)this.buildXMLCompositeCollectionMapping(referenceClassName));
    }

    protected XMLCompositeCollectionMapping buildXMLCompositeCollectionMapping(String referenceClassName) {
        return this.buildXMLCompositeCollectionMapping("items", "item", referenceClassName);
    }

    protected XMLCompositeCollectionMapping buildXMLCompositeCollectionMapping(String attributeName, String xPath, String referenceClassName) {
        XMLCompositeCollectionMapping itemsMapping = new XMLCompositeCollectionMapping();
        itemsMapping.setAttributeName(attributeName);
        itemsMapping.setXPath(xPath);
        ((XMLField)itemsMapping.getField()).setRequired(true);
        itemsMapping.useCollectionClass(ArrayList.class);
        itemsMapping.setReferenceClassName(referenceClassName);
        return itemsMapping;
    }

    protected XMLCompositeDirectCollectionMapping buildAndAddXMLCompositeDirectCollectionMapping(XMLDescriptor xdesc, String attributeName, String xPath, Class<?> attributeElementClass) {
        XMLCompositeDirectCollectionMapping itemsMapping = this.buildXMLCompositeDirectCollectionMapping(attributeName, xPath, attributeElementClass);
        xdesc.getNamespaceResolver().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xdesc.addMapping((DatabaseMapping)itemsMapping);
        return itemsMapping;
    }

    protected XMLCompositeDirectCollectionMapping buildXMLCompositeDirectCollectionMapping(String attributeName, String xPath, Class<?> attributeElementClass) {
        XMLCompositeDirectCollectionMapping itemsMapping = new XMLCompositeDirectCollectionMapping();
        itemsMapping.setAttributeElementClass(attributeElementClass);
        itemsMapping.setAttributeName(attributeName);
        itemsMapping.setUsesSingleNode(true);
        itemsMapping.setXPath(xPath);
        ((XMLField)itemsMapping.getField()).setRequired(true);
        itemsMapping.useCollectionClass(ArrayList.class);
        AbstractNullPolicy nullPolicy = itemsMapping.getNullPolicy();
        nullPolicy.setNullRepresentedByEmptyNode(false);
        nullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
        nullPolicy.setNullRepresentedByXsiNil(true);
        itemsMapping.setNullPolicy(nullPolicy);
        return itemsMapping;
    }

    protected StructureMapping buildAndAddStructureMapping(ObjectRelationalDataTypeDescriptor orDesc, String attributeName, String fieldName, String referenceClassName) {
        StructureMapping structureMapping = this.buildStructureMapping(attributeName, fieldName, referenceClassName);
        orDesc.addMapping((DatabaseMapping)structureMapping);
        return structureMapping;
    }

    protected StructureMapping buildStructureMapping(String attributeName, String fieldName, String referenceClassName) {
        StructureMapping structureMapping = new StructureMapping();
        structureMapping.setAttributeName(attributeName);
        structureMapping.setFieldName(fieldName);
        structureMapping.setReferenceClassName(referenceClassName);
        this.referencedORDescriptors.add(referenceClassName);
        return structureMapping;
    }

    protected ObjectArrayMapping buildAndAddObjectArrayMapping(ObjectRelationalDataTypeDescriptor orDesc, String attributeName, String fieldName, String referenceClassName, String structureName) {
        ObjectArrayMapping objectArrayMapping = this.buildObjectArrayMapping(attributeName, fieldName, referenceClassName, structureName);
        orDesc.addMapping((DatabaseMapping)objectArrayMapping);
        return objectArrayMapping;
    }

    protected ObjectArrayMapping buildObjectArrayMapping(String attributeName, String fieldName, String referenceClassName, String structureName) {
        ObjectArrayMapping objectArrayMapping = new ObjectArrayMapping();
        objectArrayMapping.setAttributeName(attributeName);
        objectArrayMapping.setFieldName(fieldName);
        objectArrayMapping.setStructureName(structureName);
        objectArrayMapping.useCollectionClass(ArrayList.class);
        objectArrayMapping.setReferenceClassName(referenceClassName);
        this.referencedORDescriptors.add(referenceClassName);
        return objectArrayMapping;
    }

    protected ArrayMapping buildAndAddArrayMapping(ObjectRelationalDataTypeDescriptor orDesc, String attributeName, String fieldName, String structureName, String nestedTypeName) {
        ArrayMapping arrayMapping = this.buildArrayMapping(attributeName, fieldName, structureName);
        arrayMapping.setElementDataTypeName(nestedTypeName);
        orDesc.addMapping((DatabaseMapping)arrayMapping);
        return arrayMapping;
    }

    protected ArrayMapping buildAndAddArrayMapping(ObjectRelationalDataTypeDescriptor orDesc, String attributeName, String fieldName, String structureName) {
        ArrayMapping arrayMapping = this.buildArrayMapping(attributeName, fieldName, structureName);
        orDesc.addMapping((DatabaseMapping)arrayMapping);
        return arrayMapping;
    }

    protected ArrayMapping buildArrayMapping(String attributeName, String fieldName, String structureName) {
        ArrayMapping arrayMapping = new ArrayMapping();
        arrayMapping.setAttributeName(attributeName);
        arrayMapping.setFieldName(fieldName);
        arrayMapping.setStructureName(structureName);
        arrayMapping.useCollectionClass(ArrayList.class);
        return arrayMapping;
    }

    protected XMLDescriptor buildAndAddNewXMLDescriptor(Project oxProject, String objectAlias, String userType, String targetNamespace) {
        return this.buildAndAddNewXMLDescriptor(oxProject, objectAlias, objectAlias, userType, targetNamespace);
    }

    protected XMLDescriptor buildAndAddNewXMLDescriptor(Project oxProject, String objectAlias, String javaClassName, String userType, String targetNamespace) {
        XMLDescriptor xdesc = this.buildNewXMLDescriptor(objectAlias, javaClassName, userType, targetNamespace);
        oxProject.addDescriptor((ClassDescriptor)xdesc);
        return xdesc;
    }

    protected XMLDescriptor buildNewXMLDescriptor(String objectAlias, String userType, String targetNamespace) {
        return this.buildNewXMLDescriptor(objectAlias, objectAlias, userType, targetNamespace);
    }

    protected XMLDescriptor buildNewXMLDescriptor(String objectAlias, String javaClassName, String userType, String targetNamespace) {
        XMLDescriptor xdesc = new XMLDescriptor();
        xdesc.setAlias(objectAlias);
        xdesc.setJavaClassName(javaClassName);
        xdesc.getQueryManager();
        XMLSchemaURLReference schemaReference = new XMLSchemaURLReference();
        schemaReference.setSchemaContext("/" + userType);
        schemaReference.setType(1);
        xdesc.setSchemaReference((XMLSchemaReference)schemaReference);
        NamespaceResolver nr = new NamespaceResolver();
        nr.setDefaultNamespaceURI(targetNamespace);
        xdesc.setNamespaceResolver(nr);
        xdesc.setDefaultRootElement(userType);
        return xdesc;
    }

    protected ObjectRelationalDataTypeDescriptor buildAndAddNewObjectRelationalDataTypeDescriptor(Project orProject, String alias) {
        return this.buildAndAddNewObjectRelationalDataTypeDescriptor(orProject, alias, alias);
    }

    protected ObjectRelationalDataTypeDescriptor buildAndAddNewObjectRelationalDataTypeDescriptor(Project orProject, String alias, String javaClassName) {
        ObjectRelationalDataTypeDescriptor ordesc = this.buildNewObjectRelationalDataTypeDescriptor(alias, javaClassName);
        orProject.addDescriptor((ClassDescriptor)ordesc);
        return ordesc;
    }

    protected ObjectRelationalDataTypeDescriptor buildNewObjectRelationalDataTypeDescriptor(String alias) {
        return this.buildNewObjectRelationalDataTypeDescriptor(alias, alias);
    }

    protected ObjectRelationalDataTypeDescriptor buildNewObjectRelationalDataTypeDescriptor(String alias, String javaClassName) {
        ObjectRelationalDataTypeDescriptor ordt = new ObjectRelationalDataTypeDescriptor();
        ordt.setStructureName(alias.toUpperCase());
        ordt.descriptorIsAggregate();
        this.createdORDescriptors.put(javaClassName, ordt);
        ordt.setAlias(alias);
        ordt.setJavaClassName(javaClassName);
        ordt.getQueryManager();
        return ordt;
    }

    protected String getStructureNameForField(FieldType fType, String packageName) {
        org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType type = fType.getEnclosedType();
        Object structureName = type.getTypeName();
        if (packageName != null && packageName.length() > 0 && !packageName.equals("TOPLEVEL")) {
            structureName = packageName + "_" + (String)structureName;
        }
        return structureName;
    }

    protected void customizeSimpleXMLTagNames(PLSQLCursorType plsqlCursor, ProcedureOperationModel procedureOperationModel) {
        if (!plsqlCursor.isWeaklyTyped()) {
            if (procedureOperationModel.getSimpleXMLFormatTag() == null) {
                procedureOperationModel.setSimpleXMLFormatTag(plsqlCursor.getCursorName());
            }
            if (procedureOperationModel.getXmlTag() == null) {
                if (plsqlCursor.getEnclosedType().isPLSQLRecordType()) {
                    PLSQLRecordType recType = (PLSQLRecordType)plsqlCursor.getEnclosedType();
                    procedureOperationModel.setXmlTag(recType.getTypeName());
                } else if (plsqlCursor.getEnclosedType().isROWTYPEType()) {
                    ROWTYPEType rowType = (ROWTYPEType)plsqlCursor.getEnclosedType();
                    TableType tableType = (TableType)rowType.getEnclosedType();
                    procedureOperationModel.setXmlTag(tableType.getTableName());
                }
            }
        }
    }

    @Override
    protected DatabaseType buildDatabaseTypeFromMetadataType(org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType dType, String catalog) {
        DatabaseType databaseType = super.buildDatabaseTypeFromMetadataType(dType, catalog);
        return this.translateToOracleType(databaseType);
    }

    private DatabaseType translateToOracleType(DatabaseType databaseType) {
        switch (databaseType.getTypeName()) {
            case "NVARCHAR": {
                return JDBCTypes.NVARCHAR2_TYPE;
            }
        }
        return databaseType;
    }
}

