/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.splitteraddon;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.event.Event;

public class SplitHost {
    @Inject
    EModelService ms;
    @Inject
    EPartService ps;
    @Inject
    MCompositePart myPart;

    List<MPart> getSubParts() {
        List childParts = this.ms.findElements((MUIElement)this.myPart, null, MPart.class, null);
        return childParts;
    }

    MPart findInnerActive(MCompositePart outer) {
        MPart innerActive = null;
        Object curParent = outer;
        while (innerActive == null && curParent != null) {
            if (!(curParent instanceof MElementContainer)) continue;
            MElementContainer container = (MElementContainer)curParent;
            if (container.getSelectedElement() instanceof MPart) {
                innerActive = (MPart)container.getSelectedElement();
                continue;
            }
            curParent = container.getSelectedElement() instanceof MElementContainer ? container.getSelectedElement() : null;
        }
        return innerActive;
    }

    @Inject
    @Optional
    void tbrHandler(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*") Event eventData) {
        MUIElement changedElement = (MUIElement)eventData.getProperty("ChangedElement");
        if (!this.isOneOfMyParts(changedElement)) {
            return;
        }
        boolean isDirty = false;
        List<MPart> kids = this.getSubParts();
        kids.remove(0);
        for (MPart subPart : kids) {
            isDirty |= subPart.isDirty();
        }
        this.myPart.setDirty(isDirty);
    }

    private boolean isOneOfMyParts(MUIElement changedElement) {
        MElementContainer parent;
        MElementContainer parentObj = parent = changedElement.getParent();
        while (parent != null && parentObj != this.myPart) {
            parentObj = parent = parent.getParent();
        }
        return parentObj == this.myPart;
    }

    void callingAllParts(Class<? extends Annotation> clz) {
        List parts = this.ms.findElements((MUIElement)this.myPart, null, MPart.class, null);
        for (MPart part : parts) {
            if (part == this.myPart) continue;
            Control ctrl = (Control)part.getWidget();
            if (part.getObject() == null || ctrl == null || ctrl.isDisposed()) continue;
            ContextInjectionFactory.invoke((Object)part.getObject(), clz, (IEclipseContext)part.getContext(), null);
        }
    }

    @Persist
    void persist() {
        this.callingAllParts(Persist.class);
    }

    @PersistState
    void persistState() {
        this.callingAllParts(PersistState.class);
    }

    @Focus
    void setFocus() {
        MPart ap = this.findInnerActive(this.myPart);
        if (ap == null) {
            return;
        }
        Control ctrl = (Control)ap.getWidget();
        if (ap.getObject() != null && ctrl != null && !ctrl.isDisposed()) {
            ContextInjectionFactory.invoke((Object)ap.getObject(), Focus.class, (IEclipseContext)ap.getContext(), null);
        }
    }
}

