/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part.listener;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusNoteEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class RepresentationLinkPostCommitListener
extends ResourceSetListenerImpl {
    private DDiagramEditorImpl diagramEditor;

    public RepresentationLinkPostCommitListener(DDiagramEditorImpl dDiagramEditorImpl) {
        super(NotificationFilter.createFeatureFilter((EStructuralFeature)ViewpointPackage.Literals.DVIEW__OWNED_REPRESENTATION_DESCRIPTORS).and(NotificationFilter.NOT_TOUCH));
        this.diagramEditor = dDiagramEditorImpl;
        this.diagramEditor.getEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        HashSet<DRepresentationDescriptor> affected = new HashSet<DRepresentationDescriptor>();
        for (Notification notif : event.getNotifications()) {
            switch (notif.getEventType()) {
                case 4: {
                    affected.add((DRepresentationDescriptor)notif.getOldValue());
                    break;
                }
                case 6: {
                    affected.addAll((Collection)notif.getOldValue());
                    break;
                }
                case 3: {
                    affected.add((DRepresentationDescriptor)notif.getNewValue());
                    break;
                }
                case 5: {
                    affected.addAll((Collection)notif.getNewValue());
                    break;
                }
            }
        }
        ECrossReferenceAdapter semanticCrossReferencer = this.diagramEditor.getSession().getSemanticCrossReferencer();
        for (DRepresentationDescriptor descriptor : affected) {
            for (EObject referencer : new EObjectQuery((EObject)descriptor, semanticCrossReferencer).getInverseReferences(NotationPackage.Literals.VIEW__ELEMENT)) {
                EditPart part;
                if (!(referencer instanceof Shape) || ((Shape)referencer).getDiagram() != this.diagramEditor.getDiagram() || !((part = (EditPart)this.diagramEditor.getDiagramGraphicalViewer().getEditPartRegistry().get(referencer)) instanceof SiriusNoteEditPart)) continue;
                ((SiriusNoteEditPart)part).refreshDiagramNameCompartmentEditPart();
            }
        }
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
        this.diagramEditor = null;
    }
}

