/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.selection.page;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.common.ui.tools.api.navigator.GroupingContentProvider;
import org.eclipse.sirius.common.ui.tools.api.selection.page.AbstractSelectionWizardPage;
import org.eclipse.sirius.common.ui.tools.api.util.TreeItemWrapperContentProvider;
import org.eclipse.sirius.common.ui.tools.api.view.common.item.ItemDecorator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class EObjectPaneBasedSelectionWizardPage
extends AbstractSelectionWizardPage {
    Composite pageComposite;
    private TreeItemWrapper treeObjects;
    private final AdapterFactoryLabelProvider myAdapterFactoryLabelProvider;
    private EList<EObject> selectedEObjects = new BasicEList();
    private TreeViewer treeViewer;
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private String choiceOfValuesMessage;
    private String selectedValuesMessage;

    public EObjectPaneBasedSelectionWizardPage(String pageName, String title, ImageDescriptor imageTitle, String choiceOfValuesMessage, String selectedValuesMessage, AdapterFactory factory) {
        super(pageName, title, imageTitle);
        this.myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(factory);
        this.choiceOfValuesMessage = choiceOfValuesMessage;
        this.selectedValuesMessage = selectedValuesMessage;
    }

    public void init(Collection<? extends EObject> choiceOfValues, Collection<? extends EObject> preSelectedValues) {
        this.treeObjects = this.convertToTree(choiceOfValues);
        this.selectedEObjects.addAll(preSelectedValues);
    }

    public void init(TreeItemWrapper choiceOfValues, Collection<? extends EObject> preSelectedValues) {
        this.treeObjects = choiceOfValues;
        this.selectedEObjects.addAll(preSelectedValues);
    }

    private TreeItemWrapper convertToTree(Collection<?> objects2) {
        TreeItemWrapper root = new TreeItemWrapper(null, null);
        Iterator<?> iter = objects2.iterator();
        while (iter.hasNext()) {
            TreeItemWrapper treeItemWrapper = new TreeItemWrapper(iter.next(), root);
            root.getChildren().add(treeItemWrapper);
        }
        return root;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        GridLayout contentsGridLayout = new GridLayout();
        contentsGridLayout.numColumns = 1;
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)contentsGridLayout);
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createSelectionGroup(this.pageComposite);
        GridLayout otherLayout = new GridLayout();
        otherLayout.numColumns = 3;
        Composite otherComposite = new Composite(this.pageComposite, 0);
        otherComposite.setLayout((Layout)otherLayout);
        otherComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createChoiceComposite(otherComposite);
        this.createControlButtons(otherComposite);
        this.createSelectionComposite(otherComposite);
        this.createButtonListeners();
        this.myViewerfilter.setTreeViewer(this.treeViewer);
        EObjectPaneBasedSelectionWizardPage.expandTreeViewer(this.treeViewer);
        this.initRootPrefix();
        if (this.treeViewer.getTree().getItemCount() > 0) {
            this.treeViewer.getTree().setSelection(this.treeViewer.getTree().getItem(0));
        }
        this.setControl((Control)this.pageComposite);
    }

    private void createButtonListeners() {
        this.createAddButtonListener();
        this.createRemoveButtonListener();
        this.createUpButtonListener();
        this.createDownButtonListener();
    }

    private void createAddButtonListener() {
        if (this.addButton != null && this.treeViewer != null) {
            this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (EObjectPaneBasedSelectionWizardPage.this.addButton.isEnabled()) {
                        EObjectPaneBasedSelectionWizardPage.this.addButton.notifyListeners(13, null);
                    }
                }
            });
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (EObjectPaneBasedSelectionWizardPage.this.treeViewer != null) {
                        IStructuredSelection treeSelection = (IStructuredSelection)EObjectPaneBasedSelectionWizardPage.this.treeViewer.getSelection();
                        ArrayList<EObject> tableSelection = new ArrayList<EObject>();
                        for (Object value : treeSelection) {
                            if (value instanceof TreeItemWrapper) {
                                value = ((TreeItemWrapper)value).getWrappedObject();
                            }
                            if (!(value instanceof EObject)) continue;
                            tableSelection.add((EObject)value);
                            if (EObjectPaneBasedSelectionWizardPage.this.selectedEObjects.contains(value)) continue;
                            EObjectPaneBasedSelectionWizardPage.this.selectedEObjects.add((Object)((EObject)value));
                        }
                        EObjectPaneBasedSelectionWizardPage.this.tableViewer.refresh();
                        EObjectPaneBasedSelectionWizardPage.this.tableViewer.setSelection((ISelection)new StructuredSelection(tableSelection));
                    }
                }
            });
        }
    }

    private void createRemoveButtonListener() {
        if (this.removeButton != null && this.tableViewer != null) {
            this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (EObjectPaneBasedSelectionWizardPage.this.removeButton.isEnabled()) {
                        EObjectPaneBasedSelectionWizardPage.this.removeButton.notifyListeners(13, null);
                    }
                }
            });
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)EObjectPaneBasedSelectionWizardPage.this.tableViewer.getSelection();
                    Iterator i = selection.iterator();
                    while (i.hasNext()) {
                        EObjectPaneBasedSelectionWizardPage.this.selectedEObjects.remove(i.next());
                    }
                    EObjectPaneBasedSelectionWizardPage.this.tableViewer.refresh();
                    EObjectPaneBasedSelectionWizardPage.this.tableViewer.setSelection(null);
                }
            });
        }
    }

    private void createDownButtonListener() {
        if (this.downButton != null && this.tableViewer != null) {
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)EObjectPaneBasedSelectionWizardPage.this.tableViewer.getSelection();
                    UnmodifiableIterator i = Iterators.filter((Iterator)selection.iterator(), EObject.class);
                    int maxIndex = EObjectPaneBasedSelectionWizardPage.this.selectedEObjects.size() - selection.size();
                    while (i.hasNext()) {
                        EObject value = (EObject)i.next();
                        int index = EObjectPaneBasedSelectionWizardPage.this.selectedEObjects.indexOf((Object)value);
                        EObjectPaneBasedSelectionWizardPage.this.selectedEObjects.move(Math.min(index + 1, maxIndex++), (Object)value);
                    }
                    EObjectPaneBasedSelectionWizardPage.this.tableViewer.refresh();
                }
            });
        }
    }

    private void createUpButtonListener() {
        if (this.upButton != null && this.tableViewer != null) {
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)EObjectPaneBasedSelectionWizardPage.this.tableViewer.getSelection();
                    UnmodifiableIterator i = Iterators.filter((Iterator)selection.iterator(), EObject.class);
                    int minIndex = 0;
                    while (i.hasNext()) {
                        EObject value = (EObject)i.next();
                        int index = EObjectPaneBasedSelectionWizardPage.this.selectedEObjects.indexOf((Object)value);
                        EObjectPaneBasedSelectionWizardPage.this.selectedEObjects.move(Math.max(index - 1, minIndex++), (Object)value);
                    }
                    EObjectPaneBasedSelectionWizardPage.this.tableViewer.refresh();
                }
            });
        }
    }

    private void createChoiceComposite(Composite parent) {
        Composite pane = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        pane.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 250;
        pane.setLayoutData((Object)gridData);
        Label label = new Label(pane, 0);
        label.setText(this.choiceOfValuesMessage);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 4;
        labelGridData.horizontalAlignment = 4;
        label.setLayoutData((Object)labelGridData);
        this.treeViewer = this.createTreeViewer(pane);
        this.treeViewer.setInput((Object)this.treeObjects);
        EObjectPaneBasedSelectionWizardPage.expandTreeViewer(this.treeViewer);
    }

    private void createSelectionComposite(Composite parent) {
        Composite pane = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        pane.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        pane.setLayout((Layout)gridLayout);
        Label label = new Label(pane, 0);
        label.setText(this.selectedValuesMessage);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 4;
        labelGridData.horizontalAlignment = 4;
        label.setLayoutData((Object)labelGridData);
        this.tableViewer = this.createTableViewer(pane);
        this.tableViewer.setInput(this.selectedEObjects);
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    private TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.getTree().setHeaderVisible(false);
        viewer.getTree().setLinesVisible(false);
        GroupingContentProvider contentProvider = new GroupingContentProvider(new TreeItemWrapperContentProvider());
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new EObjectSelectionLabelProvider());
        viewer.addFilter((ViewerFilter)this.myViewerfilter);
        return viewer;
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = null;
        viewer = new TableViewer(parent, 268438274);
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.getTable().setHeaderVisible(false);
        viewer.getTable().setLinesVisible(false);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new EObjectSelectionLabelProvider());
        return viewer;
    }

    private void createControlButtons(Composite parent) {
        Composite pane = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        pane.setLayoutData((Object)gridData);
        GridLayout controlsButtonGridLayout = new GridLayout();
        pane.setLayout((Layout)controlsButtonGridLayout);
        Label label = new Label(pane, 0);
        GridData labelGridData = new GridData();
        labelGridData.verticalSpan = 4;
        label.setLayoutData((Object)labelGridData);
        this.addButton = new Button(pane, 8);
        this.addButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Add_label"));
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        this.addButton.setLayoutData((Object)addButtonGridData);
        this.removeButton = new Button(pane, 8);
        this.removeButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Remove_label"));
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        this.removeButton.setLayoutData((Object)removeButtonGridData);
        Label spaceLabel = new Label(pane, 0);
        GridData spaceLabelGridData = new GridData();
        spaceLabelGridData.verticalSpan = 2;
        spaceLabel.setLayoutData((Object)spaceLabelGridData);
        this.upButton = new Button(pane, 8);
        this.upButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Up_label"));
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        this.upButton.setLayoutData((Object)upButtonGridData);
        this.downButton = new Button(pane, 8);
        this.downButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Down_label"));
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        this.downButton.setLayoutData((Object)downButtonGridData);
    }

    public EList<EObject> getSelectedEObjects() {
        return this.selectedEObjects;
    }

    public void dispose() {
        this.myAdapterFactoryLabelProvider.dispose();
        if (this.pageComposite != null && !this.pageComposite.isDisposed()) {
            this.pageComposite.dispose();
        }
        this.addButton.dispose();
        this.upButton.dispose();
        this.downButton.dispose();
        this.removeButton.dispose();
        super.dispose();
    }

    public void setTreeObjects(Collection<? extends EObject> objects) {
        this.treeObjects = this.convertToTree(objects);
        if (this.treeViewer != null && this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.setInput((Object)this.treeObjects);
        }
    }

    private void initRootPrefix() {
        String prefix = null;
        boolean again = true;
        int count = this.treeViewer.getTree().getItemCount();
        int i = 0;
        while (i < count && again) {
            TreeItem treeItem = this.treeViewer.getTree().getItem(i);
            if ((prefix = this.computeCommonPrefix(prefix, treeItem)) == null) {
                again = false;
            } else if ((prefix = this.computeChildrenPrefix(prefix, treeItem)) == null) {
                again = false;
            }
            ++i;
        }
        if (prefix != null) {
            this.elementsToSelectText.setText(prefix);
            this.elementsToSelectText.setSelection(prefix.length());
        }
    }

    private String computeCommonPrefix(String oldPrefix, TreeItem treeItem) {
        String prefix = oldPrefix;
        if (prefix == null) {
            prefix = treeItem.getText();
        } else if (!treeItem.getText().startsWith(prefix)) {
            int searchIndex = Math.min(prefix.length() - 1, treeItem.getText().length());
            String newPrefix = null;
            while (searchIndex > 0 && newPrefix == null) {
                if (treeItem.getText().startsWith(prefix.substring(0, searchIndex))) {
                    newPrefix = prefix.substring(0, searchIndex);
                    continue;
                }
                --searchIndex;
            }
            prefix = newPrefix != null ? newPrefix : null;
        }
        return prefix;
    }

    private String computeChildrenPrefix(String oldPrefix, TreeItem parent) {
        String prefix = oldPrefix;
        boolean again = true;
        int count = parent.getItemCount();
        int i = 0;
        while (i < count && again) {
            TreeItem treeItem = parent.getItem(i);
            if ((prefix = this.computeCommonPrefix(prefix, treeItem)) == null) {
                again = false;
            } else if ((prefix = this.computeChildrenPrefix(prefix, treeItem)) == null) {
                again = false;
            }
            ++i;
        }
        return prefix;
    }

    private class EObjectSelectionLabelProvider
    extends LabelProvider {
        private EObjectSelectionLabelProvider() {
        }

        public Image getImage(Object element) {
            Image result = null;
            result = element instanceof TreeItemWrapper ? EObjectPaneBasedSelectionWizardPage.this.myAdapterFactoryLabelProvider.getImage(((TreeItemWrapper)element).getWrappedObject()) : (element instanceof ItemDecorator ? ((ItemDecorator)element).getImage() : EObjectPaneBasedSelectionWizardPage.this.myAdapterFactoryLabelProvider.getImage(element));
            return result;
        }

        public String getText(Object element) {
            String result = null;
            result = element instanceof TreeItemWrapper ? EObjectPaneBasedSelectionWizardPage.this.myAdapterFactoryLabelProvider.getText(((TreeItemWrapper)element).getWrappedObject()) : (element instanceof ItemDecorator ? ((ItemDecorator)element).getText() : EObjectPaneBasedSelectionWizardPage.this.myAdapterFactoryLabelProvider.getText(element));
            return result;
        }
    }
}

