/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.helper;

import java.util.Collection;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.query.GroupQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public final class SiriusDiagramHelper {
    private SiriusDiagramHelper() {
    }

    public static DDiagramElement createElement(RepresentationElementMapping mapping, DSemanticDiagram diagram, EObject modelElement) {
        IInterpreter interpreter;
        DNode created = null;
        if (mapping instanceof NodeMapping) {
            interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(modelElement);
            created = new NodeMappingHelper(interpreter).createNode((NodeMapping)mapping, modelElement, diagram.getTarget(), (DDiagram)diagram);
        }
        if (mapping instanceof ContainerMapping) {
            interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(diagram.getTarget());
            return new ContainerMappingWithInterpreterHelper(interpreter).createContainer((ContainerMapping)mapping, modelElement, diagram.getTarget(), (DDiagram)diagram);
        }
        return created;
    }

    public static DiagramDescription findDiagramDescription(Collection<Group> groups, String diagramDescriptionName) {
        for (Group group : groups) {
            Option<DiagramDescription> diagramDesc = new GroupQuery(group).findDiagramDescription(diagramDescriptionName);
            if (!diagramDesc.some()) continue;
            return (DiagramDescription)diagramDesc.get();
        }
        return null;
    }

    private static <T> void addUnique(EList<T> list, T elementToAdd) {
        if (list instanceof AbstractEList) {
            ((AbstractEList)list).addUnique(elementToAdd);
        } else {
            list.add(elementToAdd);
        }
    }

    private static <T> void addUnique(EList<T> list, int index, T elementToAdd) {
        if (list instanceof AbstractEList) {
            ((AbstractEList)list).addUnique(index, elementToAdd);
        } else {
            list.add(index, elementToAdd);
        }
    }

    public static void addNodeInContainer(DragAndDropTarget container, boolean border, AbstractDNode newNode) {
        if (container instanceof DDiagram) {
            SiriusDiagramHelper.addUnique(((DDiagram)container).getOwnedDiagramElements(), newNode);
        } else if (container instanceof DNodeContainer) {
            if (border) {
                if (newNode instanceof DNode) {
                    SiriusDiagramHelper.addUnique(((DNodeContainer)container).getOwnedBorderedNodes(), (DNode)newNode);
                }
            } else {
                SiriusDiagramHelper.addUnique(((DNodeContainer)container).getOwnedDiagramElements(), newNode);
            }
        } else if (container instanceof DNode) {
            if (newNode instanceof DNode) {
                SiriusDiagramHelper.addUnique(((DNode)container).getOwnedBorderedNodes(), (DNode)newNode);
            }
        } else if (container instanceof DNodeList) {
            if (border) {
                if (newNode instanceof DNode) {
                    SiriusDiagramHelper.addUnique(((DNodeList)container).getOwnedBorderedNodes(), (DNode)newNode);
                }
            } else {
                SiriusDiagramHelper.addUnique(((DNodeList)container).getOwnedElements(), (DNodeListElement)newNode);
            }
        }
    }

    public static void removeNodeFromContainer(DragAndDropTarget container, boolean border, AbstractDNode newNode) {
        if (container instanceof DDiagram) {
            ((DDiagram)container).getOwnedDiagramElements().remove((Object)newNode);
        } else if (container instanceof DNodeContainer) {
            if (border) {
                ((DNodeContainer)container).getOwnedBorderedNodes().remove((Object)newNode);
            } else {
                ((DNodeContainer)container).getOwnedDiagramElements().remove((Object)newNode);
            }
        } else if (container instanceof DNode) {
            ((DNode)container).getOwnedBorderedNodes().remove((Object)newNode);
        } else if (container instanceof DNodeList) {
            if (border) {
                ((DNodeList)container).getOwnedBorderedNodes().remove((Object)newNode);
            } else {
                ((DNodeList)container).getOwnedElements().remove((Object)newNode);
            }
        }
    }

    public static void addNodeInContainer(DragAndDropTarget container, boolean border, AbstractDNode newNode, int insertionIndex) {
        if (container instanceof DDiagram) {
            SiriusDiagramHelper.addUnique(((DDiagram)container).getOwnedDiagramElements(), insertionIndex, newNode);
        } else if (container instanceof DNodeContainer) {
            if (border) {
                if (newNode instanceof DNode) {
                    SiriusDiagramHelper.addUnique(((DNodeContainer)container).getOwnedBorderedNodes(), insertionIndex, (DNode)newNode);
                }
            } else {
                SiriusDiagramHelper.addUnique(((DNodeContainer)container).getOwnedDiagramElements(), insertionIndex, newNode);
            }
        } else if (container instanceof DNode) {
            if (newNode instanceof DNode) {
                SiriusDiagramHelper.addUnique(((DNode)container).getOwnedBorderedNodes(), insertionIndex, (DNode)newNode);
            }
        } else if (container instanceof DNodeList) {
            if (border) {
                if (newNode instanceof DNode) {
                    SiriusDiagramHelper.addUnique(((DNodeList)container).getOwnedBorderedNodes(), insertionIndex, (DNode)newNode);
                }
            } else {
                SiriusDiagramHelper.addUnique(((DNodeList)container).getOwnedElements(), insertionIndex, (DNodeListElement)newNode);
            }
        }
    }
}

