/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.options;

import java.util.HashMap;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.NullElkProgressMonitor;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphFactory;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IPropertyHolder;

public enum TopdownSizeApproximator {
    COUNT_CHILDREN{

        @Override
        public KVector getSize(ElkNode node) {
            double size = (Double)node.getProperty(CoreOptions.TOPDOWN_HIERARCHICAL_NODE_WIDTH) * Math.sqrt(node.getChildren().size());
            return new KVector(size, size / (Double)node.getProperty(CoreOptions.TOPDOWN_HIERARCHICAL_NODE_ASPECT_RATIO));
        }
    }
    ,
    LOOKAHEAD_LAYOUT{

        @Override
        public KVector getSize(ElkNode originalGraph) {
            LayoutAlgorithmData algorithmData = (LayoutAlgorithmData)originalGraph.getProperty(CoreOptions.RESOLVED_ALGORITHM);
            ElkNode node = ElkGraphFactory.eINSTANCE.createElkNode();
            node.copyProperties((IPropertyHolder)originalGraph);
            HashMap<ElkNode, ElkNode> oldToNewNodeMap = new HashMap<ElkNode, ElkNode>();
            for (ElkNode child : originalGraph.getChildren()) {
                ElkNode newChild = ElkGraphFactory.eINSTANCE.createElkNode();
                newChild.setParent(node);
                newChild.copyProperties((IPropertyHolder)child);
                KVector size = COUNT_CHILDREN.getSize(child);
                newChild.setDimensions(Math.max(child.getWidth(), size.x), Math.max(child.getHeight(), size.y));
                oldToNewNodeMap.put(child, newChild);
            }
            for (ElkNode child : originalGraph.getChildren()) {
                for (ElkEdge edge : child.getOutgoingEdges()) {
                    ElkNode newSrc = (ElkNode)oldToNewNodeMap.get(child);
                    ElkNode newTar = (ElkNode)oldToNewNodeMap.get(edge.getTargets().get(0));
                    ElkEdge newEdge = ElkGraphFactory.eINSTANCE.createElkEdge();
                    newEdge.getSources().add((Object)newSrc);
                    newEdge.getTargets().add((Object)newTar);
                    newEdge.setContainingNode(newSrc.getParent());
                    newEdge.copyProperties((IPropertyHolder)edge);
                }
            }
            AbstractLayoutProvider layoutProvider = algorithmData.getInstancePool().fetch();
            try {
                layoutProvider.layout(node, new NullElkProgressMonitor());
                algorithmData.getInstancePool().release(layoutProvider);
            }
            catch (Exception exception) {
                layoutProvider.dispose();
                throw exception;
            }
            if (!node.hasProperty(CoreOptions.CHILD_AREA_WIDTH) && !node.hasProperty(CoreOptions.CHILD_AREA_HEIGHT)) {
                ElkUtil.computeChildAreaDimensions(node);
            }
            double childAreaDesiredWidth = (Double)node.getProperty(CoreOptions.CHILD_AREA_WIDTH);
            double childAreaDesiredHeight = (Double)node.getProperty(CoreOptions.CHILD_AREA_HEIGHT);
            double childAreaDesiredAspectRatio = childAreaDesiredWidth / childAreaDesiredHeight;
            double baseSize = (Double)node.getProperty(CoreOptions.TOPDOWN_HIERARCHICAL_NODE_WIDTH) * Math.sqrt(node.getChildren().size());
            ElkPadding padding = (ElkPadding)node.getProperty(CoreOptions.PADDING);
            double minWidth = padding.left + padding.right + 1.0;
            double minHeight = padding.top + padding.bottom + 1.0;
            return new KVector(Math.max(minWidth, baseSize), Math.max(minHeight, baseSize / childAreaDesiredAspectRatio));
        }
    };


    public abstract KVector getSize(ElkNode var1);
}

