/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.featureExtensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.ui.business.api.featureExtensions.FeatureExtensionUI;
import org.eclipse.sirius.ui.business.api.featureExtensions.FeatureExtensionsUIManager;

public class FeatureExtensionsUIManagerImpl
implements FeatureExtensionsUIManager {
    Map<String, FeatureExtensionUI> aspects = new HashMap<String, FeatureExtensionUI>();

    public static FeatureExtensionsUIManager init() {
        FeatureExtensionsUIManagerImpl manager = new FeatureExtensionsUIManagerImpl();
        if (SiriusPlugin.IS_ECLIPSE_RUNNING) {
            List parsedAspects = EclipseUtil.getExtensionPlugins(FeatureExtensionUI.class, (String)"org.eclipse.sirius.ui.featureExtensionsui", (String)"class");
            for (FeatureExtensionUI aspect : parsedAspects) {
                manager.enableAspectUI(aspect);
            }
        }
        return manager;
    }

    @Override
    public Collection<CommandParameter> provideNewChildDescriptors() {
        ArrayList<CommandParameter> result = new ArrayList<CommandParameter>();
        for (FeatureExtensionUI aspect : this.aspects.values()) {
            result.addAll(aspect.getServices().provideNewChildDescriptors());
        }
        return result;
    }

    @Override
    public AdapterFactory createAdapterFactory() {
        ComposedAdapterFactory composed = new ComposedAdapterFactory();
        for (FeatureExtensionUI aspect : this.aspects.values()) {
            composed.addAdapterFactory(aspect.getServices().createAdapterFactory());
        }
        return composed;
    }

    @Override
    public void enableAspectUI(FeatureExtensionUI aspect) {
        this.aspects.put(aspect.getName(), aspect);
    }

    @Override
    public void disableAspectUI(FeatureExtensionUI aspect) {
        this.aspects.remove(aspect.getName());
    }
}

