/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;

public class CheckNbVisibleElementsInTree
extends DefaultCondition {
    private final SWTBotTree tree;
    private final int expected;
    private String errorMessage;

    public CheckNbVisibleElementsInTree(SWTBotTree tree, int expected) {
        this.tree = tree;
        this.expected = expected;
    }

    public CheckNbVisibleElementsInTree(SWTBotTree tree, int expected, String errorMessage) {
        this.tree = tree;
        this.expected = expected;
        this.errorMessage = errorMessage;
    }

    public boolean test() throws Exception {
        return this.tree.visibleRowCount() == this.expected;
    }

    public String getFailureMessage() {
        String suffix = "(expected:<" + this.expected + "> but was:<" + this.tree.visibleRowCount() + ">)";
        if (this.errorMessage == null) {
            return "This tree does not display " + this.expected + " elements " + suffix + ".";
        }
        return this.errorMessage + suffix;
    }
}

