/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.description;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LayoutOptionTarget implements Enumerator
{
    PARENT(0, "PARENT", "PARENT"),
    NODE(1, "NODE", "NODE"),
    EDGE(2, "EDGE", "EDGE"),
    PORTS(3, "PORTS", "PORTS"),
    LABEL(4, "LABEL", "LABEL");

    public static final int PARENT_VALUE = 0;
    public static final int NODE_VALUE = 1;
    public static final int EDGE_VALUE = 2;
    public static final int PORTS_VALUE = 3;
    public static final int LABEL_VALUE = 4;
    private static final LayoutOptionTarget[] VALUES_ARRAY;
    public static final List<LayoutOptionTarget> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LayoutOptionTarget[]{PARENT, NODE, EDGE, PORTS, LABEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LayoutOptionTarget get(String literal) {
        LayoutOptionTarget[] layoutOptionTargetArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutOptionTarget result = layoutOptionTargetArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static LayoutOptionTarget getByName(String name) {
        LayoutOptionTarget[] layoutOptionTargetArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutOptionTarget result = layoutOptionTargetArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static LayoutOptionTarget get(int value) {
        switch (value) {
            case 0: {
                return PARENT;
            }
            case 1: {
                return NODE;
            }
            case 2: {
                return EDGE;
            }
            case 3: {
                return PORTS;
            }
            case 4: {
                return LABEL;
            }
        }
        return null;
    }

    private LayoutOptionTarget(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

