/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.menu.vector;

import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.export.core.AxisSettings;
import org.eclipse.swtchart.export.menu.vector.AbstractInkscapeTemplate;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;

public abstract class AbstractInkscapeLineChart
extends AbstractInkscapeTemplate {
    protected StringBuilder printScatterData(ISeries<?> dataSeries, int widthPlotArea, int heightPlotArea, AxisSettings axisSettings, int index, IAxisSet axisSet, boolean isReversedX, boolean isReversedY) {
        StringBuilder out = new StringBuilder("");
        StringBuilder data = new StringBuilder("<circle\n         style=\"opacity:1;fill:%COLOR%;fill-opacity:1;stroke:none;stroke-width:0.96499991;stroke-linecap:square;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\"\n         id=\"rect901\"\n\t cx=\"%x-coordinate%\"\n\t cy=\"%y-coordinate%\"\n\t r=\"1\" />");
        ILineSeries lineSerie = (ILineSeries)dataSeries;
        Color lineColor = lineSerie.getSymbolColor();
        String color = this.getColor(lineColor);
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        String[] split = data.toString().split("\\n");
        int size = dataSeries.getXSeries().length;
        String match1 = ".*%COLOR%.*";
        String match2 = ".*%x-coordinate%.*";
        String match3 = ".*%y-coordinate%.*";
        int i = 0;
        while (i < size) {
            Point point = dataSeries.getPixelCoordinates(i);
            if (point.x >= 0 && point.x <= widthPlotArea && point.y >= 0 && point.y <= heightPlotArea) {
                double x = Double.parseDouble(this.printValueScatterPlot("x", index, xSeries[i], indexAxisX, axisSet, 0, axisScaleConverterX, isReversedX, isReversedY));
                double y = Double.parseDouble(this.printValueScatterPlot("y", index, ySeries[i], indexAxisY, axisSet, 0, axisScaleConverterY, isReversedX, isReversedY));
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (Pattern.matches(match1, string)) {
                        string = string.replace("%COLOR%", color);
                    } else if (Pattern.matches(match2, string)) {
                        string = string.replace("%x-coordinate%", String.valueOf(x));
                    } else if (Pattern.matches(match3, string)) {
                        string = string.replace("%y-coordinate%", String.valueOf(y));
                    }
                    out.append(string);
                    out.append("\n");
                    ++n2;
                }
            }
            ++i;
        }
        return out;
    }

    private String printValueScatterPlot(String axis, int index, double value, int indexAxis, IAxisSet axisSet, int indexPrimaryAxis, IAxisScaleConverter axisScaleConverter, boolean isReversedX, boolean isReversedY) {
        String ret = null;
        double x = 232.0;
        double y = 183.0;
        if (indexAxis == indexPrimaryAxis || axisScaleConverter == null) {
            if (axis.equals("x")) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                double x1 = !isReversedX ? 23.5 + (value - xLower) / (xUpper - xLower) * x : 23.5 + x - (value - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals("y")) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                double y1 = 263.5 - (y - (yUpper - value) / (yUpper - yLower) * y);
                ret = String.valueOf(y1);
            }
        } else if (axisScaleConverter != null) {
            if (axis.equals("x")) {
                IAxis xAxis = axisSet.getXAxis(indexAxis);
                double xUpper = xAxis.getRange().upper;
                double xLower = xAxis.getRange().lower;
                value = axisScaleConverter.convertToSecondaryUnit(value);
                double x1 = !isReversedX ? 23.5 + (axisScaleConverter.convertToSecondaryUnit(value) - xLower) / (xUpper - xLower) * x : 23.5 + x - (axisScaleConverter.convertToSecondaryUnit(value) - xLower) / (xUpper - xLower) * x;
                ret = String.valueOf(x1);
            } else if (axis.equals("y")) {
                IAxis yAxis = axisSet.getYAxis(indexAxis);
                double yUpper = yAxis.getRange().upper;
                double yLower = yAxis.getRange().lower;
                value = axisScaleConverter.convertToSecondaryUnit(value);
                double y1 = !isReversedY ? 80.5 + (yUpper - axisScaleConverter.convertToSecondaryUnit(value)) / (yUpper - yLower) * y : 263.5 - y + (yUpper - axisScaleConverter.convertToSecondaryUnit(value)) / (yUpper - yLower) * y;
                ret = String.valueOf(y1);
            }
        }
        return ret;
    }
}

