/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.vectorgraphics2d.svg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swtchart.vectorgraphics2d.core.GraphicsState;
import org.eclipse.swtchart.vectorgraphics2d.core.SizedDocument;
import org.eclipse.swtchart.vectorgraphics2d.core.VectorHints;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.CommandSequence;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.AffineTransformCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.Command;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.CreateCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.DisposeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.DrawImageCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.DrawShapeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.DrawStringCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.FillShapeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.Group;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetBackgroundCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetClipCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetColorCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetCompositeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetFontCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetHintCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetPaintCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetStrokeCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.SetTransformCommand;
import org.eclipse.swtchart.vectorgraphics2d.intermediate.commands.StateCommand;
import org.eclipse.swtchart.vectorgraphics2d.util.Base64EncodeStream;
import org.eclipse.swtchart.vectorgraphics2d.util.DataUtils;
import org.eclipse.swtchart.vectorgraphics2d.util.GraphicsUtils;
import org.eclipse.swtchart.vectorgraphics2d.util.PageSize;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

class SVGDocument
extends SizedDocument {
    private static final String SVG_DOCTYPE_QNAME = "svg";
    private static final String SVG_DOCTYPE_PUBLIC_ID = "-//W3C//DTD SVG 1.1//EN";
    private static final String SVG_DOCTYPE_SYSTEM_ID = "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd";
    private static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    private static final String XLINK_NAMESPACE = "xlink";
    private static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    private static final String PREFIX_CLIP = "clip";
    private static final String CHARSET = "UTF-8";
    private final Stack<GraphicsState> states = new Stack();
    private final Document doc;
    private final Element root;
    private Element group;
    private boolean groupAdded;
    private Element defs;
    private final Map<Integer, Element> clippingPathElements;
    private static final Map<Integer, String> STROKE_ENDCAPS = DataUtils.map(new Integer[]{0, 1, 2}, new String[]{"butt", "round", "square"});
    private static final Map<Integer, String> STROKE_LINEJOIN = DataUtils.map(new Integer[]{0, 1, 2}, new String[]{"miter", "round", "bevel"});

    public SVGDocument(CommandSequence commands, PageSize pageSize) {
        super(pageSize, true);
        DocumentBuilder docBuilder;
        this.states.push(new GraphicsState());
        this.clippingPathElements = new HashMap<Integer, Element>();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setValidating(false);
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Could not create XML builder.");
        }
        DOMImplementation domImpl = docBuilder.getDOMImplementation();
        DocumentType docType = domImpl.createDocumentType(SVG_DOCTYPE_QNAME, SVG_DOCTYPE_PUBLIC_ID, SVG_DOCTYPE_SYSTEM_ID);
        this.doc = domImpl.createDocument(SVG_NAMESPACE_URI, SVG_DOCTYPE_QNAME, docType);
        this.doc.setXmlStandalone(false);
        this.root = this.doc.getDocumentElement();
        this.initRoot();
        this.group = this.root;
        for (Command command : commands) {
            this.handle(command);
        }
    }

    private GraphicsState getCurrentState() {
        return this.states.peek();
    }

    private void initRoot() {
        double x = this.getPageSize().getX();
        double y = this.getPageSize().getY();
        double width = this.getPageSize().getWidth();
        double height = this.getPageSize().getHeight();
        this.root.setAttribute("xmlns:xlink", XLINK_NAMESPACE_URI);
        this.root.setAttribute("version", "1.1");
        this.root.setAttribute("x", DataUtils.format(x) + "px");
        this.root.setAttribute("y", DataUtils.format(y) + "px");
        this.root.setAttribute("width", DataUtils.format(width) + "px");
        this.root.setAttribute("height", DataUtils.format(height) + "px");
        this.root.setAttribute("viewBox", DataUtils.join(" ", new double[]{x, y, width, height}));
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("standalone", "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("encoding", CHARSET);
            transformer.setOutputProperty("doctype-public", this.doc.getDoctype().getPublicId());
            transformer.setOutputProperty("doctype-system", this.doc.getDoctype().getSystemId());
            transformer.transform(new DOMSource(this.doc), new StreamResult(out));
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeTo(out);
            return out.toString(CHARSET);
        }
        catch (IOException e) {
            return "";
        }
    }

    private void newGroup() {
        AffineTransform tx;
        this.group = this.doc.createElement("g");
        this.groupAdded = false;
        Shape clip = this.getCurrentState().getClip();
        if (clip != GraphicsState.DEFAULT_CLIP) {
            Element clipElem = this.getClipElement(clip);
            String ref = "url(#" + clipElem.getAttribute("id") + ")";
            this.group.setAttribute("clip-path", ref);
        }
        if (!GraphicsState.DEFAULT_TRANSFORM.equals(tx = this.getCurrentState().getTransform())) {
            this.group.setAttribute("transform", SVGDocument.getOutput(tx));
        }
    }

    private Element getClipElement(Shape clip) {
        Element path = this.clippingPathElements.get(clip.hashCode());
        if (path != null) {
            return path;
        }
        if (this.defs == null) {
            this.defs = this.doc.createElement("defs");
            this.root.insertBefore(this.defs, this.root.getFirstChild());
        }
        path = this.doc.createElement("clipPath");
        path.setAttribute("id", PREFIX_CLIP + clip.hashCode());
        Element shape = this.getElement(clip);
        shape.removeAttribute("style");
        path.appendChild(shape);
        this.defs.appendChild(path);
        this.clippingPathElements.put(clip.hashCode(), path);
        return path;
    }

    private void addToGroup(Element e) {
        this.group.appendChild(e);
        if (!this.groupAdded && this.group != this.root) {
            this.root.appendChild(this.group);
            this.groupAdded = true;
        }
    }

    public void handle(Command<?> command) {
        if (command instanceof Group) {
            Group c = (Group)command;
            this.applyStateCommands((List)c.getValue());
            if (this.containsGroupCommand((List)c.getValue())) {
                this.newGroup();
            }
        } else if (command instanceof DrawImageCommand) {
            DrawImageCommand c = (DrawImageCommand)command;
            Element e = this.getElement((Image)c.getValue(), c.getX(), c.getY(), c.getWidth(), c.getHeight());
            this.addToGroup(e);
        } else if (command instanceof DrawShapeCommand) {
            DrawShapeCommand c = (DrawShapeCommand)command;
            Element e = this.getElement((Shape)c.getValue());
            e.setAttribute("style", this.getStyle(false));
            this.addToGroup(e);
        } else if (command instanceof DrawStringCommand) {
            DrawStringCommand c = (DrawStringCommand)command;
            Element e = this.getElement((String)c.getValue(), c.getX(), c.getY());
            e.setAttribute("style", this.getStyle(this.getCurrentState().getFont()));
            this.addToGroup(e);
        } else if (command instanceof FillShapeCommand) {
            FillShapeCommand c = (FillShapeCommand)command;
            Shape shape = (Shape)c.getValue();
            Element e = this.getElement(shape);
            if (shape instanceof Path2D) {
                Path2D path = (Path2D)shape;
                e.setAttribute("style", this.getStyle(true, path.getWindingRule() == 1));
            } else {
                e.setAttribute("style", this.getStyle(true));
            }
            this.addToGroup(e);
        }
    }

    private void applyStateCommands(List<Command<?>> commands) {
        for (Command<?> command : commands) {
            StateCommand c;
            GraphicsState state = this.getCurrentState();
            if (command instanceof SetBackgroundCommand) {
                c = (SetBackgroundCommand)command;
                state.setBackground((Color)c.getValue());
                continue;
            }
            if (command instanceof SetClipCommand) {
                c = (SetClipCommand)command;
                state.setClip((Shape)c.getValue());
                continue;
            }
            if (command instanceof SetColorCommand) {
                c = (SetColorCommand)command;
                state.setColor((Color)c.getValue());
                continue;
            }
            if (command instanceof SetCompositeCommand) {
                c = (SetCompositeCommand)command;
                state.setComposite((Composite)c.getValue());
                continue;
            }
            if (command instanceof SetFontCommand) {
                c = (SetFontCommand)command;
                state.setFont((Font)c.getValue());
                continue;
            }
            if (command instanceof SetPaintCommand) {
                c = (SetPaintCommand)command;
                state.setPaint((Paint)c.getValue());
                continue;
            }
            if (command instanceof SetStrokeCommand) {
                c = (SetStrokeCommand)command;
                state.setStroke((Stroke)c.getValue());
                continue;
            }
            if (command instanceof SetTransformCommand) {
                c = (SetTransformCommand)command;
                state.setTransform((AffineTransform)c.getValue());
                continue;
            }
            if (command instanceof AffineTransformCommand) {
                c = (AffineTransformCommand)command;
                AffineTransform stateTransform = state.getTransform();
                AffineTransform transformToBeApplied = (AffineTransform)c.getValue();
                stateTransform.concatenate(transformToBeApplied);
                state.setTransform(stateTransform);
                continue;
            }
            if (command instanceof SetHintCommand) {
                c = (SetHintCommand)command;
                state.getHints().put(((SetHintCommand)c).getKey(), c.getValue());
                continue;
            }
            if (command instanceof CreateCommand) {
                try {
                    this.states.push((GraphicsState)this.getCurrentState().clone());
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(command instanceof DisposeCommand)) continue;
            this.states.pop();
        }
    }

    private boolean containsGroupCommand(List<Command<?>> commands) {
        for (Command<?> command : commands) {
            if (!(command instanceof SetClipCommand) && !(command instanceof SetTransformCommand) && !(command instanceof AffineTransformCommand)) continue;
            return true;
        }
        return false;
    }

    private String getStyle(boolean filled) {
        return this.getStyle(filled, true);
    }

    private String getStyle(boolean filled, boolean fillRullNonZero) {
        StringBuilder style = new StringBuilder();
        Color color = this.getCurrentState().getColor();
        String colorOutput = SVGDocument.getOutput(color);
        double opacity = (double)color.getAlpha() / 255.0;
        if (filled) {
            SVGDocument.appendStyle(style, "fill", colorOutput);
            if (color.getAlpha() < 255) {
                SVGDocument.appendStyle(style, "fill-opacity", opacity);
            }
            if (!fillRullNonZero) {
                SVGDocument.appendStyle(style, "fill-rule", "evenodd");
            }
        } else {
            SVGDocument.appendStyle(style, "fill", "none");
        }
        if (!filled) {
            Stroke stroke;
            SVGDocument.appendStyle(style, "stroke", colorOutput);
            if (color.getAlpha() < 255) {
                SVGDocument.appendStyle(style, "stroke-opacity", opacity);
            }
            if ((stroke = this.getCurrentState().getStroke()) instanceof BasicStroke) {
                BasicStroke bs = (BasicStroke)stroke;
                if (bs.getLineWidth() != 1.0f) {
                    SVGDocument.appendStyle(style, "stroke-width", Float.valueOf(bs.getLineWidth()));
                }
                if (bs.getMiterLimit() != 4.0f) {
                    SVGDocument.appendStyle(style, "stroke-miterlimit", Float.valueOf(bs.getMiterLimit()));
                }
                if (bs.getEndCap() != 0) {
                    SVGDocument.appendStyle(style, "stroke-linecap", STROKE_ENDCAPS.get(bs.getEndCap()));
                }
                if (bs.getLineJoin() != 0) {
                    SVGDocument.appendStyle(style, "stroke-linejoin", STROKE_LINEJOIN.get(bs.getLineJoin()));
                }
                if (bs.getDashArray() != null) {
                    SVGDocument.appendStyle(style, "stroke-dasharray", DataUtils.join(",", bs.getDashArray()));
                    if (bs.getDashPhase() != 0.0f) {
                        SVGDocument.appendStyle(style, "stroke-dashoffset", Float.valueOf(bs.getDashPhase()));
                    }
                }
            }
        } else {
            SVGDocument.appendStyle(style, "stroke", "none");
        }
        return style.toString();
    }

    private String getStyle(Font font) {
        Object style = this.getStyle(true);
        if (!GraphicsState.DEFAULT_FONT.equals(font)) {
            style = (String)style + SVGDocument.getOutput(font);
        }
        return style;
    }

    private static void appendStyle(StringBuilder style, String attribute, Object value) {
        style.append(attribute).append(":").append(DataUtils.format(value)).append(";");
    }

    private static String getOutput(AffineTransform tx) {
        StringBuilder out = new StringBuilder();
        if (AffineTransform.getTranslateInstance(tx.getTranslateX(), tx.getTranslateY()).equals(tx)) {
            out.append("translate(").append(DataUtils.format(tx.getTranslateX())).append(" ").append(DataUtils.format(tx.getTranslateY())).append(")");
        } else {
            double[] matrix = new double[6];
            tx.getMatrix(matrix);
            out.append("matrix(").append(DataUtils.join(" ", matrix)).append(")");
        }
        return out.toString();
    }

    private static String getOutput(Color color) {
        if (color.getColorSpace().getType() == 9) {
            float[] cmyk = color.getComponents(null);
            return String.format(null, "rgb(%d,%d,%d) icc-color(Generic-CMYK-profile,%f,%f,%f,%f)", color.getRed(), color.getGreen(), color.getBlue(), Float.valueOf(cmyk[0]), Float.valueOf(cmyk[1]), Float.valueOf(cmyk[2]), Float.valueOf(cmyk[3]));
        }
        return String.format(null, "rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    private static String getOutput(Shape shape) {
        StringBuilder out = new StringBuilder();
        PathIterator segments = shape.getPathIterator(null);
        double[] coords = new double[6];
        int i = 0;
        while (!segments.isDone()) {
            if (i > 0) {
                out.append(" ");
            }
            int segmentType = segments.currentSegment(coords);
            switch (segmentType) {
                case 0: {
                    out.append("M").append(DataUtils.format(coords[0])).append(",").append(DataUtils.format(coords[1]));
                    break;
                }
                case 1: {
                    out.append("L").append(coords[0]).append(",").append(DataUtils.format(coords[1]));
                    break;
                }
                case 3: {
                    out.append("C").append(DataUtils.format(coords[0])).append(",").append(DataUtils.format(coords[1])).append(" ").append(DataUtils.format(coords[2])).append(",").append(DataUtils.format(coords[3])).append(" ").append(DataUtils.format(coords[4])).append(",").append(DataUtils.format(coords[5]));
                    break;
                }
                case 2: {
                    out.append("Q").append(DataUtils.format(coords[0])).append(",").append(DataUtils.format(coords[1])).append(" ").append(DataUtils.format(coords[2])).append(",").append(DataUtils.format(coords[3]));
                    break;
                }
                case 4: {
                    out.append("Z");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++i;
            segments.next();
        }
        return out.toString();
    }

    private static String getOutput(Font font) {
        StringBuilder out = new StringBuilder();
        if (!GraphicsState.DEFAULT_FONT.getFamily().equals(font.getFamily())) {
            String physicalFamily = GraphicsUtils.getPhysicalFont(font).getFamily();
            out.append("font-family:\"").append(physicalFamily).append("\";");
        }
        if (font.getSize2D() != GraphicsState.DEFAULT_FONT.getSize2D()) {
            out.append("font-size:").append(DataUtils.format(Float.valueOf(font.getSize2D()))).append("px;");
        }
        if ((font.getStyle() & 2) != 0) {
            out.append("font-style:italic;");
        }
        if ((font.getStyle() & 1) != 0) {
            out.append("font-weight:bold;");
        }
        return out.toString();
    }

    private static String getOutput(Image image, boolean lossyAllowed) {
        String encodedLossy;
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(image);
        String encoded = SVGDocument.encodeImage(bufferedImage, "png");
        if (!GraphicsUtils.usesAlpha(bufferedImage) && lossyAllowed && (encodedLossy = SVGDocument.encodeImage(bufferedImage, "jpeg")).length() > 0 && encodedLossy.length() < encoded.length()) {
            encoded = encodedLossy;
        }
        return encoded;
    }

    private static String encodeImage(BufferedImage bufferedImage, String format) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        Base64EncodeStream encodeStream = new Base64EncodeStream(byteStream);
        try {
            ImageIO.write((RenderedImage)bufferedImage, format, encodeStream);
            encodeStream.close();
            String encoded = byteStream.toString("ISO-8859-1");
            return String.format("data:image/%s;base64,%s", format, encoded);
        }
        catch (IOException e) {
            return "";
        }
    }

    private Element getElement(Shape shape) {
        Element elem;
        if (shape instanceof Line2D) {
            Line2D s = (Line2D)shape;
            elem = this.doc.createElement("line");
            elem.setAttribute("x1", DataUtils.format(s.getX1()));
            elem.setAttribute("y1", DataUtils.format(s.getY1()));
            elem.setAttribute("x2", DataUtils.format(s.getX2()));
            elem.setAttribute("y2", DataUtils.format(s.getY2()));
        } else if (shape instanceof Rectangle2D) {
            Rectangle2D s = (Rectangle2D)shape;
            elem = this.doc.createElement("rect");
            elem.setAttribute("x", DataUtils.format(s.getX()));
            elem.setAttribute("y", DataUtils.format(s.getY()));
            elem.setAttribute("width", DataUtils.format(s.getWidth()));
            elem.setAttribute("height", DataUtils.format(s.getHeight()));
        } else if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D s = (RoundRectangle2D)shape;
            elem = this.doc.createElement("rect");
            elem.setAttribute("x", DataUtils.format(s.getX()));
            elem.setAttribute("y", DataUtils.format(s.getY()));
            elem.setAttribute("width", DataUtils.format(s.getWidth()));
            elem.setAttribute("height", DataUtils.format(s.getHeight()));
            elem.setAttribute("rx", DataUtils.format(s.getArcWidth() / 2.0));
            elem.setAttribute("ry", DataUtils.format(s.getArcHeight() / 2.0));
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D s = (Ellipse2D)shape;
            elem = this.doc.createElement("ellipse");
            elem.setAttribute("cx", DataUtils.format(s.getCenterX()));
            elem.setAttribute("cy", DataUtils.format(s.getCenterY()));
            elem.setAttribute("rx", DataUtils.format(s.getWidth() / 2.0));
            elem.setAttribute("ry", DataUtils.format(s.getHeight() / 2.0));
        } else {
            elem = this.doc.createElement("path");
            elem.setAttribute("d", SVGDocument.getOutput(shape));
        }
        return elem;
    }

    private Element getElement(String text, double x, double y) {
        Element elem = this.doc.createElement("text");
        elem.appendChild(this.doc.createTextNode(text));
        elem.setAttribute("x", DataUtils.format(x));
        elem.setAttribute("y", DataUtils.format(y));
        return elem;
    }

    private Element getElement(Image image, double x, double y, double width, double height) {
        Element elem = this.doc.createElement("image");
        elem.setAttribute("x", DataUtils.format(x));
        elem.setAttribute("y", DataUtils.format(y));
        elem.setAttribute("width", DataUtils.format(width));
        elem.setAttribute("height", DataUtils.format(height));
        elem.setAttribute("preserveAspectRatio", "none");
        boolean lossyAllowed = this.getCurrentState().getHints().get(VectorHints.KEY_EXPORT) == VectorHints.VALUE_EXPORT_SIZE;
        elem.setAttribute("xlink:href", SVGDocument.getOutput(image, lossyAllowed));
        return elem;
    }
}

