/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.db.evolution.phased;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.emf.cdo.server.CDOServerExporter;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.db.evolution.phased.BasicPhaseHandler;
import org.eclipse.emf.cdo.server.db.evolution.phased.Context;
import org.eclipse.emf.cdo.server.db.evolution.phased.PhasedModelEvolutionSupport;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.io.IOUtil;

public class DefaultRepositoryExporter
extends BasicPhaseHandler {
    public static final String FACTORY_TYPE = "default-repository-exporter";
    private boolean binary;

    public DefaultRepositoryExporter() {
        this(false);
    }

    public DefaultRepositoryExporter(boolean binary) {
        this.setBinary(binary);
    }

    public boolean isBinary() {
        return this.binary;
    }

    @AnnotationFactory.InjectAttribute(name="binary")
    public void setBinary(boolean binary) {
        this.checkInactive();
        this.binary = binary;
    }

    @Override
    public void execute(Context context) throws Exception {
        String fileName;
        CDOServerExporter.Binary exporter;
        PhasedModelEvolutionSupport support = context.getSupport();
        IRepository repository = support.getStore().getRepository();
        if (this.binary) {
            exporter = new CDOServerExporter.Binary(repository);
            fileName = "export.bin";
        } else {
            exporter = new CDOServerExporter.XML(repository);
            fileName = "export.xml";
        }
        File evolutionFolder = support.getEvolutionFolder();
        File exportFile = new File(evolutionFolder, fileName);
        context.log("Exporting repository to " + exportFile.getAbsolutePath());
        Throwable throwable = null;
        Object var9_10 = null;
        try (BufferedOutputStream out = IOUtil.buffered((OutputStream)new FileOutputStream(exportFile));){
            exporter.exportRepository((OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

