/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationMigrationDelegate;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class JUnitMigrationDelegate
implements ILaunchConfigurationMigrationDelegate {
    protected static final String EMPTY_STRING = "";

    public boolean isCandidate(ILaunchConfiguration candidate) throws CoreException {
        IResource[] mapped = candidate.getMappedResources();
        IResource target = JUnitMigrationDelegate.getResource(candidate);
        if (target == null) {
            return mapped == null;
        }
        if (mapped == null || mapped.length != 1) {
            return true;
        }
        return !target.equals((Object)mapped[0]);
    }

    public void migrate(ILaunchConfiguration candidate) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = candidate.getWorkingCopy();
        JUnitMigrationDelegate.mapResources(wc);
        wc.doSave();
    }

    public static void mapResources(ILaunchConfigurationWorkingCopy config) throws CoreException {
        IResource resource = JUnitMigrationDelegate.getResource((ILaunchConfiguration)config);
        if (resource == null) {
            config.setMappedResources(null);
        } else {
            config.setMappedResources(new IResource[]{resource});
        }
    }

    private static IResource getResource(ILaunchConfiguration config) throws CoreException {
        String projName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        String containerHandle = config.getAttribute("org.eclipse.jdt.junit.CONTAINER", null);
        String typeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
        IJavaElement element = null;
        if (containerHandle != null && containerHandle.length() > 0) {
            element = JavaCore.create((String)containerHandle);
        } else if (projName != null && Path.ROOT.isValidSegment(projName)) {
            IJavaProject javaProject = JUnitMigrationDelegate.getJavaModel().getJavaProject(projName);
            if (javaProject.exists()) {
                if (typeName != null && typeName.length() > 0) {
                    element = javaProject.findType(typeName);
                }
                if (element == null) {
                    element = javaProject;
                }
            } else {
                IProject project = javaProject.getProject();
                if (project.exists() && !project.isOpen()) {
                    return project;
                }
            }
        }
        IResource resource = null;
        if (element != null) {
            resource = element.getResource();
        }
        return resource;
    }

    private static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }
}

