/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.osgi.util.NLS;

public class ConfigureFetchAfterCloneTask
implements CloneOperation.PostCloneTask {
    private String fetchRefSpec;
    private final String remoteName;

    public ConfigureFetchAfterCloneTask(String remoteName, String fetchRefSpec) {
        this.remoteName = remoteName;
        this.fetchRefSpec = fetchRefSpec;
    }

    @Override
    public void execute(Repository repository, IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(repository);){
                RemoteConfig configToUse = new RemoteConfig((Config)repository.getConfig(), this.remoteName);
                if (this.fetchRefSpec != null) {
                    configToUse.addFetchRefSpec(new RefSpec(this.fetchRefSpec));
                }
                configToUse.update((Config)repository.getConfig());
                repository.getConfig().save();
                git.fetch().setRemote(this.remoteName).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.logError(NLS.bind((String)CoreText.ConfigureFetchAfterCloneTask_couldNotFetch, (Object)this.fetchRefSpec), e);
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }
}

