/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICModelStatusConstants;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class CModelStatus
extends Status
implements ICModelStatus,
ICModelStatusConstants {
    protected ICElement[] fElements;
    protected static final ICElement[] EmptyElement = new ICElement[0];
    protected IPath fPath;
    protected String fString;
    protected static final String EMPTY_STRING = "";
    protected static final IStatus[] fgEmptyChildren = new IStatus[0];
    protected IStatus[] fChildren = fgEmptyChildren;
    protected static final String DEFAULT_STRING = "CModelStatus";
    public static final ICModelStatus VERIFIED_OK = new CModelStatus(0, 0, CoreModelMessages.getString("status.OK"));

    public CModelStatus() {
        this(0);
    }

    public CModelStatus(int code) {
        this(code, CElement.NO_ELEMENTS);
    }

    public CModelStatus(int code, ICElement[] elements) {
        super(4, "org.eclipse.cdt.core", code, DEFAULT_STRING, null);
        this.fElements = elements;
        this.fPath = Path.EMPTY;
    }

    public CModelStatus(int code, String string) {
        this(4, code, string);
    }

    public CModelStatus(int severity, int code, String string) {
        super(severity, "org.eclipse.cdt.core", code, DEFAULT_STRING, null);
        this.fElements = CElement.NO_ELEMENTS;
        this.fPath = Path.EMPTY;
        this.fString = string;
    }

    public CModelStatus(int code, IPath path) {
        super(4, "org.eclipse.cdt.core", code, DEFAULT_STRING, null);
        this.fElements = CElement.NO_ELEMENTS;
        this.fPath = path;
    }

    public CModelStatus(int code, ICElement element) {
        this(code, new ICElement[]{element});
    }

    public CModelStatus(int code, ICElement element, String string) {
        this(code, new ICElement[]{element});
        this.fString = string;
    }

    public CModelStatus(int code, ICElement element, IPath path) {
        this(code, new ICElement[]{element});
        this.fPath = path;
    }

    public CModelStatus(CoreException coreException) {
        this(966, coreException);
    }

    public CModelStatus(int code, Throwable throwable) {
        super(4, "org.eclipse.cdt.core", code, DEFAULT_STRING, throwable);
        this.fElements = CElement.NO_ELEMENTS;
        this.fPath = Path.EMPTY;
    }

    protected int getBits() {
        int severity = 1 << this.getCode() % 100 / 33;
        int category = 1 << this.getCode() / 100 + 3;
        return severity | category;
    }

    public IStatus[] getChildren() {
        return this.fChildren;
    }

    @Override
    public ICElement[] getElements() {
        return this.fElements;
    }

    public String getMessage() {
        Throwable exception = this.getException();
        if (this.isMultiStatus()) {
            StringBuilder sb = new StringBuilder();
            IStatus[] children = this.getChildren();
            if (children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    sb.append(children[i].getMessage()).append(',');
                    ++i;
                }
            }
            return sb.toString();
        }
        if (exception == null) {
            switch (this.getCode()) {
                case 966: {
                    return CoreModelMessages.getFormattedString("status.coreException");
                }
                case 973: {
                    return CoreModelMessages.getFormattedString("status.cannotUseDeviceOnPath", this.getPath().toString());
                }
                case 986: {
                    return CoreModelMessages.getFormattedString("status.ParserError");
                }
                case 969: {
                    return CoreModelMessages.getFormattedString("status.elementDoesNotExist", this.getFirstElementName());
                }
                case 992: {
                    return CoreModelMessages.getFormattedString("status.evaluationError", this.getString());
                }
                case 980: {
                    return CoreModelMessages.getFormattedString("status.indexOutOfBounds");
                }
                case 984: {
                    return CoreModelMessages.getFormattedString("status.invalidContents");
                }
                case 978: {
                    return CoreModelMessages.getFormattedString("status.invalidDestination", this.getFirstElementName());
                }
                case 967: {
                    StringBuilder buff = new StringBuilder(CoreModelMessages.getFormattedString("operation.notSupported"));
                    int i = 0;
                    while (i < this.fElements.length) {
                        if (i > 0) {
                            buff.append(", ");
                        }
                        buff.append(this.fElements[i].toString());
                        ++i;
                    }
                    return buff.toString();
                }
                case 983: {
                    return CoreModelMessages.getFormattedString("status.invalidName", this.getString());
                }
                case 979: {
                    String path = this.getPath() == null ? "null" : this.getPath().toString();
                    return CoreModelMessages.getFormattedString("status.invalidPath", new Object[]{path, this.getString()});
                }
                case 964: {
                    return CoreModelMessages.getFormattedString("status.invalidPathEntry", this.getString());
                }
                case 997: {
                    return CoreModelMessages.getFormattedString("status.invalidProject", this.getString());
                }
                case 995: {
                    return CoreModelMessages.getFormattedString("status.invalidResource", this.getString());
                }
                case 996: {
                    return CoreModelMessages.getFormattedString("status.invalidResourceType", this.getString());
                }
                case 993: {
                    if (this.fString != null) {
                        return CoreModelMessages.getFormattedString("status.invalidSibling", this.getString());
                    }
                    return CoreModelMessages.getFormattedString("status.invalidSibling", this.getFirstElementName());
                }
                case 985: {
                    return CoreModelMessages.getFormattedString("status.IOException");
                }
                case 977: {
                    StringBuilder sb = new StringBuilder();
                    if (this.fElements != null && this.fElements.length > 0) {
                        ICElement element = this.fElements[0];
                        sb.append(element.getElementName()).append(' ');
                    }
                    if (this.fString != null) {
                        return this.fString;
                    }
                    return CoreModelMessages.getFormattedString("status.nameCollision", sb.toString());
                }
                case 968: {
                    return CoreModelMessages.getFormattedString("operation.needElements");
                }
                case 982: {
                    return CoreModelMessages.getFormattedString("operation.needName");
                }
                case 970: {
                    return CoreModelMessages.getFormattedString("operation.needPath");
                }
                case 974: {
                    return CoreModelMessages.getFormattedString("operation.needString");
                }
                case 971: {
                    return CoreModelMessages.getFormattedString("operation.pathOutsideProject", new String[]{this.getString(), this.getFirstElementName()});
                }
                case 976: {
                    return CoreModelMessages.getFormattedString("status.readOnly", this.getFirstElementName());
                }
                case 972: {
                    return CoreModelMessages.getFormattedString("operation.needAbsolutePath", this.getPath().toString());
                }
                case 981: {
                    return CoreModelMessages.getFormattedString("status.updateConflict");
                }
                case 999: {
                    return CoreModelMessages.getFormattedString("status.noLocalContents", this.getPath().toString());
                }
            }
            return this.getString();
        }
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.toString();
    }

    @Override
    public IPath getPath() {
        if (this.fPath == null) {
            return Path.EMPTY;
        }
        return this.fPath;
    }

    public int getSeverity() {
        if (this.fChildren == fgEmptyChildren) {
            return super.getSeverity();
        }
        int severity = -1;
        IStatus[] iStatusArray = this.fChildren;
        int n = this.fChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            int childrenSeverity = element.getSeverity();
            if (childrenSeverity > severity) {
                severity = childrenSeverity;
            }
            ++n2;
        }
        return severity;
    }

    @Override
    public String getString() {
        if (this.fString == null) {
            return EMPTY_STRING;
        }
        return this.fString;
    }

    public String getFirstElementName() {
        if (this.fElements != null && this.fElements.length > 0) {
            return this.fElements[0].getElementName();
        }
        return EMPTY_STRING;
    }

    @Override
    public boolean doesNotExist() {
        return this.getCode() == 969;
    }

    public boolean isMultiStatus() {
        return this.fChildren != fgEmptyChildren;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int mask) {
        if (!this.isMultiStatus()) {
            return this.matches(this, mask);
        }
        IStatus[] iStatusArray = this.fChildren;
        int n = this.fChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            if (this.matches((CModelStatus)element, mask)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean matches(CModelStatus status, int mask) {
        int severityMask = mask & 7;
        int categoryMask = mask & 0xFFFFFFF8;
        int bits = status.getBits();
        return !(severityMask != 0 && (bits & severityMask) == 0 || categoryMask != 0 && (bits & categoryMask) == 0);
    }

    public static ICModelStatus newMultiStatus(ICModelStatus[] children) {
        CModelStatus jms = new CModelStatus();
        jms.fChildren = children;
        return jms;
    }

    public static ICModelStatus newMultiStatus(int code, ICModelStatus[] children) {
        CModelStatus jms = new CModelStatus(code);
        jms.fChildren = children;
        return jms;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "CModelStatus[OK]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("C Model Status [");
        buffer.append(this.getMessage());
        buffer.append("]");
        return buffer.toString();
    }
}

