/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.io.File;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.dialogs.AbstractDiscoveryPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class MBSPerProjectSCDProfilePage
extends AbstractDiscoveryPage {
    private static final String providerId = "specsFile";
    private Button sipEnabledButton;
    private Text sipRunCommandText;
    private boolean isValid = true;

    public void createControl(Composite parent) {
        Composite page = ControlFactory.createComposite((Composite)parent, (int)1);
        Group profileGroup = ControlFactory.createGroup((Composite)page, (String)MakeUIPlugin.getResourceString("ScannerConfigOptionsDialog.profile.group.label"), (int)3);
        GridData gd = (GridData)profileGroup.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        ((GridLayout)profileGroup.getLayout()).makeColumnsEqualWidth = false;
        this.sipEnabledButton = ControlFactory.createCheckBox((Composite)profileGroup, (String)SI_ENABLE);
        ((GridData)this.sipEnabledButton.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.sipEnabledButton.getLayoutData()).grabExcessHorizontalSpace = true;
        this.sipEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Label siCommandLabel = ControlFactory.createLabel((Composite)profileGroup, (String)SI_COMMAND);
        ((GridData)siCommandLabel.getLayoutData()).horizontalSpan = 3;
        this.sipRunCommandText = ControlFactory.createTextField((Composite)profileGroup, (int)2052);
        this.sipRunCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MBSPerProjectSCDProfilePage.this.handleModifyRunCommandText();
            }
        });
        Button siBrowseButton = ControlFactory.createPushButton((Composite)profileGroup, (String)SI_BROWSE);
        ((GridData)siBrowseButton.getLayoutData()).minimumWidth = 120;
        siBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.handleSIPBrowseButtonSelected();
            }

            private void handleSIPBrowseButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(MBSPerProjectSCDProfilePage.this.getShell(), 0);
                dialog.setText(SI_DIALOG);
                String fileName = MBSPerProjectSCDProfilePage.this.sipRunCommandText.getText().trim();
                int lastSeparatorIndex = fileName.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(fileName.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                MBSPerProjectSCDProfilePage.this.sipRunCommandText.setText(res);
            }
        });
        this.setControl((Control)page);
        this.initializeValues();
    }

    private void handleModifyRunCommandText() {
        String cmd = this.sipRunCommandText.getText().trim();
        this.isValid = cmd.length() > 0;
        this.getContainer().updateContainer();
    }

    private void initializeValues() {
        this.sipEnabledButton.setSelection(this.getContainer().getBuildInfo().isProviderOutputParserEnabled(providerId));
        this.sipRunCommandText.setText(this.getContainer().getBuildInfo().getProviderRunCommand(providerId));
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public String getErrorMessage() {
        return this.isValid ? null : SI_ERROR;
    }

    @Override
    protected void populateBuildInfo(IScannerConfigBuilderInfo2 buildInfo) {
        if (buildInfo != null) {
            buildInfo.setBuildOutputFileActionEnabled(true);
            buildInfo.setProviderOutputParserEnabled(providerId, this.sipEnabledButton.getSelection());
            buildInfo.setProviderRunCommand(providerId, this.sipRunCommandText.getText().trim());
        }
    }

    @Override
    protected void restoreFromBuildinfo(IScannerConfigBuilderInfo2 buildInfo) {
        if (buildInfo != null) {
            this.sipEnabledButton.setSelection(buildInfo.isProviderOutputParserEnabled(providerId));
            this.sipRunCommandText.setText(buildInfo.getProviderRunCommand(providerId));
        }
    }
}

