/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions;

import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.JumpToAddressAction;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class AddressBarContributionItem
extends ContributionItem {
    private Combo addressBox;
    private IAction action;
    private ToolItem item;
    private int width;
    private String initialText;
    private String lastText;
    private Image warningImage = null;
    private Label warningLabel = null;
    private String warningText = null;

    public AddressBarContributionItem(IAction action) {
        this.action = action;
    }

    public void createAddressBox(ToolBar parent, int width, String initialText, String warningText) {
        this.width = width;
        this.initialText = initialText;
        this.lastText = initialText;
        this.warningText = warningText;
        this.fill(parent, 0);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AddressBarContributionItem.this.warningImage != null) {
                    AddressBarContributionItem.this.warningImage.dispose();
                }
            }
        });
    }

    public void fill(ToolBar parent, int index) {
        this.item = new ToolItem(parent, 2);
        Control box = this.internalCreateAddressBox((Composite)parent);
        this.item.setControl(box);
        this.item.setWidth(this.width);
        this.enableAddressBox(this.action.isEnabled());
    }

    public void setText(String text) {
        if (this.addressBox != null) {
            this.addressBox.setText(text);
        }
    }

    public String getText() {
        if (this.addressBox != null) {
            return this.addressBox.getText();
        }
        return this.initialText;
    }

    public void setWarningIconVisible(boolean visible) {
        if (this.warningLabel == null) {
            return;
        }
        this.warningLabel.setVisible(visible);
    }

    public boolean isWarningIconVisible() {
        if (this.warningLabel == null) {
            return false;
        }
        return this.warningLabel.isVisible();
    }

    public void enableAddressBox(boolean enable) {
        if (this.addressBox != null && !this.item.isDisposed()) {
            this.item.setEnabled(enable);
            this.addressBox.setEnabled(enable);
        }
    }

    private Control internalCreateAddressBox(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 2;
        layout.numColumns = 3;
        top.setLayout((Layout)layout);
        this.warningLabel = new Label(top, 0);
        this.warningImage = ((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.cdt.dsf.ui", (String)"icons/address_warning.gif").get()).createImage();
        this.warningLabel.setImage(this.warningImage);
        this.warningLabel.setToolTipText(this.warningText);
        this.setWarningIconVisible(false);
        this.addressBox = new Combo(top, 4);
        this.addressBox.setText(this.initialText);
        this.action.setText(this.initialText);
        this.addressBox.addFocusListener(new FocusListener(){
            KeyListener keyListener = new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    if (e.stateMask == 262144 && ((char)e.keyCode == 'c' || (char)e.keyCode == 'C')) {
                        String selection = null;
                        Point selectionPoint = (this).AddressBarContributionItem.this.addressBox.getSelection();
                        if (selectionPoint.x == selectionPoint.y) {
                            return;
                        }
                        selection = (this).AddressBarContributionItem.this.addressBox.getText().substring(selectionPoint.x, selectionPoint.y);
                        if (selection != null && selection.trim().length() != 0) {
                            Clipboard clipboard = null;
                            try {
                                clipboard = new Clipboard((this).AddressBarContributionItem.this.addressBox.getDisplay());
                                clipboard.setContents(new Object[]{selection}, new Transfer[]{TextTransfer.getInstance()});
                            }
                            finally {
                                if (clipboard != null) {
                                    clipboard.dispose();
                                }
                            }
                        }
                    }
                }
            };

            public void focusGained(FocusEvent e) {
                if (AddressBarContributionItem.this.action instanceof JumpToAddressAction) {
                    ((JumpToAddressAction)AddressBarContributionItem.this.action).deactivateDisassemblyContext();
                }
                AddressBarContributionItem.this.lastText = AddressBarContributionItem.this.addressBox.getText();
                if (AddressBarContributionItem.this.lastText.trim().equals(AddressBarContributionItem.this.initialText)) {
                    AddressBarContributionItem.this.addressBox.setText("");
                }
                AddressBarContributionItem.this.addressBox.addKeyListener(this.keyListener);
            }

            public void focusLost(FocusEvent e) {
                if (AddressBarContributionItem.this.action instanceof JumpToAddressAction) {
                    ((JumpToAddressAction)AddressBarContributionItem.this.action).activateDisassemblyContext();
                }
                if (AddressBarContributionItem.this.addressBox.getText().trim().length() == 0) {
                    AddressBarContributionItem.this.addressBox.setText(AddressBarContributionItem.this.lastText);
                }
                AddressBarContributionItem.this.addressBox.removeKeyListener(this.keyListener);
            }
        });
        this.addressBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    String addressBoxStr = AddressBarContributionItem.this.addressBox.getText();
                    if (addressBoxStr.equals(AddressBarContributionItem.this.initialText)) {
                        return;
                    }
                    Event event = new Event();
                    event.data = addressBoxStr;
                    AddressBarContributionItem.this.action.runWithEvent(event);
                    boolean bExist = false;
                    int i = 0;
                    while (i < AddressBarContributionItem.this.addressBox.getItemCount()) {
                        String itemText = AddressBarContributionItem.this.addressBox.getItem(i);
                        if (itemText.equals(addressBoxStr)) {
                            bExist = true;
                            break;
                        }
                        ++i;
                    }
                    if (!bExist && AddressBarContributionItem.this.addressBox.getText() != null && AddressBarContributionItem.this.addressBox.getText().trim().length() != 0) {
                        AddressBarContributionItem.this.addressBox.add(AddressBarContributionItem.this.addressBox.getText());
                    }
                }
            }
        });
        this.addressBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int selection = AddressBarContributionItem.this.addressBox.getSelectionIndex();
                if (selection >= 0) {
                    String addressBoxStr = AddressBarContributionItem.this.addressBox.getItem(selection);
                    Event event = new Event();
                    event.data = addressBoxStr;
                    AddressBarContributionItem.this.action.runWithEvent(event);
                }
            }
        });
        this.addressBox.setLayoutData((Object)new GridData(4, 1, true, false));
        return top;
    }

    public void clearSelection() {
        this.addressBox.clearSelection();
    }
}

