/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyPathCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String path;
        RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
        switch (node.getType()) {
            case REPO: {
                path = node.getRepository().getDirectory().toString();
                break;
            }
            case WORKINGDIR: {
                if (node.getRepository().isBare()) {
                    return null;
                }
                path = node.getRepository().getWorkTree().toString();
                break;
            }
            case FILE: {
                path = ((File)((FileNode)node).getObject()).getPath().toString();
                break;
            }
            case FOLDER: {
                path = ((File)((FolderNode)node).getObject()).getPath().toString();
                break;
            }
            default: {
                return null;
            }
        }
        Clipboard clipboard = new Clipboard(null);
        try {
            TextTransfer textTransfer = TextTransfer.getInstance();
            Transfer[] transfers = new Transfer[]{textTransfer};
            Object[] data = new Object[]{path};
            clipboard.setContents(data, transfers);
        }
        finally {
            clipboard.dispose();
        }
        return null;
    }
}

