/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.info.GitItemState;
import org.eclipse.egit.core.internal.info.GitItemStateFactory;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;

public class AdapterFactory
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == Repository.class) {
            if (adaptableObject instanceof GitFileRevision) {
                return adapterType.cast(((GitFileRevision)adaptableObject).getRepository());
            }
        } else if (adapterType == GitInfo.class && adaptableObject instanceof IResource && ((IResource)adaptableObject).getType() != 8) {
            return adapterType.cast(new GitAccessor((IResource)adaptableObject));
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{Repository.class, GitInfo.class};
    }

    private static class GitAccessor
    implements GitInfo {
        @NonNull
        private final IResource resource;

        GitAccessor(@NonNull IResource resource) {
            this.resource = resource;
        }

        @Override
        public Repository getRepository() {
            RepositoryMapping mapping = RepositoryMapping.getMapping(this.resource);
            return mapping != null ? mapping.getRepository() : null;
        }

        @Override
        public String getGitPath() {
            RepositoryMapping mapping = RepositoryMapping.getMapping(this.resource);
            return mapping != null ? mapping.getRepoRelativePath(this.resource) : null;
        }

        @Override
        public GitInfo.Source getSource() {
            RepositoryMapping mapping = RepositoryMapping.getMapping(this.resource);
            return mapping == null ? null : GitInfo.Source.WORKING_TREE;
        }

        @Override
        public AnyObjectId getCommitId() {
            return null;
        }

        @Override
        public GitItemState getGitState() {
            return GitItemStateFactory.getInstance().get(this.resource);
        }
    }
}

