/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.util;

import java.util.LinkedList;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class CDOBalancedTree {
    public static final int DEFAULT_CAPACITY = 20;
    public static final int DEFAULT_LOCK_TIMEOUT = 1000;
    private static final boolean TRACE = false;
    private final CDOResourceFolder root;
    private final int folderCapacity;
    private final int resourceCapacity;
    private int lockAttempts;
    private long lockTimeout = 1000L;

    public CDOBalancedTree(CDOResourceFolder root, int folderCapacity, int resourceCapacity) {
        this.root = root;
        this.folderCapacity = folderCapacity;
        this.resourceCapacity = resourceCapacity;
    }

    public CDOBalancedTree(CDOResourceFolder root, int nodeCapacity) {
        this(root, nodeCapacity, nodeCapacity);
    }

    public CDOBalancedTree(CDOResourceFolder root) {
        this(root, 20);
    }

    public final CDOResourceFolder getRoot() {
        return this.root;
    }

    public final int getFolderCapacity() {
        return this.folderCapacity;
    }

    public final int getResourceCapacity() {
        return this.resourceCapacity;
    }

    public final int getLockAttempts() {
        return this.lockAttempts;
    }

    public final void setLockAttempts(int lockAttempts) {
        this.lockAttempts = lockAttempts;
    }

    public final long getLockTimeout() {
        return this.lockTimeout;
    }

    public final void setLockTimeout(long lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public void addObject(EObject object) {
        if (this.lockAttempts == 0) {
            this.addObjectToRoot(object);
            return;
        }
        int attempts = this.lockAttempts;
        while (attempts-- != 0) {
            try {
                this.root.cdoWriteLock().lock(this.lockTimeout);
                this.addObjectToRoot(object);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new CDOException("Unable to aquire write lock on balanced tree " + this.root.getPath());
    }

    private void addObjectToRoot(EObject object) {
        CDOResource firstResource = null;
        LinkedList<CDOResourceFolder> folders = new LinkedList<CDOResourceFolder>();
        CDOResourceFolder folder = this.root;
        while (folder != null) {
            EList<CDOResourceNode> nodes = folder.getNodes();
            for (CDOResourceNode node : nodes) {
                if (node instanceof CDOResourceFolder) {
                    folders.offer((CDOResourceFolder)node);
                    continue;
                }
                if (!(node instanceof CDOResource)) continue;
                if (firstResource == null) {
                    firstResource = (CDOResource)node;
                }
                if (!this.addObjectToResource(object, (CDOResource)node)) continue;
                return;
            }
            int size = nodes.size();
            if (size < this.folderCapacity) {
                String name = this.getResourceName(size + 1);
                CDOResource resource = folder.addResource(name);
                this.addObjectToResource(object, resource);
                return;
            }
            folder = (CDOResourceFolder)folders.poll();
        }
        CDOResource resource = this.addObjectWithSplit(firstResource);
        this.addObjectToResource(object, resource);
    }

    private boolean addObjectToResource(EObject object, CDOResource resource) {
        EList<EObject> contents = resource.getContents();
        if (contents.size() < this.resourceCapacity) {
            contents.add((Object)object);
            return true;
        }
        return false;
    }

    private CDOResource addObjectWithSplit(CDOResource resource) {
        String path = resource.getPath();
        String name = resource.getName();
        resource.setName("_" + name);
        CDOResourceFolder splitFolder = resource.getFolder().addResourceFolder(name);
        splitFolder.getNodes().add((Object)resource);
        resource.setName(this.getResourceName(1));
        return splitFolder.addResource(this.getResourceName(2));
    }

    private String getResourceName(int n) {
        return Integer.toString(n);
    }
}

