/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.ui.views.IntrospectionProvider;
import org.eclipse.swt.graphics.Color;

public abstract class RowIntrospectionProvider
extends IntrospectionProvider {
    public static final int DEFAULT_CATEGORY = 0;

    protected RowIntrospectionProvider(String id, String label) {
        super(id, label);
    }

    @Override
    public final void createColumns(TableViewer viewer) {
        RowIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_4"), 200);
        RowIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_5"), 400);
        RowIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_6"), 300);
        RowIntrospectionProvider.createColumn(viewer, Messages.getString("Net4jIntrospectorView_7"), 300);
    }

    public final Row[] getElements(Object parent) throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        this.fillRows(parent, rows);
        return rows.toArray(new Row[rows.size()]);
    }

    protected abstract void fillRows(Object var1, List<Row> var2) throws Exception;

    @Override
    public abstract Row getElementByName(Object var1, String var2) throws Exception;

    @Override
    public final Row getNameAndValue(Object element) throws Exception {
        return (Row)element;
    }

    @Override
    public final String getColumnText(Object element, int index) throws Exception {
        return ((Row)element).getColumn(index);
    }

    @Override
    public final Color getForeground(Object element) {
        return ((Row)element).getForeground();
    }

    @Override
    public final Color getBackground(Object element) {
        return ((Row)element).getBackground();
    }

    @Override
    public final ViewerComparator getComparator() {
        return new ViewerComparator(){

            public int category(Object element) {
                return ((Row)element).getCategory();
            }
        };
    }

    public static final class Row
    extends IntrospectionProvider.NameAndValue {
        private final String declaredType;
        private final String concreteType;
        private final int category;
        private final Color foreground;
        private final Color background;

        public Row(String name, Object value, String declaredType, String concreteType, int category, Color foreground, Color background) {
            super(name, value);
            this.declaredType = declaredType;
            this.concreteType = concreteType;
            this.category = category;
            this.foreground = foreground;
            this.background = background;
        }

        public Row(String name, Object value, String declaredType, String concreteType) {
            this(name, value, declaredType, concreteType, 0, null, null);
        }

        public String getDeclaredType() {
            return this.declaredType;
        }

        public String getConcreteType() {
            return this.concreteType;
        }

        public int getCategory() {
            return this.category;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Color getBackground() {
            return this.background;
        }

        public String getColumn(int index) {
            switch (index) {
                case 0: {
                    return this.getName();
                }
                case 1: {
                    return RowIntrospectionProvider.formatValue(this.getValue());
                }
                case 2: {
                    return this.declaredType;
                }
                case 3: {
                    return this.concreteType;
                }
            }
            return null;
        }
    }
}

