/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.AbstractConfigurationUI;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ui.IConfigurationUIFactory;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.DataHolder;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.impl.ItemDescriptorLabelProvider;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public final class InteractiveUIContent {
    private static final int WIDTH_HINT_CONFIG_COMPOSITE = 400;
    private static final int DESCRIPTION_COMPOSITE_HEIGHT_HINT = 50;
    private static final int DESCRIPTION_COMPOSITE_WIDTH_HINT = 400;
    private final Label descriptionText;
    private final Composite viewerCompsite;
    private final Composite configurationComposite;
    private final Composite defaultComposite;
    private CheckboxTableViewer viewer;
    private final Map<String, AbstractConfigurationUI> configurators = new HashMap<String, AbstractConfigurationUI>();

    private InteractiveUIContent(Composite parent, boolean hasDescription, boolean hasConfiguration) {
        Composite contentComposite = new Composite(parent, 0);
        int numberOfColumns = hasConfiguration ? 2 : 1;
        GridLayoutFactory.fillDefaults().numColumns(numberOfColumns).applyTo(contentComposite);
        contentComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewerCompsite = new Composite(contentComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.viewerCompsite);
        this.viewerCompsite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        if (hasConfiguration) {
            this.configurationComposite = this.createConfigComposite(contentComposite);
            this.defaultComposite = new Composite(this.configurationComposite, 0);
            this.defaultComposite.setLayout((Layout)new GridLayout(1, true));
            Label text = new Label(this.defaultComposite, 64);
            text.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
            text.setText(EMFCompareRCPUIMessages.getString("InteractiveUIContent.defaultConfiguration.label"));
        } else {
            this.configurationComposite = null;
            this.defaultComposite = null;
        }
        this.descriptionText = hasDescription ? this.createDescriptionComposite(parent) : null;
    }

    public void addConfigurator(String id, IConfigurationUIFactory configuratorfactory, IPreferenceStore store) {
        AbstractConfigurationUI configurator = configuratorfactory.createUI(this.configurationComposite, 0, store);
        this.configurators.put(id, configurator);
    }

    public void checkElement(IItemDescriptor<?> descriptor) {
        this.viewer.setCheckedElements(new Object[]{descriptor});
    }

    public <T> void checkElements(Collection<IItemDescriptor<T>> descriptors) {
        this.viewer.setCheckedElements(descriptors.toArray());
    }

    public <T> void checkElements(IItemDescriptor<T>[] descriptors) {
        this.viewer.setCheckedElements((Object[])descriptors);
    }

    private Group createConfigComposite(Composite composite) {
        Group confComposite = new Group(composite, 0);
        confComposite.setText(EMFCompareRCPUIMessages.getString("InteractiveUIContent.configurationComposite.label"));
        StackLayout layout = new StackLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 5;
        confComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1, 4, false, true);
        layoutData.widthHint = 400;
        confComposite.setLayoutData((Object)layoutData);
        return confComposite;
    }

    private Label createDescriptionComposite(Composite composite) {
        Group descriptionComposite = new Group(composite, 0);
        descriptionComposite.setText(EMFCompareRCPUIMessages.getString("InteractiveUIContent.descriptionComposite.label"));
        descriptionComposite.setLayout((Layout)new GridLayout(1, false));
        descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label engineDescriptionLabel = new Label((Composite)descriptionComposite, 64);
        GridData layoutData = new GridData(4, 4, true, false, 1, 1);
        layoutData.heightHint = 50;
        layoutData.widthHint = 400;
        engineDescriptionLabel.setLayoutData((Object)layoutData);
        return engineDescriptionLabel;
    }

    public Map<String, AbstractConfigurationUI> getConfigurators() {
        return ImmutableMap.copyOf(this.configurators);
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    private Composite getViewerComposite() {
        return this.viewerCompsite;
    }

    public <T> void select(IItemDescriptor<T> descriptor) {
        this.selectAll(Collections.singleton(descriptor));
    }

    public <T> void selectAll(Collection<IItemDescriptor<T>> descriptors) {
        this.viewer.setSelection((ISelection)new StructuredSelection(descriptors), true);
        this.updateLinkedElements(descriptors.iterator().next());
    }

    public void setViewer(CheckboxTableViewer inputViewer) {
        this.viewer = inputViewer;
        if (this.configurationComposite != null) {
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)new ConfigurationListener());
        }
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new DescriptionListener());
    }

    private void updateLinkedElements(IItemDescriptor<?> descriptor) {
        this.descriptionText.setText(descriptor.getDescription());
        if (this.configurationComposite != null) {
            this.updateConfigurationComposite(descriptor);
        }
    }

    private void updateConfigurationComposite(IItemDescriptor<?> descriptor) {
        StackLayout stackLayout = (StackLayout)this.configurationComposite.getLayout();
        stackLayout.topControl = this.configurators.containsKey(descriptor.getID()) ? (Control)this.configurators.get(descriptor.getID()) : this.defaultComposite;
        this.configurationComposite.layout();
    }

    /* synthetic */ InteractiveUIContent(Composite composite, boolean bl, boolean bl2, InteractiveUIContent interactiveUIContent) {
        this(composite, bl, bl2);
    }

    private final class ConfigurationListener
    implements ISelectionChangedListener {
        private ConfigurationListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection structSelection;
            Object selected;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (selected = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IItemDescriptor) {
                InteractiveUIContent.this.updateLinkedElements((IItemDescriptor)selected);
            }
        }
    }

    private final class DescriptionListener
    implements ISelectionChangedListener {
        private DescriptionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection structSelection;
            Object selected;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (selected = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IItemDescriptor) {
                IItemDescriptor desc = (IItemDescriptor)selected;
                String description = desc.getDescription();
                InteractiveUIContent.this.descriptionText.setText(description);
            }
        }
    }

    public static class InteractiveUIBuilder<T> {
        private Composite parent;
        private IItemRegistry<T> registry;
        private String configurationNodeKey;
        private Map<String, IConfigurationUIFactory> configurationUIRegistry;
        private Set<IItemDescriptor<T>> defaultCheck;
        private IItemDescriptor<T> defaultSelection;
        private DataHolder<T> dataHolder;
        private boolean hasDescription = true;
        private boolean isSimple = false;

        public InteractiveUIBuilder(Composite parent, IItemRegistry<T> registry) {
            this.parent = parent;
            this.registry = registry;
        }

        public InteractiveUIBuilder<T> setHoldingData(DataHolder<T> newDataHolder) {
            this.dataHolder = newDataHolder;
            return this;
        }

        public InteractiveUIBuilder<T> setConfigurationNodeKey(String key) {
            this.configurationNodeKey = key;
            return this;
        }

        public InteractiveUIBuilder<T> setConfiguratorUIRegistry(Map<String, IConfigurationUIFactory> configuratorUIRegistry) {
            this.configurationUIRegistry = configuratorUIRegistry;
            return this;
        }

        public InteractiveUIBuilder<T> setDefaultCheck(Set<IItemDescriptor<T>> newDefaultCheck) {
            this.defaultCheck = newDefaultCheck;
            return this;
        }

        public InteractiveUIBuilder<T> setDefaultSelection(IItemDescriptor<T> newDefaultSelection) {
            this.defaultSelection = newDefaultSelection;
            return this;
        }

        public InteractiveUIBuilder<T> setHasDescription(boolean newHasDescription) {
            this.hasDescription = newHasDescription;
            return this;
        }

        public InteractiveUIBuilder<T> setSimple(boolean newIsSimple) {
            this.isSimple = newIsSimple;
            return this;
        }

        public InteractiveUIContent build() {
            Preconditions.checkArgument((!this.isSimple || this.defaultCheck == null || this.defaultCheck.size() == 1 ? 1 : 0) != 0);
            boolean hasConfiguration = this.configurationUIRegistry != null;
            Preconditions.checkArgument((!hasConfiguration || this.configurationNodeKey != null ? 1 : 0) != 0);
            InteractiveUIContent interactiveUI = new InteractiveUIContent(this.parent, this.hasDescription, hasConfiguration, null);
            CheckboxTableViewer descriptorViewer = this.createViewer(interactiveUI);
            if (hasConfiguration) {
                this.createConfigurationComposite(interactiveUI);
            }
            this.setViewerInput(descriptorViewer);
            this.bindAndInit(interactiveUI, descriptorViewer);
            return interactiveUI;
        }

        private CheckboxTableViewer createViewer(InteractiveUIContent interactiveUI) {
            int style = 68096;
            if (this.isSimple) {
                style |= 4;
            }
            CheckboxTableViewer descriptorViewer = CheckboxTableViewer.newCheckList((Composite)interactiveUI.getViewerComposite(), (int)style);
            interactiveUI.setViewer(descriptorViewer);
            descriptorViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            descriptorViewer.setLabelProvider((IBaseLabelProvider)new ItemDescriptorLabelProvider());
            GridData gd = new GridData(4, 4, true, true, 1, 1);
            descriptorViewer.getControl().setLayoutData((Object)gd);
            return descriptorViewer;
        }

        private void createConfigurationComposite(InteractiveUIContent interactiveUI) {
            for (IItemDescriptor item : this.registry.getItemDescriptors()) {
                String itemId = item.getID();
                IConfigurationUIFactory configuratorFactory = this.configurationUIRegistry.get(itemId);
                if (configuratorFactory == null) continue;
                ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.emf.compare.rcp");
                store.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE});
                interactiveUI.addConfigurator(itemId, configuratorFactory, (IPreferenceStore)store);
            }
        }

        private void bindAndInit(InteractiveUIContent interactiveUI, CheckboxTableViewer descriptorViewer) {
            if (this.defaultSelection != null) {
                interactiveUI.select(this.defaultSelection);
            }
            if (this.isSimple) {
                if (this.defaultCheck != null) {
                    IItemDescriptor<T> defaultCheckedElement = this.defaultCheck.iterator().next();
                    interactiveUI.checkElement(defaultCheckedElement);
                    if (this.dataHolder != null) {
                        this.dataHolder.setData(Collections.singleton(defaultCheckedElement));
                    }
                }
                descriptorViewer.addCheckStateListener(new SingleCheckListener(this.dataHolder, descriptorViewer, Display.getDefault().getActiveShell()));
            } else if (this.dataHolder != null) {
                if (this.defaultCheck != null) {
                    this.dataHolder.setData(this.defaultCheck);
                }
                this.bindMultipleData(interactiveUI.getViewer(), this.dataHolder);
            }
        }

        private void setViewerInput(CheckboxTableViewer descriptorViewer) {
            List itemDescriptors = this.registry.getItemDescriptors();
            Collections.sort(itemDescriptors);
            descriptorViewer.setInput((Object)itemDescriptors);
        }

        private void bindMultipleData(CheckboxTableViewer descriptorViewer, DataHolder<T> dataObject) {
            DataBindingContext ctx = new DataBindingContext();
            IViewerObservableSet target = ViewerProperties.checkedElements(IItemDescriptor.class).observe((Viewer)descriptorViewer);
            IObservableSet model = PojoProperties.set(DataHolder.class, (String)"data").observe(dataObject);
            ctx.bindSet((IObservableSet)target, model);
        }
    }

    private static final class SingleCheckListener<T>
    implements ICheckStateListener {
        private final DataHolder<T> dataObject;
        private final CheckboxTableViewer descriptorViewer;
        private final Shell shell;

        private SingleCheckListener(DataHolder<T> dataObject, CheckboxTableViewer descriptorViewer, Shell shell) {
            this.dataObject = dataObject;
            this.descriptorViewer = descriptorViewer;
            this.shell = shell;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (event.getChecked()) {
                if (element instanceof IItemDescriptor) {
                    IItemDescriptor descriptor = (IItemDescriptor)element;
                    this.dataObject.setData(Collections.singleton(descriptor));
                }
                this.descriptorViewer.setCheckedElements(new Object[]{element});
            } else if (this.descriptorViewer.getCheckedElements().length == 0) {
                this.descriptorViewer.setCheckedElements(new Object[]{element});
                MessageDialog.openWarning((Shell)this.shell, (String)EMFCompareRCPUIMessages.getString("InteractiveUIContent.incorrectSelection.title"), (String)EMFCompareRCPUIMessages.getString("InteractiveUIContent.incorrectSelection.message"));
            }
        }
    }
}

