/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.refresh;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.business.internal.helper.refresh.EdgeFilter;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.model.business.internal.operations.DDiagramSpecOperations;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public abstract class AbstractUniqueRefreshExtension
implements IRefreshExtension {
    @Override
    public void beforeRefresh(DDiagram viewPoint) {
    }

    @Override
    public void postRefresh(DDiagram diagram) {
        DiagramDescription desc = diagram.getDescription();
        if (desc != null) {
            for (DiagramElementMapping currentMapping : this.getAllMappings(desc)) {
                NodeMapping mapping;
                if (!this.isUnique(currentMapping)) continue;
                if (currentMapping instanceof NodeMapping) {
                    mapping = (NodeMapping)currentMapping;
                    this.clearNode(mapping, diagram);
                    continue;
                }
                if (currentMapping instanceof ContainerMapping) {
                    mapping = (ContainerMapping)currentMapping;
                    this.clearContainer((ContainerMapping)mapping, diagram);
                    continue;
                }
                if (!(currentMapping instanceof EdgeMapping)) continue;
                mapping = (EdgeMapping)currentMapping;
                this.clearEdge((EdgeMapping)mapping, diagram);
            }
        }
    }

    private void clearNode(NodeMapping nodeMapping, DDiagram viewPoint) {
        HashSet<NodeFilter> allViews = new HashSet<NodeFilter>();
        ArrayList nodes = Lists.newArrayList((Iterable)DDiagramSpecOperations.getNodesFromMapping((DDiagram)viewPoint, (NodeMapping)nodeMapping));
        for (DDiagramElement vpElement : nodes) {
            NodeFilter nodeFilter = null;
            if (vpElement instanceof DNodeListElement) {
                nodeFilter = new NodeFilter((DNodeListElement)vpElement);
            } else if (vpElement instanceof DNode) {
                nodeFilter = new NodeFilter((DNode)vpElement);
            }
            if (nodeFilter == null) continue;
            if (!allViews.contains(nodeFilter)) {
                allViews.add(nodeFilter);
                continue;
            }
            this.delete(vpElement);
        }
    }

    private void clearContainer(ContainerMapping containerMapping, DDiagram viewPoint) {
        HashSet<NodeFilter> allViews = new HashSet<NodeFilter>();
        ArrayList containers = Lists.newArrayList((Iterable)DDiagramSpecOperations.getContainersFromMapping((DDiagram)viewPoint, (ContainerMapping)containerMapping));
        for (DDiagramElement vpElement : containers) {
            NodeFilter nodeFilter = null;
            if (vpElement instanceof DNodeContainer) {
                nodeFilter = new NodeFilter((DNodeContainer)vpElement);
            } else if (vpElement instanceof DNodeList) {
                nodeFilter = new NodeFilter((DNodeList)vpElement);
            }
            if (nodeFilter == null) continue;
            if (!allViews.contains(nodeFilter)) {
                allViews.add(nodeFilter);
                continue;
            }
            this.delete(vpElement);
        }
    }

    private void clearEdge(EdgeMapping edgeMapping, DDiagram diagram) {
        HashSet<EdgeFilter> allViews = new HashSet<EdgeFilter>();
        ArrayList edges = Lists.newArrayList((Iterable)DDiagramSpecOperations.getEdgesFromMapping((DDiagram)diagram, (EdgeMapping)edgeMapping));
        for (DEdge edge : edges) {
            EdgeFilter edgeFilter = new EdgeFilter(edge);
            if (!allViews.contains(edgeFilter)) {
                allViews.add(edgeFilter);
                continue;
            }
            this.delete((DDiagramElement)edge);
        }
    }

    private void delete(DDiagramElement element) {
        Session session = SessionManager.INSTANCE.getSession(element.getTarget());
        ECrossReferenceAdapter xref = session != null ? session.getSemanticCrossReferencer() : null;
        SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)element).eDelete((EObject)element, xref);
    }

    public abstract boolean isUnique(DiagramElementMapping var1);

    private List<DiagramElementMapping> getAllMappings(DiagramDescription diagramDescription) {
        LinkedList<DiagramElementMapping> result = new LinkedList<DiagramElementMapping>();
        TreeIterator iterMappings = diagramDescription.eAllContents();
        while (iterMappings.hasNext()) {
            Object next = iterMappings.next();
            if (!(next instanceof DiagramElementMapping)) continue;
            result.add((DiagramElementMapping)next);
        }
        return result;
    }

    private static class NodeFilter {
        private EObject targetedElement;
        private List semanticElements;

        NodeFilter(DNode viewNode) {
            if (viewNode == null) {
                throw new IllegalArgumentException(Messages.NodeFilter_notNullErrorMsg);
            }
            this.targetedElement = viewNode.getTarget();
            this.semanticElements = viewNode.getSemanticElements();
        }

        NodeFilter(DNodeListElement viewNodeListElement) {
            if (viewNodeListElement == null) {
                throw new IllegalArgumentException(Messages.NodeFilter_notNullErrorMsg);
            }
            this.targetedElement = viewNodeListElement.getTarget();
            this.semanticElements = viewNodeListElement.getSemanticElements();
        }

        NodeFilter(DNodeList viewNodeList) {
            if (viewNodeList == null) {
                throw new IllegalArgumentException(Messages.NodeFilter_notNullErrorMsg);
            }
            this.targetedElement = viewNodeList.getTarget();
            this.semanticElements = viewNodeList.getSemanticElements();
        }

        NodeFilter(DNodeContainer viewNodeContainer) {
            if (viewNodeContainer == null) {
                throw new IllegalArgumentException(Messages.NodeFilter_notNullErrorMsg);
            }
            this.targetedElement = viewNodeContainer.getTarget();
            this.semanticElements = viewNodeContainer.getSemanticElements();
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeFilter) {
                boolean areEquals;
                NodeFilter nodeFilter = (NodeFilter)obj;
                if (nodeFilter.semanticElements == null) {
                    areEquals = this.semanticElements == null;
                } else if (this.semanticElements == null) {
                    areEquals = false;
                } else {
                    boolean bl = areEquals = this.semanticElements.containsAll(nodeFilter.semanticElements) && nodeFilter.semanticElements.contains(this.semanticElements);
                }
                if (areEquals) {
                    areEquals = nodeFilter.targetedElement == null ? this.targetedElement == null : this.targetedElement != null && this.targetedElement.equals(nodeFilter.targetedElement);
                    return areEquals;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.targetedElement == null ? 0 : this.targetedElement.hashCode();
        }
    }
}

