/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.Writer;

public class StringBuilderWriter
extends Writer {
    private final StringBuilder builder;

    public StringBuilderWriter() {
        this(16);
    }

    public StringBuilderWriter(int initialSize) {
        this(new StringBuilder(initialSize));
    }

    public StringBuilderWriter(StringBuilder builder) {
        this.builder = builder;
        this.lock = builder;
    }

    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void write(int c) {
        this.builder.append((char)c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.builder.append(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.builder.append(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.builder.append(str, off, off + len);
    }

    @Override
    public StringBuilderWriter append(CharSequence csq) {
        this.write(String.valueOf(csq));
        return this;
    }

    @Override
    public StringBuilderWriter append(CharSequence csq, int start, int end) {
        if (csq == null) {
            csq = "null";
        }
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public StringBuilderWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.builder.toString();
    }
}

