/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.model.TMModelManager;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;

public class LanguageConfigurationCharacterPairMatcher
implements ICharacterPairMatcher,
ICharacterPairMatcherExtension {
    private static final DefaultCharacterPairMatcher NOOP_MATCHER = new DefaultCharacterPairMatcher(new char[0]);
    private static final char[] NO_BRACKETS = new char[0];
    private static final char[] NO_QUOTES = new char[0];
    private @Nullable DefaultCharacterPairMatcher matcher;
    private @Nullable IDocument document;
    private char[] bracketPairs = NO_BRACKETS;
    private char[] quoteChars = NO_QUOTES;
    private int anchor = -1;

    public @Nullable IRegion match(IDocument document, int offset) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        IRegion tmBracketRegion = this.matchBracketsWithTM(document, offset);
        if (tmBracketRegion != null) {
            return tmBracketRegion;
        }
        IRegion bracketRegion = this.filterBracketRegion(document, matcher.match(document, offset));
        if (bracketRegion != null) {
            this.anchor = matcher.getAnchor();
            return bracketRegion;
        }
        IRegion quoteRegion = this.matchQuotes(document, offset);
        if (quoteRegion != null) {
            return quoteRegion;
        }
        this.anchor = -1;
        return null;
    }

    public @Nullable IRegion match(IDocument document, int offset, int length) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        if (length == 0) {
            return this.match(document, offset);
        }
        IRegion bracketRegion = this.filterBracketRegion(document, matcher.match(document, offset, length));
        if (bracketRegion != null) {
            this.anchor = matcher.getAnchor();
            return bracketRegion;
        }
        this.anchor = -1;
        return null;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public @Nullable IRegion findEnclosingPeerCharacters(IDocument document, int offset, int length) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        IRegion region = this.filterBracketRegion(document, matcher.findEnclosingPeerCharacters(document, offset, length));
        if (region == null) {
            this.anchor = -1;
            return null;
        }
        this.anchor = matcher.getAnchor();
        return region;
    }

    public boolean isMatchedChar(char ch) {
        IDocument document = this.document;
        if (document == null) {
            return false;
        }
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return this.isQuoteChar(ch) || matcher.isMatchedChar(ch);
    }

    public boolean isMatchedChar(char ch, IDocument document, int offset) {
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return this.isQuoteChar(ch) || matcher.isMatchedChar(ch, document, offset);
    }

    public boolean isRecomputationOfEnclosingPairRequired(IDocument document, IRegion currentSelection, IRegion previousSelection) {
        return this.getMatcher(document).isRecomputationOfEnclosingPairRequired(document, currentSelection, previousSelection);
    }

    public void dispose() {
        if (this.matcher != null) {
            this.matcher.dispose();
        }
        this.matcher = null;
        this.bracketPairs = NO_BRACKETS;
        this.quoteChars = NO_QUOTES;
        this.anchor = -1;
    }

    public void clear() {
        if (this.matcher != null) {
            this.matcher.clear();
        }
        this.anchor = -1;
    }

    private DefaultCharacterPairMatcher getMatcher(IDocument document) {
        DefaultCharacterPairMatcher matcher = this.matcher;
        if (matcher == null || !document.equals(this.document)) {
            IContentType[] contentTypes;
            this.document = document;
            ContentTypeInfo info = ContentTypeHelper.findContentTypes((IDocument)document);
            IContentType[] iContentTypeArray = contentTypes = info == null ? null : info.getContentTypes();
            if (contentTypes == null || contentTypes.length == 0) {
                this.matcher = matcher = NOOP_MATCHER;
                this.bracketPairs = NO_BRACKETS;
                this.quoteChars = NO_QUOTES;
            } else {
                boolean hasQuotes;
                StringBuilder surroundingBracketsChars = new StringBuilder();
                ArrayList<Character> surroundingQuotes = new ArrayList<Character>();
                LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
                IContentType[] iContentTypeArray2 = contentTypes;
                int n = contentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentType contentType = iContentTypeArray2[n2];
                    if (registry.shouldSurroundingPairs(contentType)) {
                        for (AutoClosingPair surroundingPair : registry.getSurroundingPairs(contentType)) {
                            if (Objects.equals(surroundingPair.open, surroundingPair.close) && surroundingPair.open.length() == 1) {
                                surroundingQuotes.add(Character.valueOf(surroundingPair.open.charAt(0)));
                                continue;
                            }
                            surroundingBracketsChars.append(surroundingPair.open);
                            surroundingBracketsChars.append(surroundingPair.close);
                        }
                    }
                    ++n2;
                }
                boolean hasBrackets = !surroundingBracketsChars.isEmpty();
                boolean bl = hasQuotes = !surroundingQuotes.isEmpty();
                if (!hasBrackets && !hasQuotes) {
                    this.matcher = matcher = NOOP_MATCHER;
                    this.bracketPairs = NO_BRACKETS;
                    this.quoteChars = NO_QUOTES;
                } else {
                    char[] quotes;
                    char[] bracketsChars;
                    if (hasBrackets) {
                        bracketsChars = new char[surroundingBracketsChars.length()];
                        surroundingBracketsChars.getChars(0, surroundingBracketsChars.length(), bracketsChars, 0);
                    } else {
                        bracketsChars = new char[]{};
                    }
                    if (hasQuotes) {
                        quotes = new char[surroundingQuotes.size()];
                        int i = 0;
                        while (i < surroundingQuotes.size()) {
                            quotes[i] = ((Character)surroundingQuotes.get(i)).charValue();
                            ++i;
                        }
                    } else {
                        quotes = NO_QUOTES;
                    }
                    this.bracketPairs = bracketsChars;
                    this.quoteChars = quotes;
                    matcher = hasBrackets ? new DefaultCharacterPairMatcher(bracketsChars) : NOOP_MATCHER;
                    this.matcher = matcher;
                }
            }
        }
        return matcher;
    }

    private boolean isQuoteChar(char ch) {
        char[] cArray = this.quoteChars;
        int n = this.quoteChars.length;
        int n2 = 0;
        while (n2 < n) {
            char quote = cArray[n2];
            if (quote == ch) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isBracketChar(char ch) {
        char[] cArray = this.bracketPairs;
        int n = this.bracketPairs.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ch) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isOpeningBracket(char ch) {
        int i = 0;
        while (i < this.bracketPairs.length) {
            if (this.bracketPairs[i] == ch) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private char getMatchingBracket(char ch) {
        int i = 0;
        while (i < this.bracketPairs.length) {
            char open = this.bracketPairs[i];
            char close = this.bracketPairs[i + 1];
            if (open == ch) {
                return close;
            }
            if (close == ch) {
                return open;
            }
            i += 2;
        }
        return '\u0000';
    }

    private @Nullable IRegion matchBracketsWithTM(IDocument document, int offset) {
        char mate;
        boolean searchForward;
        int bracketOffset;
        char bracketChar;
        int docLength;
        TMDocumentModel tmModel;
        block28: {
            block27: {
                block26: {
                    char currChar;
                    block25: {
                        if (this.bracketPairs.length == 0) {
                            return null;
                        }
                        if (offset < 0 || offset > document.getLength()) {
                            return null;
                        }
                        TMDocumentModel connectedModel = TMModelManager.INSTANCE.getConnectedModel(document);
                        if (connectedModel == null || connectedModel.getGrammar() == null) {
                            return null;
                        }
                        tmModel = connectedModel;
                        docLength = document.getLength();
                        if (docLength != 0) break block25;
                        return null;
                    }
                    char prevChar = offset > 0 ? document.getChar(offset - 1) : (char)'\u0000';
                    char c = currChar = offset < docLength ? document.getChar(offset) : (char)'\u0000';
                    if (this.isBracketChar(prevChar)) {
                        bracketChar = prevChar;
                        bracketOffset = offset - 1;
                        searchForward = this.isOpeningBracket(prevChar);
                        break block26;
                    }
                    if (this.isBracketChar(currChar)) {
                        bracketChar = currChar;
                        bracketOffset = offset;
                        searchForward = this.isOpeningBracket(currChar);
                        break block26;
                    }
                    return null;
                }
                if (!LanguageConfigurationCharacterPairMatcher.isInsideStringCommentOrCharacterToken((ITMModel)tmModel, document, bracketOffset)) break block27;
                return null;
            }
            mate = this.getMatchingBracket(bracketChar);
            if (mate != '\u0000') break block28;
            return null;
        }
        try {
            if (searchForward) {
                int startPos = bracketOffset + 1;
                int nesting = 0;
                int pos = startPos;
                while (pos < docLength) {
                    if (!LanguageConfigurationCharacterPairMatcher.isInsideStringCommentOrCharacterToken((ITMModel)tmModel, document, pos)) {
                        char c = document.getChar(pos);
                        if (c == bracketChar) {
                            ++nesting;
                        } else if (c == mate) {
                            if (nesting == 0) {
                                this.anchor = 1;
                                int start = bracketOffset;
                                int end = pos;
                                return new Region(Math.min(start, end), Math.abs(end - start) + 1);
                            }
                            --nesting;
                        }
                    }
                    ++pos;
                }
            } else {
                int startPos = bracketOffset - 1;
                int nesting = 0;
                int pos = startPos;
                while (pos >= 0) {
                    if (!LanguageConfigurationCharacterPairMatcher.isInsideStringCommentOrCharacterToken((ITMModel)tmModel, document, pos)) {
                        char c = document.getChar(pos);
                        if (c == bracketChar) {
                            ++nesting;
                        } else if (c == mate) {
                            if (nesting == 0) {
                                this.anchor = 0;
                                int start = pos;
                                int end = bracketOffset;
                                return new Region(Math.min(start, end), Math.abs(end - start) + 1);
                            }
                            --nesting;
                        }
                    }
                    --pos;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private @Nullable IRegion filterBracketRegion(IDocument document, @Nullable IRegion region) {
        if (region == null) {
            return null;
        }
        TMDocumentModel connectedModel = TMModelManager.INSTANCE.getConnectedModel(document);
        if (connectedModel == null || connectedModel.getGrammar() == null) {
            return region;
        }
        TMDocumentModel tmModel = connectedModel;
        int startOffset = region.getOffset();
        int endOffset = region.getOffset() + region.getLength() - 1;
        try {
            boolean startInString = LanguageConfigurationCharacterPairMatcher.isInsideStringCommentOrCharacterToken((ITMModel)tmModel, document, startOffset);
            boolean endInString = LanguageConfigurationCharacterPairMatcher.isInsideStringCommentOrCharacterToken((ITMModel)tmModel, document, endOffset);
            if (startInString != endInString) {
                return null;
            }
        }
        catch (BadLocationException e) {
            return region;
        }
        return region;
    }

    private @Nullable IRegion matchQuotes(IDocument document, int offset) {
        int mateOffset;
        DelimiterInfo delimiter;
        block23: {
            block22: {
                TMDocumentModel tmModel;
                block21: {
                    block20: {
                        block19: {
                            if (this.quoteChars.length == 0) {
                                return null;
                            }
                            if (offset < 0 || offset > document.getLength()) {
                                return null;
                            }
                            TMDocumentModel connectedModel = TMModelManager.INSTANCE.getConnectedModel(document);
                            if (connectedModel == null) {
                                return null;
                            }
                            tmModel = connectedModel;
                            if (tmModel.getGrammar() == null) {
                                return null;
                            }
                            try {
                                if (document.getLength() != 0) break block19;
                                return null;
                            }
                            catch (BadLocationException e) {
                                return null;
                            }
                        }
                        int docLength = document.getLength();
                        delimiter = null;
                        if (offset > 0) {
                            delimiter = LanguageConfigurationCharacterPairMatcher.findDelimiterAt((ITMModel)tmModel, document, offset - 1);
                        }
                        if (delimiter == null && offset < docLength) {
                            delimiter = LanguageConfigurationCharacterPairMatcher.findDelimiterAt((ITMModel)tmModel, document, offset);
                        }
                        if (delimiter != null) break block20;
                        return null;
                    }
                    if (this.isQuoteChar(delimiter.ch)) break block21;
                    return null;
                }
                mateOffset = -1;
                if (delimiter.isBegin && !delimiter.isEnd) {
                    mateOffset = LanguageConfigurationCharacterPairMatcher.findMatchingQuoteForward((ITMModel)tmModel, document, delimiter);
                    this.anchor = 1;
                    break block22;
                }
                if (delimiter.isEnd && !delimiter.isBegin) {
                    mateOffset = LanguageConfigurationCharacterPairMatcher.findMatchingQuoteBackward((ITMModel)tmModel, document, delimiter);
                    this.anchor = 0;
                    break block22;
                }
                if (delimiter.isBegin && delimiter.isEnd) {
                    mateOffset = LanguageConfigurationCharacterPairMatcher.findMatchingQuoteForward((ITMModel)tmModel, document, delimiter);
                    if (mateOffset != -1) {
                        this.anchor = 1;
                    } else {
                        mateOffset = LanguageConfigurationCharacterPairMatcher.findMatchingQuoteBackward((ITMModel)tmModel, document, delimiter);
                        if (mateOffset != -1) {
                            this.anchor = 0;
                        }
                    }
                    break block22;
                }
                return null;
            }
            if (mateOffset != -1) break block23;
            return null;
        }
        int start = Math.min(delimiter.offset, mateOffset);
        int end = Math.max(delimiter.offset, mateOffset) + 1;
        return new Region(start, end - start);
    }

    private static @Nullable DelimiterInfo findDelimiterAt(ITMModel tmModel, IDocument document, int offset) throws BadLocationException {
        if (offset < 0 || offset >= document.getLength()) {
            return null;
        }
        int lineIndex = document.getLineOfOffset(offset);
        int lineOffset = document.getLineOffset(lineIndex);
        int column = offset - lineOffset;
        List tokens = tmModel.getLineTokens(lineIndex);
        if (tokens == null || tokens.isEmpty()) {
            return null;
        }
        int lineLength = document.getLineLength(lineIndex);
        String lineText = document.get(lineOffset, lineLength);
        int i = 0;
        while (i < tokens.size()) {
            int tokenEnd;
            TMToken token = (TMToken)tokens.get(i);
            int tokenStart = token.startIndex;
            int n = tokenEnd = i + 1 < tokens.size() ? ((TMToken)tokens.get((int)(i + 1))).startIndex : lineLength;
            if (column >= tokenStart && column < tokenEnd) {
                if (column >= lineText.length()) {
                    return null;
                }
                char ch = lineText.charAt(column);
                if (!LanguageConfigurationCharacterPairMatcher.hasStringDelimiterScope(token)) {
                    return null;
                }
                boolean isBegin = LanguageConfigurationCharacterPairMatcher.isBeginDelimiter(token);
                boolean isEnd = LanguageConfigurationCharacterPairMatcher.isEndDelimiter(token);
                if (!isBegin && !isEnd) {
                    return null;
                }
                String stringScope = LanguageConfigurationCharacterPairMatcher.findStringScope(token);
                return new DelimiterInfo(offset, lineIndex, ch, isBegin, isEnd, stringScope);
            }
            ++i;
        }
        return null;
    }

    private static int findMatchingQuoteForward(ITMModel tmModel, IDocument document, DelimiterInfo start) throws BadLocationException {
        int lineCount = document.getNumberOfLines();
        char quoteChar = start.ch;
        @Nullable String expectedScope = start.stringScope;
        int line = start.lineIndex;
        while (line < lineCount) {
            List tokens = tmModel.getLineTokens(line);
            if (tokens != null && !tokens.isEmpty()) {
                int lineOffset = document.getLineOffset(line);
                int lineLength = document.getLineLength(line);
                String lineText = document.get(lineOffset, lineLength);
                int i = 0;
                while (i < tokens.size()) {
                    char ch;
                    TMToken token = (TMToken)tokens.get(i);
                    int tokenStartColumn = token.startIndex;
                    int tokenStartOffset = lineOffset + tokenStartColumn;
                    if ((line != start.lineIndex || tokenStartOffset > start.offset) && LanguageConfigurationCharacterPairMatcher.hasStringDelimiterScope(token) && LanguageConfigurationCharacterPairMatcher.matchesStringScope(expectedScope, token) && tokenStartColumn < lineText.length() && (ch = lineText.charAt(tokenStartColumn)) == quoteChar && LanguageConfigurationCharacterPairMatcher.isEndDelimiter(token)) {
                        return tokenStartOffset;
                    }
                    ++i;
                }
            }
            ++line;
        }
        return -1;
    }

    private static int findMatchingQuoteBackward(ITMModel tmModel, IDocument document, DelimiterInfo start) throws BadLocationException {
        char quoteChar = start.ch;
        @Nullable String expectedScope = start.stringScope;
        int line = start.lineIndex;
        while (line >= 0) {
            List tokens = tmModel.getLineTokens(line);
            if (tokens != null && !tokens.isEmpty()) {
                int lineOffset = document.getLineOffset(line);
                int lineLength = document.getLineLength(line);
                String lineText = document.get(lineOffset, lineLength);
                int i = tokens.size() - 1;
                while (i >= 0) {
                    char ch;
                    TMToken token = (TMToken)tokens.get(i);
                    int tokenStartColumn = token.startIndex;
                    int tokenStartOffset = lineOffset + tokenStartColumn;
                    if ((line != start.lineIndex || tokenStartOffset < start.offset) && LanguageConfigurationCharacterPairMatcher.hasStringDelimiterScope(token) && LanguageConfigurationCharacterPairMatcher.matchesStringScope(expectedScope, token) && tokenStartColumn < lineText.length() && (ch = lineText.charAt(tokenStartColumn)) == quoteChar && LanguageConfigurationCharacterPairMatcher.isBeginDelimiter(token)) {
                        return tokenStartOffset;
                    }
                    --i;
                }
            }
            --line;
        }
        return -1;
    }

    private static boolean hasStringDelimiterScope(TMToken token) {
        for (String scope : token.scopes) {
            if (!scope.contains("punctuation.definition.string") && !scope.contains("punctuation.definition.character")) continue;
            return true;
        }
        return false;
    }

    private static boolean isBeginDelimiter(TMToken token) {
        for (String scope : token.scopes) {
            if (!scope.contains("punctuation.definition.string") && !scope.contains("punctuation.definition.character") || !scope.contains("begin")) continue;
            return true;
        }
        return false;
    }

    private static boolean isEndDelimiter(TMToken token) {
        for (String scope : token.scopes) {
            if (!scope.contains("punctuation.definition.string") && !scope.contains("punctuation.definition.character") || !scope.contains("end")) continue;
            return true;
        }
        return false;
    }

    private static @Nullable String findStringScope(TMToken token) {
        for (String scope : token.scopes) {
            if (!scope.startsWith("string.") && !scope.contains(".string.")) continue;
            return scope;
        }
        return null;
    }

    private static boolean matchesStringScope(@Nullable String expectedScope, TMToken token) {
        if (expectedScope == null) {
            return true;
        }
        String otherScope = LanguageConfigurationCharacterPairMatcher.findStringScope(token);
        return Objects.equals(expectedScope, otherScope);
    }

    private static boolean isInsideStringCommentOrCharacterToken(ITMModel tmModel, IDocument document, int offset) throws BadLocationException {
        if (offset < 0 || offset >= document.getLength()) {
            return false;
        }
        int lineIndex = document.getLineOfOffset(offset);
        int lineOffset = document.getLineOffset(lineIndex);
        int column = offset - lineOffset;
        List tokens = tmModel.getLineTokens(lineIndex);
        if (tokens == null || tokens.isEmpty()) {
            return false;
        }
        int lineLength = document.getLineLength(lineIndex);
        int i = 0;
        while (i < tokens.size()) {
            int tokenEnd;
            TMToken token = (TMToken)tokens.get(i);
            int tokenStart = token.startIndex;
            int n = tokenEnd = i + 1 < tokens.size() ? ((TMToken)tokens.get((int)(i + 1))).startIndex : lineLength;
            if (column >= tokenStart && column < tokenEnd) {
                for (String scope : token.scopes) {
                    if (!scope.startsWith("string.") && !scope.contains(".string.") && !scope.startsWith("comment.") && !scope.contains(".comment.") && !scope.contains("constant.character")) continue;
                    return true;
                }
                return false;
            }
            ++i;
        }
        return false;
    }

    private record DelimiterInfo(int offset, int lineIndex, char ch, boolean isBegin, boolean isEnd, @Nullable String stringScope) {
    }
}

