/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.IModelUpdateStrategy;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class EMFCompareTextMergeViewerContentProvider
implements IMergeViewerContentProvider {
    private EMFCompareConfiguration fCompareConfiguration;
    private String fAncestorError;
    private String fLeftError;
    private String fRightError;

    public EMFCompareTextMergeViewerContentProvider(EMFCompareConfiguration cc) {
        this.fCompareConfiguration = cc;
    }

    private boolean hasError() {
        return this.fAncestorError != null || this.fLeftError != null || this.fRightError != null;
    }

    private boolean isEditable(Object element, IMergeViewer.MergeViewerSide side) {
        boolean isEditableInConfiguration = this.isEditableInConfiguration(side);
        if (isEditableInConfiguration && this.isCompareInputAdapterHoldingADiff(element)) {
            CompareInputAdapter inputAdapter = (CompareInputAdapter)((Object)element);
            IModelUpdateStrategy modelUpdateStrategy = inputAdapter.getModelUpdateStrategy();
            Diff diff = (Diff)inputAdapter.getComparisonObject();
            return modelUpdateStrategy.canUpdate(diff, side);
        }
        return isEditableInConfiguration;
    }

    private boolean isEditableInConfiguration(IMergeViewer.MergeViewerSide side) {
        boolean isEditableInConfiguration;
        switch (side) {
            case LEFT: {
                isEditableInConfiguration = this.fCompareConfiguration.isLeftEditable();
                break;
            }
            case RIGHT: {
                isEditableInConfiguration = this.fCompareConfiguration.isRightEditable();
                break;
            }
            default: {
                isEditableInConfiguration = false;
            }
        }
        return isEditableInConfiguration;
    }

    private boolean isCompareInputAdapterHoldingADiff(Object input) {
        return input instanceof CompareInputAdapter && ((CompareInputAdapter)((Object)input)).getComparisonObject() != null && ((CompareInputAdapter)((Object)input)).getComparisonObject() instanceof Diff;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer v, Object o1, Object o2) {
    }

    public void setAncestorError(String errorMessage) {
        this.fAncestorError = errorMessage;
    }

    public String getAncestorLabel(Object element) {
        if (this.fAncestorError != null) {
            return this.fAncestorError;
        }
        return this.fCompareConfiguration.getAncestorLabel(element);
    }

    public Image getAncestorImage(Object element) {
        if (this.fAncestorError != null) {
            return null;
        }
        return this.fCompareConfiguration.getAncestorImage(element);
    }

    public Object getAncestorContent(Object element) {
        if (element instanceof ICompareInput) {
            ITypedElement ancestor = ((ICompareInput)element).getAncestor();
            return ancestor;
        }
        return null;
    }

    public boolean showAncestor(Object element) {
        return element instanceof ICompareInput;
    }

    public void setLeftError(String errorMessage) {
        this.fLeftError = errorMessage;
    }

    public String getLeftLabel(Object element) {
        if (this.fLeftError != null) {
            return this.fLeftError;
        }
        return this.fCompareConfiguration.getLeftLabel(element);
    }

    public Image getLeftImage(Object element) {
        if (this.fLeftError != null) {
            return null;
        }
        return this.fCompareConfiguration.getLeftImage(element);
    }

    public Object getLeftContent(Object element) {
        if (element instanceof ICompareInput) {
            ITypedElement left = ((ICompareInput)element).getLeft();
            return left;
        }
        return null;
    }

    public boolean isLeftEditable(Object element) {
        if (this.hasError()) {
            return false;
        }
        return this.isEditable(element, IMergeViewer.MergeViewerSide.LEFT);
    }

    public void saveLeftContent(Object element, byte[] bytes) {
        Resource eResource;
        EList matches = this.fCompareConfiguration.getComparison().getMatches();
        EObject leftEObject = null;
        for (Match match : matches) {
            leftEObject = match.getLeft();
            if (leftEObject != null) break;
        }
        if (leftEObject != null && (eResource = leftEObject.eResource()) != null) {
            ResourceSet resourceSet = eResource.getResourceSet();
            if (resourceSet != null) {
                ResourceUtil.saveAllResources((ResourceSet)resourceSet, (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
            } else {
                ResourceUtil.saveResource((Resource)eResource, (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
            }
        }
    }

    public void setRightError(String errorMessage) {
        this.fRightError = errorMessage;
    }

    public String getRightLabel(Object element) {
        if (this.fRightError != null) {
            return this.fRightError;
        }
        return this.fCompareConfiguration.getRightLabel(element);
    }

    public Image getRightImage(Object element) {
        if (this.fRightError != null) {
            return null;
        }
        return this.fCompareConfiguration.getRightImage(element);
    }

    public Object getRightContent(Object element) {
        if (element instanceof ICompareInput) {
            ITypedElement right = ((ICompareInput)element).getRight();
            return right;
        }
        return null;
    }

    public boolean isRightEditable(Object element) {
        if (this.hasError()) {
            return false;
        }
        return this.isEditable(element, IMergeViewer.MergeViewerSide.RIGHT);
    }

    public void saveRightContent(Object element, byte[] bytes) {
        Resource eResource;
        EList matches = this.fCompareConfiguration.getComparison().getMatches();
        EObject rightEObject = null;
        for (Match match : matches) {
            rightEObject = match.getRight();
            if (rightEObject != null) break;
        }
        if (rightEObject != null && (eResource = rightEObject.eResource()) != null) {
            ResourceSet resourceSet = eResource.getResourceSet();
            if (resourceSet != null) {
                ResourceUtil.saveAllResources((ResourceSet)resourceSet, (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
            } else {
                ResourceUtil.saveResource((Resource)eResource, (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
            }
        }
    }
}

