/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details;

import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSIntro;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSOnCompletion;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPluginImages;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractSubDetails;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.ICSMaster;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details.CompCSConclusionTextListener;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details.CompCSIntroductionTextListener;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.details.DetailsMessages;
import org.eclipse.pde.internal.ui.parts.PDESourceViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.Section;

public class CompCSEnclosingTextDetails
extends CSAbstractSubDetails {
    private ICompCSTaskObject fDataTaskObject = null;
    private Section fEnclosingTextSection = null;
    private PDESourceViewer fIntroductionViewer = null;
    private PDESourceViewer fConclusionViewer = null;
    private CTabFolder fTabFolder = null;
    private static final int F_INTRODUCTION_TAB = 0;
    private static final int F_CONCLUSION_TAB = 1;
    private static final int F_NO_TAB = -1;
    private Composite fNotebookComposite = null;
    private StackLayout fNotebookLayout = null;
    private Composite fIntroductionComposite = null;
    private Composite fConclusionComposite = null;
    private String fTaskObjectLabelName;
    private final CompCSIntroductionTextListener fIntroductionListener = new CompCSIntroductionTextListener();
    private final CompCSConclusionTextListener fConclusionListener = new CompCSConclusionTextListener();

    public CompCSEnclosingTextDetails(int type, ICSMaster section) {
        super(section, "compcs-context");
        this.defineTaskObjectLabelName(type);
    }

    public void setData(ICompCSTaskObject object) {
        this.fDataTaskObject = object;
        this.fIntroductionListener.setData(object);
        this.fConclusionListener.setData(object);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    private void defineTaskObjectLabelName(int type) {
        this.fTaskObjectLabelName = type == 2 ? DetailsMessages.CompCSEnclosingTextDetails_task : DetailsMessages.CompCSEnclosingTextDetails_group;
    }

    @Override
    public void createDetails(Composite parent) {
        int style = 384;
        String description = NLS.bind((String)DetailsMessages.CompCSEnclosingTextDetails_description, (Object)this.fTaskObjectLabelName);
        this.fEnclosingTextSection = this.getPage().createUISection(parent, DetailsMessages.CompCSEnclosingTextDetails_enclosing, description, style);
        GridData data = new GridData(1808);
        this.fEnclosingTextSection.setLayoutData((Object)data);
        Composite sectionClient = this.getPage().createUISectionContainer((Composite)this.fEnclosingTextSection, 1);
        this.createUITabFolder(sectionClient);
        this.createUIIntroductionTab();
        this.createUIConclusionTab();
        this.createUINotebookComposite(sectionClient);
        this.createUIIntroductionViewer();
        this.createUIConclusionViewer();
        this.getToolkit().paintBordersFor(sectionClient);
        this.fEnclosingTextSection.setClient((Control)sectionClient);
        this.markDetailsPart((Control)this.fEnclosingTextSection);
    }

    private void createUITabFolder(Composite parent) {
        this.fTabFolder = new CTabFolder(parent, 0x800080);
        GridData data = new GridData(256);
        data.heightHint = 2;
        this.fTabFolder.setLayoutData((Object)data);
        this.getToolkit().adapt((Control)this.fTabFolder, true, true);
        FormColors colors = this.getToolkit().getColors();
        colors.initializeSectionToolBarColors();
        Color selectedColor = colors.getColor("org.eclipse.ui.forms.TB_BG");
        this.fTabFolder.setSelectionBackground(new Color[]{selectedColor, colors.getBackground()}, new int[]{100}, true);
    }

    private void createUIIntroductionTab() {
        CTabItem item = new CTabItem(this.fTabFolder, 0);
        item.setText(DetailsMessages.CompCSEnclosingTextDetails_introduction);
        item.setImage(PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().get(PDEUserAssistanceUIPluginImages.DESC_CSINTRO_OBJ));
    }

    private void createUIConclusionTab() {
        CTabItem item = new CTabItem(this.fTabFolder, 0);
        item.setText(DetailsMessages.CompCSEnclosingTextDetails_conclusion);
        item.setImage(PDEUserAssistanceUIPlugin.getDefault().getLabelProvider().get(PDEUserAssistanceUIPluginImages.DESC_CSCONCLUSION_OBJ));
    }

    private void createUINotebookComposite(Composite parent) {
        this.fNotebookComposite = this.getToolkit().createComposite(parent);
        GridData data = new GridData(768);
        this.fNotebookComposite.setLayoutData((Object)data);
        this.fNotebookLayout = new StackLayout();
        this.fNotebookComposite.setLayout((Layout)this.fNotebookLayout);
    }

    private void createUIIntroductionViewer() {
        this.fIntroductionComposite = this.createUIContainer(this.fNotebookComposite, 1);
        String description = NLS.bind((String)DetailsMessages.CompCSEnclosingTextDetails_label, (Object)this.fTaskObjectLabelName);
        Label label = this.getToolkit().createLabel(this.fIntroductionComposite, description, 64);
        GridData data = new GridData(768);
        label.setLayoutData((Object)data);
        this.fIntroductionViewer = new PDESourceViewer(this.getPage());
        this.fIntroductionViewer.createUI(this.fIntroductionComposite, 60, 60);
        this.getToolkit().paintBordersFor(this.fIntroductionComposite);
    }

    public boolean doGlobalAction(String actionId) {
        int index = this.fTabFolder.getSelectionIndex();
        PDESourceViewer viewer = null;
        if (index == 0) {
            viewer = this.fIntroductionViewer;
        } else if (index == 1) {
            viewer = this.fConclusionViewer;
        }
        return viewer.doGlobalAction(actionId);
    }

    private void createUIConclusionViewer() {
        this.fConclusionComposite = this.createUIContainer(this.fNotebookComposite, 1);
        String description = NLS.bind((String)DetailsMessages.CompCSEnclosingTextDetails_labelDescription, (Object)this.fTaskObjectLabelName);
        Label label = this.getToolkit().createLabel(this.fConclusionComposite, description, 64);
        GridData data = new GridData(768);
        label.setLayoutData((Object)data);
        this.fConclusionViewer = new PDESourceViewer(this.getPage());
        this.fConclusionViewer.createUI(this.fConclusionComposite, 60, 60);
        this.getToolkit().paintBordersFor(this.fConclusionComposite);
    }

    private Composite createUIContainer(Composite parent, int columns) {
        Composite container = this.getToolkit().createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.numColumns = columns;
        container.setLayout((Layout)layout);
        return container;
    }

    @Override
    public void hookListeners() {
        this.createListenersIntroductionViewer();
        this.createListenersConclusionViewer();
        this.createListenersTabFolder();
    }

    private void createListenersIntroductionViewer() {
        this.fIntroductionViewer.createUIListeners();
        this.fIntroductionViewer.getDocument().addDocumentListener((IDocumentListener)this.fIntroductionListener);
    }

    private void createListenersConclusionViewer() {
        this.fConclusionViewer.createUIListeners();
        this.fConclusionViewer.getDocument().addDocumentListener((IDocumentListener)this.fConclusionListener);
    }

    private void createListenersTabFolder() {
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompCSEnclosingTextDetails.this.updateTabFolder();
            }
        });
    }

    private void updateTabFolder() {
        int index = this.fTabFolder.getSelectionIndex();
        Control oldControl = this.fNotebookLayout.topControl;
        switch (index) {
            case -1: {
                this.fNotebookLayout.topControl = this.fIntroductionComposite;
                this.fTabFolder.setSelection(0);
                break;
            }
            case 0: {
                this.fNotebookLayout.topControl = this.fIntroductionComposite;
                break;
            }
            case 1: {
                this.fNotebookLayout.topControl = this.fConclusionComposite;
                break;
            }
        }
        if (oldControl != this.fNotebookLayout.topControl) {
            this.fNotebookComposite.layout();
        }
    }

    @Override
    public void updateFields() {
        if (this.fDataTaskObject == null) {
            return;
        }
        boolean editable = this.isEditableElement();
        this.updateTabFolder();
        this.updateIntroductionViewer(editable);
        this.updateConclusionViewer(editable);
    }

    private void updateIntroductionViewer(boolean editable) {
        ICompCSIntro intro = this.fDataTaskObject.getFieldIntro();
        this.fIntroductionListener.setBlockEvents(true);
        if (intro != null && PDETextHelper.isDefined((String)intro.getFieldContent())) {
            this.fIntroductionViewer.getDocument().set(intro.getFieldContent());
        } else {
            this.fIntroductionViewer.getDocument().set("");
        }
        this.fIntroductionListener.setBlockEvents(false);
        this.fIntroductionViewer.getViewer().setEditable(editable);
    }

    private void updateConclusionViewer(boolean editable) {
        ICompCSOnCompletion conclusion = this.fDataTaskObject.getFieldOnCompletion();
        this.fConclusionListener.setBlockEvents(true);
        if (conclusion != null && PDETextHelper.isDefined((String)conclusion.getFieldContent())) {
            this.fConclusionViewer.getDocument().set(conclusion.getFieldContent());
        } else {
            this.fConclusionViewer.getDocument().set("");
        }
        this.fConclusionListener.setBlockEvents(false);
        this.fConclusionViewer.getViewer().setEditable(editable);
    }

    public void dispose() {
        if (this.fIntroductionViewer != null) {
            this.fIntroductionViewer.unsetMenu();
            this.fIntroductionViewer = null;
        }
        if (this.fConclusionViewer != null) {
            this.fConclusionViewer.unsetMenu();
            this.fConclusionViewer = null;
        }
        super.dispose();
    }

    public boolean canPaste(Clipboard clipboard) {
        int index = this.fTabFolder.getSelectionIndex();
        PDESourceViewer viewer = null;
        if (index == 0) {
            viewer = this.fIntroductionViewer;
        } else if (index == 1) {
            viewer = this.fConclusionViewer;
        }
        return viewer.canPaste();
    }
}

