/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.tabs;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.ContributionUriCellEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EmfUtil;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.TableViewerUtil;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.UriDialogType;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

class EAttributeEditingSupport
extends EditingSupport {
    private final String attName;
    private final TableViewer tableViewer;
    private boolean wasNull;
    private final IEclipseContext context;

    public EAttributeEditingSupport(TableViewer tableViewer, String attName, IEclipseContext context) {
        super((ColumnViewer)tableViewer);
        this.tableViewer = tableViewer;
        this.attName = attName;
        this.context = context;
    }

    protected CellEditor getCellEditor(Object element) {
        switch (EAttributeEditingSupport.getAttributeType(element, this.attName)) {
            case BOOLEAN: {
                return new CheckboxCellEditor((Composite)this.tableViewer.getTable(), 32);
            }
        }
        if ("contributionURI".equals(this.attName)) {
            return new ContributionUriCellEditor((Composite)this.tableViewer.getTable(), 0, this.context, UriDialogType.BUNDLECLASS);
        }
        if ("iconURI".equals(this.attName)) {
            return new ContributionUriCellEditor((Composite)this.tableViewer.getTable(), 0, this.context, UriDialogType.ICON);
        }
        return new TextCellEditor((Composite)this.tableViewer.getTable(), 0);
    }

    public static ATT_TYPE getAttributeType(Object element, String attName) {
        EAttribute att = EmfUtil.getAttribute((EObject)element, attName);
        if (att == null) {
            return ATT_TYPE.NOT_AN_ATTRIBUTE;
        }
        String instanceTypeName = att.getEType().getInstanceTypeName();
        if (instanceTypeName.equals(String.class.getName())) {
            return ATT_TYPE.STRING;
        }
        if (instanceTypeName.equals(Boolean.TYPE.getName())) {
            return ATT_TYPE.BOOLEAN;
        }
        if (instanceTypeName.equals(Integer.TYPE.getName())) {
            return ATT_TYPE.INTEGER;
        }
        return ATT_TYPE.OTHER;
    }

    protected boolean canEdit(Object element) {
        EAttribute att = EmfUtil.getAttribute((EObject)element, this.attName);
        if (att == null) {
            return false;
        }
        String instanceTypeName = att.getEType().getInstanceTypeName();
        if (instanceTypeName.equals(String.class.getName())) {
            return true;
        }
        if (instanceTypeName.equals(Boolean.TYPE.getName())) {
            return true;
        }
        return instanceTypeName.equals(Integer.TYPE.getName());
    }

    protected Object getValue(Object element) {
        EObject eObject = (EObject)element;
        Object value = eObject.eGet((EStructuralFeature)EmfUtil.getAttribute(eObject, this.attName));
        switch (EAttributeEditingSupport.getAttributeType(element, this.attName)) {
            case BOOLEAN: {
                this.wasNull = false;
                break;
            }
            case INTEGER: {
                if (value == null) {
                    value = "";
                    this.wasNull = true;
                    break;
                }
                return Integer.toString((Integer)value);
            }
            default: {
                if (value == null) {
                    value = "";
                    this.wasNull = true;
                    break;
                }
                this.wasNull = false;
            }
        }
        return value;
    }

    protected void setValue(Object element, Object value) {
        EObject eObject = (EObject)element;
        switch (EAttributeEditingSupport.getAttributeType(element, this.attName)) {
            case INTEGER: {
                if (value.equals("")) {
                    value = null;
                    break;
                }
                try {
                    value = Integer.parseInt(value.toString());
                    break;
                }
                catch (Exception e) {
                    return;
                }
            }
            default: {
                if (!value.equals("") || !this.wasNull) break;
                value = null;
            }
        }
        Command cmd = SetCommand.create((EditingDomain)((EditingDomain)this.context.get(EditingDomain.class)), (Object)eObject, (Object)EmfUtil.getAttribute(eObject, this.attName), (Object)value);
        ((EditingDomain)this.context.get(EditingDomain.class)).getCommandStack().execute(cmd);
        TableViewerUtil.updateAndPack(this.tableViewer, eObject);
    }

    public static TableViewerColumn getTableViewerColumn(TableViewer viewer, int index) {
        return (TableViewerColumn)viewer.getTable().getColumn(index).getData("org.eclipse.jface.columnViewer");
    }

    public static enum ATT_TYPE {
        STRING,
        BOOLEAN,
        INTEGER,
        NOT_AN_ATTRIBUTE,
        OTHER;

    }
}

