/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.repository;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.repository.IRepository;

public class RepositoryInfo
implements IRepository {
    private final String id;
    private final String repositoryUrl;
    private final File basedir;
    private final int scope;
    private final AuthenticationInfo authInfo;
    private String uid;
    private String mirrorId;
    private String mirrorOf;
    private final Set<IPath> projects = new HashSet<IPath>();

    public RepositoryInfo(String id, String repositoryUrl, int scope, AuthenticationInfo authInfo) {
        this(id, repositoryUrl, RepositoryInfo.getBasedir(repositoryUrl), scope, authInfo);
    }

    public RepositoryInfo(String id, String repositoryUrl, File basedir, int scope, AuthenticationInfo authInfo) {
        this.id = id;
        this.repositoryUrl = repositoryUrl;
        this.scope = scope;
        this.authInfo = authInfo;
        this.basedir = basedir;
    }

    @Override
    public AuthenticationInfo getAuthenticationInfo() {
        return this.authInfo;
    }

    @Override
    public String getUrl() {
        return this.repositoryUrl;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getMirrorId() {
        return this.mirrorId;
    }

    @Override
    public String getMirrorOf() {
        return this.mirrorOf;
    }

    public void setMirrorOf(String mirrorOf) {
        this.mirrorOf = mirrorOf;
    }

    public void setMirrorId(String mirrorId) {
        this.mirrorId = mirrorId;
    }

    public Set<IPath> getProjects() {
        return this.projects;
    }

    public void addProject(IPath project) {
        if (this.isScope(16)) {
            this.projects.add(project);
        }
    }

    public void removeProject(IPath project) {
        this.projects.remove(project);
    }

    @Override
    public String getUid() {
        if (this.uid == null) {
            this.uid = RepositoryInfo.getUid(this.id, this.repositoryUrl, this.authInfo != null ? this.authInfo.getUserName() : null);
        }
        return this.uid;
    }

    public static String getUid(String id, String repositoryUrl, String username) {
        StringBuilder sb = new StringBuilder();
        if (id != null) {
            sb.append(id);
        }
        sb.append('|').append(repositoryUrl);
        if (username != null) {
            sb.append('|').append(username);
        }
        return DigestUtils.md5Hex((String)sb.toString());
    }

    @Override
    public String getProtocol() {
        return RepositoryInfo.getProtocol(this.repositoryUrl);
    }

    public static String getProtocol(String repositoryUrl) {
        int pos = repositoryUrl.indexOf(":");
        if (pos == -1) {
            return "file";
        }
        return repositoryUrl.substring(0, pos).trim();
    }

    public static File getBasedir(String repositoryUrl) {
        if ("file".equalsIgnoreCase(RepositoryInfo.getProtocol(repositoryUrl))) {
            MavenArtifactRepository trick = new MavenArtifactRepository();
            trick.setUrl(repositoryUrl);
            return new File(trick.getBasedir());
        }
        return null;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    @Override
    public boolean isScope(int scope) {
        return (this.scope & scope) != 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.id != null) {
            sb.append(this.id).append('|');
        }
        sb.append(this.repositoryUrl);
        return sb.toString();
    }
}

