/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.lsp.clangd.IClangdCommandLineValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.ranking:Integer=0"})
public final class ClangdCommandLineValidator
implements IClangdCommandLineValidator {
    private static final String CLANGD_VERSION_PATTERN = ".*clangd\\s+version\\s+(\\d+\\.)?(\\d+\\.)?(\\*|\\d+).*";
    private final Pattern pattern = Pattern.compile(".*clangd\\s+version\\s+(\\d+\\.)?(\\d+\\.)?(\\*|\\d+).*");
    private static final String major = "$1";
    Path tempFile = null;

    @Override
    public IStatus validateCommandLineOptions(List<String> commands) {
        IStatus result = this.supportsValidation(commands.getFirst());
        if (!result.isOK()) {
            return result;
        }
        try {
            IStatus iStatus = this.createTempCFile().map(temp -> this.getValidationCommands((Path)temp, commands)).map(this::getProcessBuilder).map(pb -> {
                try {
                    Process process = pb.start();
                    return this.getProcessResult(process, process.getErrorStream(), new OptionsChecker(), new StringBuilder("Validate clangd command line options"));
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.cdt.lsp.clangd", e.getMessage(), (Throwable)e);
                }
            }).orElse(Status.OK_STATUS);
            return iStatus;
        }
        finally {
            this.deleteTempCFile();
        }
    }

    private IStatus supportsValidation(String clangdBinaryPath) {
        ArrayList<String> commands = new ArrayList<String>(2);
        commands.add(clangdBinaryPath);
        commands.add("--version");
        return Optional.ofNullable(this.getProcessBuilder(commands)).map(pb -> {
            try {
                Process process = pb.start();
                return this.getProcessResult(process, process.getInputStream(), new VersionChecker(), new StringBuilder("Check clangd version"));
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.cdt.lsp.clangd", e.getMessage(), (Throwable)e);
            }
        }).orElse((IStatus)new Status(4, "org.eclipse.cdt.lsp.clangd", "Cannot determine if clangd command line validation is supported"));
    }

    private Optional<Path> createTempCFile() {
        try {
            this.tempFile = Files.createTempFile("dummy", ".c", new FileAttribute[0]);
            return Optional.of(this.tempFile);
        }
        catch (IOException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    private void deleteTempCFile() {
        try {
            if (this.tempFile != null) {
                Files.deleteIfExists(this.tempFile);
            }
        }
        catch (IOException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
    }

    private ProcessBuilder getProcessBuilder(List<String> commands) {
        return commands.isEmpty() ? null : new ProcessBuilder(commands);
    }

    private List<String> getValidationCommands(Path tempFile, List<String> commands) {
        if (commands.isEmpty()) {
            return commands;
        }
        commands.add("--check=" + tempFile.toAbsolutePath().toString());
        commands.add("--log=error");
        return commands;
    }

    private IStatus getProcessResult(Process process, InputStream inputStream, Consumer<String> consumer, StringBuilder description) {
        Thread readerThread = this.getReaderThread("CDT clangd version check", inputStream, consumer);
        readerThread.start();
        try {
            boolean exited = process.waitFor(5000L, TimeUnit.MILLISECONDS);
            if (exited && consumer instanceof IClangdChecker) {
                IClangdChecker validator = (IClangdChecker)((Object)consumer);
                return validator.getResult();
            }
            if (!exited) {
                process.destroyForcibly();
            }
            description.append(": process timeout or consumer is not a instance of IClangdValidator!");
            return new Status(2, "org.eclipse.cdt.lsp.clangd", description.toString());
        }
        catch (InterruptedException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
            return new Status(2, "org.eclipse.cdt.lsp.clangd", description.toString());
        }
    }

    private Thread getReaderThread(String threadName, final InputStream stderr, final Consumer<String> validator) {
        return new Thread(threadName){

            @Override
            public void run() {
                if (stderr == null) {
                    Platform.getLog(this.getClass()).error("input stream is null!");
                    return;
                }
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stderr));){
                        String line = reader.readLine();
                        while (line != null) {
                            validator.accept(line);
                            line = reader.readLine();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    private boolean versionOK(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.matches()) {
            return false;
        }
        return this.majorVersionOK(matcher, major, line);
    }

    private boolean majorVersionOK(Matcher matcher, String majorExpression, String line) {
        try {
            String majorVersion = matcher.replaceAll(majorExpression).replace('.', ' ').trim();
            if (!majorVersion.isBlank()) {
                return Integer.parseInt(majorVersion) >= 12;
            }
        }
        catch (NumberFormatException e) {
            Platform.getLog(this.getClass()).error("Cannot parse clangd major version number from line: " + line);
        }
        return false;
    }

    private static interface IClangdChecker {
        public IStatus getResult();
    }

    private class OptionsChecker
    implements Consumer<String>,
    IClangdChecker {
        private static final String CLANGD_ERROR_PATTERN = ".*(?<!\\.)clangd(.exe)? *:.+";
        private final String ls = System.lineSeparator();
        private StringBuilder builder = new StringBuilder();

        private OptionsChecker() {
        }

        @Override
        public void accept(String line) {
            if (line.matches(CLANGD_ERROR_PATTERN)) {
                if (this.builder.isEmpty()) {
                    this.builder.append(this.ls);
                }
                this.builder.append(this.ls);
                this.builder.append(line);
            }
        }

        @Override
        public IStatus getResult() {
            if (this.builder.isEmpty()) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.cdt.lsp.clangd", this.builder.toString());
        }
    }

    private class VersionChecker
    implements Consumer<String>,
    IClangdChecker {
        private IStatus result = new Status(2, "org.eclipse.cdt.lsp.clangd", "The clangd version does not support command line option check!");

        private VersionChecker() {
        }

        @Override
        public void accept(String line) {
            if (ClangdCommandLineValidator.this.versionOK(line)) {
                this.result = Status.OK_STATUS;
            }
        }

        @Override
        public IStatus getResult() {
            return this.result;
        }
    }
}

